/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.gc.client.experimental.customGrid;

import com.github.gwtbootstrap.client.ui.DataGrid;
import com.github.gwtbootstrap.client.ui.Icon;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.jbpm.console.ng.gc.client.experimental.customGrid.ColumnConfigRowWidget;
import org.jbpm.console.ng.gc.client.experimental.customGrid.ColumnSettings;
import org.jbpm.console.ng.gc.client.experimental.customGrid.GridColumnsHelper;

public class ColumnSelectionWidget
extends Composite {
    private static ColumnSelectionWidgetUIBinder uiBinder = (ColumnSelectionWidgetUIBinder)GWT.create(ColumnSelectionWidgetUIBinder.class);
    @UiField
    Icon dynGridIcon;
    PopupPanel columnSelectorPopup;
    private GridColumnsHelper gridColumnsHelper;

    public ColumnSelectionWidget() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.dynGridIcon.getElement().getStyle().setPaddingLeft(4.0, Style.Unit.PX);
        this.dynGridIcon.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        this.dynGridIcon.sinkEvents(1);
        this.dynGridIcon.addHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                ColumnSelectionWidget.this.iconClicked();
            }
        }, (GwtEvent.Type)ClickEvent.getType());
    }

    public void setDataGrid(String gridId, DataGrid dataGrid) {
        if (dataGrid == null) {
            Window.alert((String)"Grid customization widget is not correctly configured!");
            return;
        }
        this.gridColumnsHelper = new GridColumnsHelper(gridId, dataGrid);
        this.columnSelectorPopup = new PopupPanel(true);
        this.columnSelectorPopup.setTitle("Configure columns");
        this.columnSelectorPopup.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> popupPanelCloseEvent) {
                ColumnSelectionWidget.this.gridColumnsHelper.saveGridColumnsConfig();
                ColumnSelectionWidget.this.columnSelectorPopup.hide();
            }
        });
        VerticalPanel columnPopupMainPanel = new VerticalPanel();
        for (final Map.Entry entry : this.gridColumnsHelper.getGridColumnsConfig().entrySet()) {
            ColumnSettings columnSettings = (ColumnSettings)entry.getValue();
            final CheckBox checkBox = new CheckBox();
            checkBox.setValue(Boolean.valueOf(columnSettings.isVisible()));
            checkBox.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ColumnSelectionWidget.this.gridColumnsHelper.applyGridColumnConfig((Integer)entry.getKey(), checkBox.getValue());
                }
            });
            columnPopupMainPanel.add((Widget)new ColumnConfigRowWidget(checkBox, columnSettings.getColumnLabel()));
        }
        this.columnSelectorPopup.add((Widget)columnPopupMainPanel);
    }

    public void applyGridColumnsConfig() {
        this.gridColumnsHelper.applyGridColumnsConfig();
    }

    private void iconClicked() {
        this.columnSelectorPopup.setPopupPosition(this.dynGridIcon.getAbsoluteLeft(), this.dynGridIcon.getAbsoluteTop() + this.dynGridIcon.getOffsetHeight());
        this.columnSelectorPopup.show();
    }

    static interface ColumnSelectionWidgetUIBinder
    extends UiBinder<Widget, ColumnSelectionWidget> {
    }
}

