/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.gc.client.experimental.customGrid;

import com.github.gwtbootstrap.client.ui.DataGrid;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.console.ng.gc.client.experimental.customGrid.ColumnSettings;
import org.jbpm.console.ng.gc.client.experimental.customGrid.GridColumnsConfig;

public class GridColumnsHelper {
    private static Map<String, GridColumnsConfig> gridColumnsConfigs = new HashMap<String, GridColumnsConfig>(10);
    private Map<Integer, CachedColumn> cachedColumns = new HashMap<Integer, CachedColumn>(10);
    private DataGrid dataGrid;
    private GridColumnsConfig gridColumnsConfig;
    private ColumnIndexHelper indexManager;

    public GridColumnsHelper(String gridId, DataGrid dataGrid) {
        this.dataGrid = dataGrid;
        this.gridColumnsConfig = gridColumnsConfigs.get(gridId);
        if (this.gridColumnsConfig == null) {
            this.gridColumnsConfig = this.initializeGridColumnsConfig(gridId, dataGrid);
            gridColumnsConfigs.put(gridId, this.gridColumnsConfig);
        }
        for (int i = 0; i < dataGrid.getColumnCount(); ++i) {
            Column column = dataGrid.getColumn(i);
            this.cachedColumns.put(i, new CachedColumn(column, dataGrid.getHeader(i), dataGrid.getFooter(i), dataGrid.getColumnWidth(column)));
        }
        this.indexManager = new ColumnIndexHelper(this.cachedColumns.size());
    }

    public void saveGridColumnsConfig() {
        if (this.gridColumnsConfig != null) {
            gridColumnsConfigs.put(this.gridColumnsConfig.getGridId(), this.gridColumnsConfig);
        }
    }

    public void applyGridColumnsConfig() {
        if (this.gridColumnsConfig == null) {
            throw new RuntimeException("Grid customization widget is not correctly configured!");
        }
        for (Map.Entry entry : this.gridColumnsConfig.entrySet()) {
            if (((ColumnSettings)entry.getValue()).isVisible()) continue;
            this.applyGridColumnConfig((Integer)entry.getKey(), false);
        }
    }

    public void applyGridColumnConfig(int selectedColumnIndex, boolean insertColumn) {
        ColumnSettings columnSettings = (ColumnSettings)this.gridColumnsConfig.get(selectedColumnIndex);
        columnSettings.setVisible(insertColumn);
        if (!insertColumn) {
            int removeIndex = this.columnRemoved(selectedColumnIndex);
            this.dataGrid.removeColumn(removeIndex);
        } else {
            int addIndex = this.columnAdded(selectedColumnIndex);
            this.dataGrid.insertColumn(addIndex, this.getColumn(selectedColumnIndex), this.getColumnHeader(selectedColumnIndex), this.getColumnFooter(selectedColumnIndex));
            this.dataGrid.setColumnWidth(addIndex, this.getColumnWidth(selectedColumnIndex));
        }
        this.dataGrid.redraw();
    }

    public GridColumnsConfig getGridColumnsConfig() {
        return this.gridColumnsConfig;
    }

    private int columnRemoved(int selectedColumnIndex) {
        return this.indexManager.indexDropped(selectedColumnIndex);
    }

    private int columnAdded(int selectedColumnIndex) {
        return this.indexManager.indexAdded(selectedColumnIndex);
    }

    private String getColumnWidth(int cacheIndex) {
        CachedColumn cachedColumn = this.cachedColumns.get(cacheIndex);
        return cachedColumn != null ? cachedColumn.getColumnWidth() : "";
    }

    private Header<?> getColumnHeader(int cacheIndex) {
        CachedColumn cachedColumn = this.cachedColumns.get(cacheIndex);
        return cachedColumn != null ? cachedColumn.getColumnHeader() : null;
    }

    private Header<?> getColumnFooter(int cacheIndex) {
        CachedColumn cachedColumn = this.cachedColumns.get(cacheIndex);
        return cachedColumn != null ? cachedColumn.getColumnFooter() : null;
    }

    private Column<?, ?> getColumn(int cacheIndex) {
        CachedColumn cachedColumn = this.cachedColumns.get(cacheIndex);
        return cachedColumn != null ? cachedColumn.getColumn() : null;
    }

    private GridColumnsConfig initializeGridColumnsConfig(String gridId, DataGrid dataGrid) {
        GridColumnsConfig gridColumnsConfig = new GridColumnsConfig(gridId);
        for (int i = 0; i < dataGrid.getColumnCount(); ++i) {
            gridColumnsConfig.put(i, new ColumnSettings(true, (String)dataGrid.getHeader(i).getValue()));
        }
        return gridColumnsConfig;
    }

    private class ColumnIndexHelper {
        private int[] selectorIndexes;
        private int[] gridIndexes;

        private ColumnIndexHelper(int maxIndex) {
            this.selectorIndexes = new int[maxIndex];
            this.gridIndexes = new int[maxIndex];
            for (int i = 0; i < maxIndex; ++i) {
                this.selectorIndexes[i] = i;
                this.gridIndexes[i] = i;
            }
        }

        private int indexDropped(int selectedColumnIndex) {
            int current;
            int counter = current = this.gridIndexes[selectedColumnIndex];
            if (current == -1) {
                throw new RuntimeException("Internal error: index to be dropped (" + selectedColumnIndex + ") was not set (" + current + "). " + "Probably the widget's client forgot to call applyGridColumnsConfig().");
            }
            for (int i = selectedColumnIndex; i < this.selectorIndexes.length; ++i) {
                if (i == selectedColumnIndex) {
                    this.gridIndexes[i] = -1;
                    continue;
                }
                if (this.gridIndexes[i] == -1) continue;
                this.gridIndexes[i] = counter++;
            }
            return current;
        }

        private int indexAdded(int selectedColumnIndex) {
            int i;
            int current = this.gridIndexes[selectedColumnIndex];
            if (current != -1) {
                throw new RuntimeException("Internal error: index to be added (" + selectedColumnIndex + ") was internally still set (" + current + "). " + "Probably the widget's client forgot to call applyGridColumnsConfig().");
            }
            int nextValidIndex = 0;
            for (i = 0; i < selectedColumnIndex; ++i) {
                if (this.gridIndexes[i] == -1) continue;
                nextValidIndex = this.gridIndexes[i] + 1;
            }
            for (i = selectedColumnIndex; i < this.selectorIndexes.length; ++i) {
                if (i == selectedColumnIndex) {
                    this.gridIndexes[i] = nextValidIndex;
                    continue;
                }
                if (this.gridIndexes[i] == -1) continue;
                this.gridIndexes[i] = this.gridIndexes[i] + 1;
            }
            return nextValidIndex;
        }
    }

    private class CachedColumn {
        private Column<?, ?> column;
        private Header<?> columnHeader;
        private Header<?> columnFooter;
        private String columnWidth;

        private CachedColumn(Column<?, ?> column, Header<?> columnHeader, Header<?> columnFooter, String columnWidth) {
            this.column = column;
            this.columnHeader = columnHeader;
            this.columnFooter = columnFooter;
            this.columnWidth = columnWidth;
        }

        public Column<?, ?> getColumn() {
            return this.column;
        }

        public Header<?> getColumnFooter() {
            return this.columnFooter;
        }

        public Header<?> getColumnHeader() {
            return this.columnHeader;
        }

        public String getColumnWidth() {
            return this.columnWidth;
        }
    }
}

