/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.gc.client.list.base;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.RadioButton;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import java.util.ArrayList;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.ga.model.GenericSummary;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.i18n.Constants;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.tables.FilterPagedTable;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractMultiGridView<T extends GenericSummary, V extends AbstractListPresenter>
extends Composite
implements RequiresResize {
    public static String FILTER_TABLE_SETTINGS = "tableSettings";
    @Inject
    public User identity;
    @Inject
    protected Event<NotificationEvent> notification;
    @Inject
    protected PlaceManager placeManager;
    @Inject
    private Caller<UserPreferencesService> preferencesService;
    protected V presenter;
    protected FilterPagedTable<T> filterPagedTable;
    protected ExtendedPagedTable<T> currentListGrid;
    private PopupPanel popup = new PopupPanel(true);
    protected RowStyles<T> selectedStyles = new RowStyles<T>(){

        public String getStyleNames(T row, int rowIndex) {
            if (rowIndex == AbstractMultiGridView.this.selectedRow) {
                return "selected";
            }
            return null;
        }
    };
    protected NoSelectionModel<T> selectionModel;
    protected T selectedItem;
    protected int selectedRow = -1;
    protected Column actionsColumn;
    protected DefaultSelectionEventManager<T> noActionColumnManager;

    public void init(final V presenter, final GridGlobalPreferences preferences, final Button createNewGridButton) {
        this.presenter = presenter;
        this.filterPagedTable = new FilterPagedTable();
        this.initWidget(this.filterPagedTable.makeWidget());
        this.filterPagedTable.setPreferencesService(this.preferencesService);
        ((UserPreferencesService)this.preferencesService.call((RemoteCallback)new RemoteCallback<MultiGridPreferencesStore>(){

            public void callback(MultiGridPreferencesStore multiGridPreferencesStore) {
                if (multiGridPreferencesStore == null) {
                    multiGridPreferencesStore = new MultiGridPreferencesStore(preferences.getKey());
                }
                String selectedGridId = multiGridPreferencesStore.getSelectedGrid();
                AbstractMultiGridView.this.filterPagedTable.setMultiGridPreferencesStore(multiGridPreferencesStore);
                ArrayList existingGrids = multiGridPreferencesStore.getGridsId();
                if (existingGrids != null && existingGrids.size() > 0) {
                    for (int i = 0; i < existingGrids.size(); ++i) {
                        String key = (String)existingGrids.get(i);
                        final ExtendedPagedTable extendedPagedTable = AbstractMultiGridView.this.createGridInstance(preferences, key);
                        AbstractMultiGridView.this.currentListGrid = extendedPagedTable;
                        presenter.addDataDisplay(extendedPagedTable);
                        extendedPagedTable.setDataProvider(presenter.dataProvider);
                        final String filterKey = key;
                        AbstractMultiGridView.this.filterPagedTable.addTab(extendedPagedTable, key, new Command(){

                            public void execute() {
                                AbstractMultiGridView.this.currentListGrid = extendedPagedTable;
                                AbstractMultiGridView.this.applyFilterOnPresenter(filterKey);
                            }
                        });
                        if (AbstractMultiGridView.this.currentListGrid == null || !key.equals(selectedGridId)) continue;
                        AbstractMultiGridView.this.currentListGrid = extendedPagedTable;
                    }
                    AbstractMultiGridView.this.filterPagedTable.addAddTableButton(createNewGridButton);
                    if (selectedGridId != null) {
                        multiGridPreferencesStore.setSelectedGrid(selectedGridId);
                        ((UserPreferencesService)AbstractMultiGridView.this.preferencesService.call()).saveUserPreferences((UserPreference)multiGridPreferencesStore);
                        AbstractMultiGridView.this.filterPagedTable.setSelectedTab();
                    }
                } else {
                    AbstractMultiGridView.this.initDefaultFilters(preferences, createNewGridButton);
                }
                AbstractMultiGridView.this.initSelectionModel();
            }
        })).loadUserPreferences(preferences.getKey(), UserPreferencesType.MULTIGRIDPREFERENCES);
    }

    public void onResize() {
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    public void initGenericToolBar(ExtendedPagedTable<T> extendedPagedTable) {
        Button refreshButton = new Button();
        refreshButton.setIcon(IconType.REFRESH);
        refreshButton.setTitle(Constants.INSTANCE.Refresh());
        refreshButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((AbstractListPresenter)AbstractMultiGridView.this.presenter).refreshGrid();
            }
        });
        extendedPagedTable.getRightToolbar().add((Widget)refreshButton);
        Button refreshDropDownButton = new Button();
        this.createRefreshToggleButton(refreshDropDownButton);
        extendedPagedTable.getRightToolbar().add((Widget)refreshDropDownButton);
    }

    public String getValidKeyForAdditionalListGrid(String baseName) {
        return this.filterPagedTable.getValidKeyForAdditionalListGrid(baseName);
    }

    public ExtendedPagedTable<T> createGridInstance(final GridGlobalPreferences preferences, String key) {
        final ExtendedPagedTable newListGrid = new ExtendedPagedTable(10, preferences);
        newListGrid.setShowLastPagerButton(true);
        newListGrid.setShowFastFordwardPagerButton(true);
        ((UserPreferencesService)this.preferencesService.call((RemoteCallback)new RemoteCallback<GridPreferencesStore>(){

            public void callback(GridPreferencesStore preferencesStore) {
                newListGrid.setPreferencesService(AbstractMultiGridView.this.preferencesService);
                if (preferencesStore == null) {
                    newListGrid.setGridPreferencesStore(new GridPreferencesStore(preferences));
                } else {
                    newListGrid.setGridPreferencesStore(preferencesStore);
                }
                AbstractMultiGridView.this.initColumns(newListGrid);
                AbstractMultiGridView.this.initGenericToolBar(newListGrid);
                newListGrid.loadPageSizePreferences();
            }
        })).loadUserPreferences(key, UserPreferencesType.GRIDPREFERENCES);
        this.initExtraButtons(newListGrid);
        return newListGrid;
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    public ExtendedPagedTable<T> getListGrid() {
        return this.currentListGrid;
    }

    public abstract void initColumns(ExtendedPagedTable<T> var1);

    public abstract void initSelectionModel();

    public MultiGridPreferencesStore getMultiGridPreferencesStore() {
        if (this.filterPagedTable != null) {
            return this.filterPagedTable.getMultiGridPreferencesStore();
        }
        return null;
    }

    public void initExtraButtons(ExtendedPagedTable<T> extendedPagedTable) {
    }

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
    }

    public void applyFilterOnPresenter(String key) {
    }

    public void createRefreshToggleButton(final Button refreshIntervalSelector) {
        refreshIntervalSelector.setToggle(true);
        refreshIntervalSelector.setIcon(IconType.LIST_ALT);
        refreshIntervalSelector.setTitle("Refresh tooltip");
        this.popup.getElement().getStyle().setZIndex(Integer.MAX_VALUE);
        this.popup.addAutoHidePartner((Element)refreshIntervalSelector.getElement());
        this.popup.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> popupPanelCloseEvent) {
                if (popupPanelCloseEvent.isAutoClosed()) {
                    refreshIntervalSelector.setActive(false);
                }
            }
        });
        refreshIntervalSelector.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!refreshIntervalSelector.isActive()) {
                    AbstractMultiGridView.this.showSelectRefreshIntervalPopup(refreshIntervalSelector.getAbsoluteLeft() + refreshIntervalSelector.getOffsetWidth(), refreshIntervalSelector.getAbsoluteTop() + refreshIntervalSelector.getOffsetHeight(), refreshIntervalSelector);
                } else {
                    AbstractMultiGridView.this.popup.hide(false);
                }
            }
        });
    }

    private void showSelectRefreshIntervalPopup(int left, int top, final Button refreshIntervalSelector) {
        VerticalPanel popupContent = new VerticalPanel();
        int configuredSeconds = ((AbstractListPresenter)this.presenter).getAutoRefreshSeconds();
        RadioButton oneMinuteRadioButton = this.createTimeSelectorRadioButton(10000, "1 Minute", configuredSeconds, refreshIntervalSelector, popupContent);
        RadioButton fiveMinuteRadioButton = this.createTimeSelectorRadioButton(50000, "5 Minutes", configuredSeconds, refreshIntervalSelector, popupContent);
        RadioButton tenMinuteRadioButton = this.createTimeSelectorRadioButton(100000, "10 Minutes", configuredSeconds, refreshIntervalSelector, popupContent);
        popupContent.add((Widget)oneMinuteRadioButton);
        popupContent.add((Widget)fiveMinuteRadioButton);
        popupContent.add((Widget)tenMinuteRadioButton);
        Button resetButton = new Button("Disable Autorefresh");
        resetButton.setSize(ButtonSize.MINI);
        resetButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((AbstractListPresenter)AbstractMultiGridView.this.presenter).updateRefreshInterval(false, 0);
                refreshIntervalSelector.setActive(false);
                AbstractMultiGridView.this.popup.hide();
            }
        });
        popupContent.add((Widget)resetButton);
        this.popup.setWidget((Widget)popupContent);
        this.popup.show();
        int finalLeft = left - this.popup.getOffsetWidth();
        this.popup.setPopupPosition(finalLeft, top);
    }

    private RadioButton createTimeSelectorRadioButton(int time, String name, int configuredSeconds, final Button refreshIntervalSelector, VerticalPanel popupContent) {
        RadioButton oneMinuteRadioButton = new RadioButton("refreshInterval", name);
        oneMinuteRadioButton.setText(name);
        final int selectedRefreshTime = time;
        if (configuredSeconds == selectedRefreshTime) {
            oneMinuteRadioButton.setValue(Boolean.valueOf(true));
        }
        oneMinuteRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((AbstractListPresenter)AbstractMultiGridView.this.presenter).updateRefreshInterval(true, selectedRefreshTime);
                refreshIntervalSelector.setActive(false);
                AbstractMultiGridView.this.popup.hide();
            }
        });
        return oneMinuteRadioButton;
    }
}

