/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.gc.client.list.base;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import java.util.HashMap;
import javax.enterprise.event.Observes;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.gc.client.i18n.Constants;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.events.SearchEvent;
import org.uberfire.paging.PageResponse;

public abstract class AbstractListPresenter<T> {
    protected AsyncDataProvider<T> dataProvider;
    protected QueryFilter currentFilter;
    protected String textSearchStr = "";
    private Constants constants = (Constants)GWT.create(Constants.class);
    protected Timer refreshTimer = null;
    protected boolean autoRefreshEnabled = true;
    protected int autoRefreshSeconds = 7;

    protected abstract AbstractListView.ListView getListView();

    public AbstractListPresenter() {
        this.initDataProvider();
    }

    protected void updateRefreshTimer() {
        if (this.autoRefreshEnabled && this.autoRefreshSeconds > 0) {
            if (this.refreshTimer == null) {
                this.refreshTimer = new Timer(){

                    public void run() {
                        AbstractListPresenter.this.getData(((HasData)AbstractListPresenter.this.dataProvider.getDataDisplays().iterator().next()).getVisibleRange());
                    }
                };
            }
            this.refreshTimer.schedule(this.autoRefreshSeconds * 1000);
        } else if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
        }
    }

    public abstract void getData(Range var1);

    protected void initDataProvider() {
        this.dataProvider = new AsyncDataProvider<T>(){

            protected void onRangeChanged(HasData<T> display) {
                AbstractListPresenter.this.getListView().showBusyIndicator(AbstractListPresenter.this.constants.Loading());
                Range visibleRange = display.getVisibleRange();
                AbstractListPresenter.this.getData(visibleRange);
            }
        };
    }

    public void updateDataOnCallback(PageResponse response) {
        this.getListView().hideBusyIndicator();
        this.dataProvider.updateRowCount(response.getTotalRowSize(), response.isTotalRowSizeExact());
        this.dataProvider.updateRowData(response.getStartRowIndex(), response.getPageRowList());
        this.updateRefreshTimer();
    }

    public void addDataDisplay(HasData<T> display) {
        this.dataProvider.addDataDisplay(display);
    }

    public AsyncDataProvider<T> getDataProvider() {
        return this.dataProvider;
    }

    public void refreshGrid() {
        if (this.dataProvider.getDataDisplays().size() > 0) {
            HasData next = (HasData)this.dataProvider.getDataDisplays().iterator().next();
            next.setVisibleRangeAndClearData(next.getVisibleRange(), true);
        }
    }

    protected void onSearchEvent(@Observes SearchEvent searchEvent) {
        String filterString = searchEvent.getFilter();
        if (filterString != null && filterString.trim().length() > 0) {
            this.textSearchStr = filterString.toLowerCase();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("textSearch", this.textSearchStr);
            if (this.currentFilter != null) {
                this.currentFilter.setParams(params);
            }
        }
        HasData next = (HasData)this.dataProvider.getDataDisplays().iterator().next();
        if (filterString.equals("")) {
            next.setVisibleRangeAndClearData(next.getVisibleRange(), true);
        } else {
            next.setVisibleRangeAndClearData(new Range(0, next.getVisibleRange().getLength()), true);
        }
    }

    protected void updateRefreshInterval(boolean enableAutoRefresh, int newInterval) {
        this.autoRefreshEnabled = enableAutoRefresh;
        this.setAutoRefreshSeconds(newInterval);
        this.updateRefreshTimer();
    }

    protected int getAutoRefreshSeconds() {
        return this.autoRefreshSeconds;
    }

    protected void setAutoRefreshSeconds(int refreshSeconds) {
        this.autoRefreshSeconds = refreshSeconds;
    }
}

