/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.gc.client.util;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ButtonGroup;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.base.UnorderedList;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.github.gwtbootstrap.datepicker.client.ui.DateBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import java.util.Date;
import org.jbpm.console.ng.ga.model.CalendarListContainer;
import org.jbpm.console.ng.gc.client.i18n.Constants;
import org.jbpm.console.ng.gc.client.util.DateRange;
import org.jbpm.console.ng.gc.client.util.DateUtils;
import org.jbpm.console.ng.gc.client.util.TaskUtils;

public class LiCalendarPicker
extends Composite
implements HasValueChangeHandlers<Date> {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private Date currentDate;
    private ViewType viewType;
    private NavLink calendarLink;
    private IconAnchor calendarIcon;
    public NavLink dayViewTasksNavLink;
    public NavLink weekViewTasksNavLink;
    public NavLink monthViewTasksNavLink;
    public NavLink buttonGroupLi;
    public ButtonGroup buttonGroup;
    private UnorderedList ul = new UnorderedList();
    private Button previousButton;
    private Button nextButton;
    private Button todayButton;
    private CalendarListContainer listContainer;

    public LiCalendarPicker() {
        this.currentDate = new Date();
        this.viewType = ViewType.DAY;
        this.initWidget((Widget)this.ul);
    }

    public void init() {
        this.calendarLink = new NavLink();
        this.dayViewTasksNavLink = new NavLink();
        this.weekViewTasksNavLink = new NavLink();
        this.monthViewTasksNavLink = new NavLink();
        this.previousButton = new Button();
        this.previousButton.setSize(ButtonSize.SMALL);
        this.nextButton = new Button();
        this.nextButton.setSize(ButtonSize.SMALL);
        this.todayButton = new Button();
        this.todayButton.setSize(ButtonSize.SMALL);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroupLi = new NavLink();
        this.ul.add((Widget)this.calendarLink);
        this.initPrevNextTodayButtons();
        this.ul.add((Widget)this.buttonGroupLi);
        NavLink dividerNavLink1 = new NavLink();
        dividerNavLink1.setStyleName("divider-vertical");
        dividerNavLink1.remove((Widget)dividerNavLink1.getAnchor());
        this.ul.add((Widget)dividerNavLink1);
        this.ul.add((Widget)this.dayViewTasksNavLink);
        this.ul.add((Widget)this.weekViewTasksNavLink);
        this.ul.add((Widget)this.monthViewTasksNavLink);
        NavLink dividerNavLink2 = new NavLink();
        dividerNavLink2.setStyleName("divider-vertical");
        dividerNavLink2.remove((Widget)dividerNavLink1.getAnchor());
        this.ul.add((Widget)dividerNavLink2);
        this.dayViewTasksNavLink.setStyleName("");
        this.weekViewTasksNavLink.setStyleName("");
        this.monthViewTasksNavLink.setStyleName("");
        this.dayViewTasksNavLink.setText(this.constants.Day());
        this.dayViewTasksNavLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                LiCalendarPicker.this.listContainer.setDayView();
            }
        });
        this.weekViewTasksNavLink.setText(this.constants.Week());
        this.weekViewTasksNavLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                LiCalendarPicker.this.listContainer.setWeekView();
            }
        });
        this.monthViewTasksNavLink.setText(this.constants.Month());
        this.monthViewTasksNavLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                LiCalendarPicker.this.listContainer.setMonthView();
            }
        });
        this.calendarIcon = new IconAnchor();
        this.calendarLink.add((Widget)this.calendarIcon);
        this.initCalendarIcon();
        this.updateCalendarLabelText();
    }

    public void clear() {
        this.ul.clear();
    }

    public CalendarListContainer getListContainer() {
        return this.listContainer;
    }

    public void setListContainer(CalendarListContainer listContainer) {
        this.listContainer = listContainer;
    }

    private void initPrevNextTodayButtons() {
        this.previousButton.setIcon(IconType.CARET_LEFT);
        this.previousButton.setTitle(Constants.INSTANCE.Previous());
        this.previousButton.setIconSize(IconSize.SMALL);
        this.previousButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                LiCalendarPicker.this.adjustDate(true);
                LiCalendarPicker.this.updateTodayButtonEnabled();
            }
        });
        this.nextButton.setIcon(IconType.CARET_RIGHT);
        this.nextButton.setTitle(Constants.INSTANCE.Next());
        this.nextButton.setIconSize(IconSize.SMALL);
        this.nextButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                LiCalendarPicker.this.adjustDate(false);
                LiCalendarPicker.this.updateTodayButtonEnabled();
            }
        });
        this.todayButton.setText(this.constants.Today());
        this.todayButton.setEnabled(false);
        this.todayButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                LiCalendarPicker.this.setCurrentDate(new Date());
                LiCalendarPicker.this.propagateDateChanges();
                LiCalendarPicker.this.updateTodayButtonEnabled();
            }
        });
        this.buttonGroup.add((Widget)this.previousButton);
        this.buttonGroup.add((Widget)this.todayButton);
        this.buttonGroup.add((Widget)this.nextButton);
        this.buttonGroupLi.remove((Widget)this.buttonGroupLi.getAnchor());
        this.buttonGroupLi.addWidget((Widget)this.buttonGroup);
    }

    public void setCalendarView(TaskUtils.TaskView taskView) {
        this.dayViewTasksNavLink.setStyleName("");
        this.weekViewTasksNavLink.setStyleName("");
        this.monthViewTasksNavLink.setStyleName("");
        this.setViewType(taskView.name().toLowerCase());
        switch (taskView) {
            case DAY: {
                this.dayViewTasksNavLink.setStyleName("active");
                break;
            }
            case WEEK: {
                this.weekViewTasksNavLink.setStyleName("active");
                break;
            }
            case MONTH: {
                this.monthViewTasksNavLink.setStyleName("active");
                this.updateTodayButtonEnabled();
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized view type '" + (Object)((Object)taskView) + "'!");
            }
        }
    }

    public String getViewType() {
        return this.viewType.toString();
    }

    public void setViewType(String viewType) {
        this.viewType = ViewType.valueOf(viewType.toUpperCase());
        this.updateTodayButtonEnabled();
        this.updateCalendarLabelText();
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
    }

    public void adjustDate(boolean back) {
        switch (this.viewType) {
            case DAY: {
                if (back) {
                    CalendarUtil.addDaysToDate((Date)this.currentDate, (int)-1);
                    break;
                }
                CalendarUtil.addDaysToDate((Date)this.currentDate, (int)1);
                break;
            }
            case WEEK: {
                if (back) {
                    CalendarUtil.addDaysToDate((Date)this.currentDate, (int)-7);
                    break;
                }
                CalendarUtil.addDaysToDate((Date)this.currentDate, (int)7);
                break;
            }
            case MONTH: {
                if (back) {
                    this.currentDate = DateUtils.getSameOrClosestDateInPreviousMonth(this.currentDate);
                    break;
                }
                this.currentDate = DateUtils.getSameOrClosestDateInNextMonth(this.currentDate);
                break;
            }
        }
        this.propagateDateChanges();
    }

    public void propagateDateChanges() {
        this.updateCalendarLabelText();
        ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.currentDate);
    }

    private void updateCalendarLabelText() {
        switch (this.viewType) {
            case DAY: {
                this.calendarLink.setVisible(true);
                DateTimeFormat fmt = DateTimeFormat.getFormat((String)"EEE, dd MMMM");
                this.calendarLink.setText(fmt.format(this.currentDate));
                break;
            }
            case WEEK: {
                this.calendarLink.setVisible(true);
                DateTimeFormat fmt = DateTimeFormat.getFormat((String)"dd MMM");
                DateRange weekRange = DateUtils.getWeekDateRange(this.currentDate);
                String text = fmt.format(weekRange.getStartDate());
                text = text + " - " + fmt.format(weekRange.getEndDate());
                this.calendarLink.setText(text);
                break;
            }
            case MONTH: {
                this.calendarLink.setVisible(true);
                DateTimeFormat fmt = DateTimeFormat.getFormat((String)"MMMM yy");
                this.calendarLink.setText(fmt.format(this.currentDate));
                break;
            }
            case GRID: {
                this.calendarLink.setVisible(false);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized view type " + (Object)((Object)this.viewType));
            }
        }
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Date> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    private void initCalendarIcon() {
        this.calendarIcon.setIcon(IconType.CALENDAR);
        this.calendarIcon.setTitle(Constants.INSTANCE.Select_Date());
        this.calendarIcon.setIconSize(IconSize.SMALL);
        this.calendarIcon.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DateBox dateBox = new DateBox();
                dateBox.setAutoClose(true);
                dateBox.setValue(LiCalendarPicker.this.currentDate, false);
                dateBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Date>(){

                    public void onValueChange(ValueChangeEvent<Date> event) {
                        LiCalendarPicker.this.currentDate = (Date)event.getValue();
                        LiCalendarPicker.this.propagateDateChanges();
                        LiCalendarPicker.this.updateTodayButtonEnabled();
                    }
                });
                LiCalendarPicker.this.calendarLink.add((Widget)dateBox);
                dateBox.show();
                dateBox.removeFromParent();
            }
        });
    }

    private void updateTodayButtonEnabled() {
        boolean todayBtnEnabled = true;
        Date today = new Date();
        switch (this.viewType) {
            case DAY: {
                if (!DateUtils.areDatesEqual(today, this.currentDate)) break;
                todayBtnEnabled = false;
                break;
            }
            case WEEK: {
                DateRange weekRange = DateUtils.getWeekDateRange(this.currentDate);
                if (!DateUtils.isDateInRange(today, weekRange)) break;
                todayBtnEnabled = false;
                break;
            }
            case MONTH: {
                DateRange monthRange = DateUtils.getMonthDateRange(this.currentDate);
                if (!DateUtils.isDateInRange(today, monthRange)) break;
                todayBtnEnabled = false;
                break;
            }
            case GRID: {
                todayBtnEnabled = false;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized calendar view type: " + (Object)((Object)this.viewType));
            }
        }
        this.todayButton.setEnabled(todayBtnEnabled);
    }

    public static enum ViewType {
        DAY,
        WEEK,
        MONTH,
        GRID;

    }
}

