/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.gc.client.experimental.grid;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import java.util.ArrayList;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.ga.model.DataMockSummary;
import org.jbpm.console.ng.gc.client.experimental.grid.GridBasePresenter;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.i18n.Constants;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.tables.ColumnMeta;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated(value="GridBaseViewImpl.html")
public class GridBaseViewImpl
extends Composite
implements GridBasePresenter.GridBaseListView,
RequiresResize {
    @Inject
    private PlaceManager placeManager;
    private GridBasePresenter presenter;
    @Inject
    @DataField
    public LayoutPanel listContainer;
    public ExtendedPagedTable<DataMockSummary> listGrid;
    @Inject
    private Event<NotificationEvent> notification;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public void init(final GridBasePresenter presenter) {
        this.presenter = presenter;
        this.listContainer.clear();
        this.listGrid = new ExtendedPagedTable(10, null);
        presenter.addDataDisplay((HasData<DataMockSummary>)this.listGrid);
        this.listContainer.add(this.listGrid);
        this.initGridColumns(this.listGrid);
        Button refreshButton = new Button();
        refreshButton.setIcon(IconType.REFRESH);
        refreshButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                presenter.refreshList();
            }
        });
        this.listGrid.getToolbar().add((Widget)refreshButton);
        Button createServerDataButton = new Button();
        createServerDataButton.setText("Create Server Side Data");
        createServerDataButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                presenter.createData();
            }
        });
        this.listGrid.getToolbar().add((Widget)createServerDataButton);
    }

    @Override
    public ExtendedPagedTable<DataMockSummary> getListGrid() {
        return this.listGrid;
    }

    public void initGridColumns(ExtendedPagedTable extendedPagedTable) {
        Column columnIdColumn = this.idColumn();
        Column column1Column = this.column1Column();
        Column column2Column = this.column2Column();
        Column column3Column = this.column3Column();
        Column column4Column = this.column4Column();
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(columnIdColumn, "ID"));
        columnMetas.add(new ColumnMeta(column1Column, "Column1"));
        columnMetas.add(new ColumnMeta(column2Column, "Column2"));
        columnMetas.add(new ColumnMeta(column3Column, "Column3"));
        columnMetas.add(new ColumnMeta(column4Column, "Column4"));
        extendedPagedTable.addColumns(columnMetas);
    }

    private Column idColumn() {
        Column<DataMockSummary, String> columnIdColumn = new Column<DataMockSummary, String>((Cell)new TextCell()){

            public String getValue(DataMockSummary unit) {
                return unit.getId();
            }
        };
        columnIdColumn.setSortable(true);
        columnIdColumn.setDataStoreName("idColumn");
        return columnIdColumn;
    }

    private Column column1Column() {
        Column<DataMockSummary, String> column1Column = new Column<DataMockSummary, String>((Cell)new TextCell()){

            public String getValue(DataMockSummary unit) {
                return unit.getColumn1();
            }
        };
        column1Column.setSortable(true);
        column1Column.setDataStoreName("col1");
        return column1Column;
    }

    private Column column2Column() {
        Column<DataMockSummary, String> column2Column = new Column<DataMockSummary, String>((Cell)new TextCell()){

            public String getValue(DataMockSummary unit) {
                return unit.getColumn2();
            }
        };
        column2Column.setSortable(true);
        column2Column.setDataStoreName("col2");
        return column2Column;
    }

    private Column column3Column() {
        Column<DataMockSummary, String> column3Column = new Column<DataMockSummary, String>((Cell)new TextCell()){

            public String getValue(DataMockSummary unit) {
                return unit.getColumn3();
            }
        };
        column3Column.setSortable(true);
        column3Column.setDataStoreName("col3");
        return column3Column;
    }

    private Column column4Column() {
        Column<DataMockSummary, String> column4Column = new Column<DataMockSummary, String>((Cell)new TextCell()){

            public String getValue(DataMockSummary unit) {
                return unit.getColumn4();
            }
        };
        column4Column.setSortable(true);
        column4Column.setDataStoreName("col4");
        return column4Column;
    }

    public void onResize() {
        if (this.getParent().getOffsetHeight() - 120 > 0) {
            this.listContainer.setHeight(this.getParent().getOffsetHeight() - 120 + "px");
        }
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @Override
    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    @Override
    public void hideBusyIndicator() {
        BusyPopup.close();
    }
}

