/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.gc.client.list.base;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.RadioButton;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import java.util.HashMap;
import javax.enterprise.event.Observes;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.gc.client.i18n.Constants;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.events.SearchEvent;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.paging.PageResponse;

public abstract class AbstractListPresenter<T> {
    protected AsyncDataProvider<T> dataProvider;
    protected QueryFilter currentFilter;
    protected String textSearchStr = "";
    private Constants constants = (Constants)GWT.create(Constants.class);
    protected boolean addingDefaultFilters = false;
    protected Timer refreshTimer = null;
    protected boolean autoRefreshEnabled = false;
    protected int autoRefreshSeconds = 0;
    public Button menuActionsButton;
    private PopupPanel popup = new PopupPanel(true);

    protected abstract AbstractListView.ListView getListView();

    public AbstractListPresenter() {
        this.initDataProvider();
    }

    public boolean isAddingDefaultFilters() {
        return this.addingDefaultFilters;
    }

    public void setAddingDefaultFilters(boolean addingDefaultFilters) {
        this.addingDefaultFilters = addingDefaultFilters;
    }

    public void setRefreshTimer(Timer refreshTimer) {
        this.refreshTimer = refreshTimer;
    }

    public Timer getRefreshTimer() {
        return this.refreshTimer;
    }

    public void setAutoRefreshEnabled(boolean autoRefreshEnabled) {
        this.autoRefreshEnabled = autoRefreshEnabled;
    }

    public boolean isAutoRefreshEnabled() {
        return this.autoRefreshEnabled;
    }

    protected void updateRefreshTimer() {
        if (this.refreshTimer == null) {
            this.refreshTimer = new Timer(){

                public void run() {
                    AbstractListPresenter.this.getData(((HasData)AbstractListPresenter.this.dataProvider.getDataDisplays().iterator().next()).getVisibleRange());
                }
            };
        } else {
            this.refreshTimer.cancel();
        }
        if (this.autoRefreshEnabled && this.autoRefreshSeconds > 10) {
            this.refreshTimer.schedule(this.autoRefreshSeconds * 1000);
        }
    }

    public abstract void getData(Range var1);

    protected void initDataProvider() {
        this.dataProvider = new AsyncDataProvider<T>(){

            protected void onRangeChanged(HasData<T> display) {
                AbstractListPresenter.this.getListView().showBusyIndicator(AbstractListPresenter.this.constants.Loading());
                Range visibleRange = display.getVisibleRange();
                AbstractListPresenter.this.getData(visibleRange);
            }
        };
    }

    public void updateDataOnCallback(PageResponse response) {
        this.getListView().hideBusyIndicator();
        this.dataProvider.updateRowCount(response.getTotalRowSize(), response.isTotalRowSizeExact());
        this.dataProvider.updateRowData(response.getStartRowIndex(), response.getPageRowList());
        this.updateRefreshTimer();
    }

    public void addDataDisplay(HasData<T> display) {
        this.dataProvider.addDataDisplay(display);
    }

    public AsyncDataProvider<T> getDataProvider() {
        return this.dataProvider;
    }

    public void refreshGrid() {
        if (this.dataProvider.getDataDisplays().size() > 0) {
            HasData next = (HasData)this.dataProvider.getDataDisplays().iterator().next();
            next.setVisibleRangeAndClearData(next.getVisibleRange(), true);
        }
    }

    protected void onSearchEvent(@Observes SearchEvent searchEvent) {
        String filterString = searchEvent.getFilter();
        if (filterString != null && filterString.trim().length() > 0) {
            this.textSearchStr = filterString.toLowerCase();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("textSearch", this.textSearchStr);
            if (this.currentFilter != null) {
                this.currentFilter.setParams(params);
            }
        }
        HasData next = (HasData)this.dataProvider.getDataDisplays().iterator().next();
        if (filterString.equals("")) {
            next.setVisibleRangeAndClearData(next.getVisibleRange(), true);
        } else {
            next.setVisibleRangeAndClearData(new Range(0, next.getVisibleRange().getLength()), true);
        }
    }

    protected void updateRefreshInterval(boolean enableAutoRefresh, int newInterval) {
        this.autoRefreshEnabled = enableAutoRefresh;
        this.setAutoRefreshSeconds(newInterval);
        this.updateRefreshTimer();
    }

    protected int getAutoRefreshSeconds() {
        return this.autoRefreshSeconds;
    }

    protected void setAutoRefreshSeconds(int refreshSeconds) {
        this.autoRefreshSeconds = refreshSeconds;
    }

    public void createRefreshToggleButton(final Button refreshIntervalSelector) {
        refreshIntervalSelector.setToggle(true);
        refreshIntervalSelector.setIcon(IconType.COG);
        refreshIntervalSelector.setTitle(Constants.INSTANCE.AutoRefresh());
        refreshIntervalSelector.setSize(ButtonSize.MINI);
        this.popup.getElement().getStyle().setZIndex(Integer.MAX_VALUE);
        this.popup.addAutoHidePartner((Element)refreshIntervalSelector.getElement());
        this.popup.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> popupPanelCloseEvent) {
                if (popupPanelCloseEvent.isAutoClosed()) {
                    refreshIntervalSelector.setActive(false);
                }
            }
        });
        refreshIntervalSelector.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!refreshIntervalSelector.isActive()) {
                    AbstractListPresenter.this.showSelectRefreshIntervalPopup(refreshIntervalSelector.getAbsoluteLeft() + refreshIntervalSelector.getOffsetWidth(), refreshIntervalSelector.getAbsoluteTop() + refreshIntervalSelector.getOffsetHeight(), refreshIntervalSelector);
                } else {
                    AbstractListPresenter.this.popup.hide(false);
                }
            }
        });
    }

    private void showSelectRefreshIntervalPopup(int left, int top, Button refreshIntervalSelector) {
        VerticalPanel popupContent = new VerticalPanel();
        final Button resetButton = new Button(Constants.INSTANCE.DisableAutorefresh());
        int configuredSeconds = this.getRefreshValue();
        if (configuredSeconds > 10) {
            this.updateRefreshInterval(true, configuredSeconds);
            resetButton.setEnabled(true);
            resetButton.setActive(false);
            resetButton.setText(Constants.INSTANCE.DisableAutorefresh());
        } else {
            this.updateRefreshInterval(false, 0);
            resetButton.setEnabled(false);
            resetButton.setActive(true);
            resetButton.setText(Constants.INSTANCE.AutorefreshDisabled());
        }
        RadioButton oneMinuteRadioButton = this.createTimeSelectorRadioButton(60, "1 " + Constants.INSTANCE.Minute(), configuredSeconds, refreshIntervalSelector, popupContent);
        RadioButton fiveMinuteRadioButton = this.createTimeSelectorRadioButton(300, "5 " + Constants.INSTANCE.Minutes(), configuredSeconds, refreshIntervalSelector, popupContent);
        RadioButton tenMinuteRadioButton = this.createTimeSelectorRadioButton(600, "10 " + Constants.INSTANCE.Minutes(), configuredSeconds, refreshIntervalSelector, popupContent);
        popupContent.add((Widget)oneMinuteRadioButton);
        popupContent.add((Widget)fiveMinuteRadioButton);
        popupContent.add((Widget)tenMinuteRadioButton);
        resetButton.setSize(ButtonSize.MINI);
        resetButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AbstractListPresenter.this.updateRefreshInterval(false, 0);
                AbstractListPresenter.this.saveRefreshValue(0);
                resetButton.setEnabled(false);
                resetButton.setActive(true);
                resetButton.setText(Constants.INSTANCE.AutorefreshDisabled());
                AbstractListPresenter.this.popup.hide();
            }
        });
        popupContent.add((Widget)resetButton);
        this.popup.setWidget((Widget)popupContent);
        this.popup.show();
        int finalLeft = left - this.popup.getOffsetWidth();
        this.popup.setPopupPosition(finalLeft, top);
    }

    private RadioButton createTimeSelectorRadioButton(int time, String name, int configuredSeconds, final Button refreshIntervalSelector, VerticalPanel popupContent) {
        RadioButton oneMinuteRadioButton = new RadioButton("refreshInterval", name);
        oneMinuteRadioButton.setText(name);
        final int selectedRefreshTime = time;
        if (configuredSeconds == selectedRefreshTime) {
            oneMinuteRadioButton.setValue(Boolean.valueOf(true));
        }
        oneMinuteRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AbstractListPresenter.this.updateRefreshInterval(true, selectedRefreshTime);
                AbstractListPresenter.this.saveRefreshValue(selectedRefreshTime);
                refreshIntervalSelector.setActive(false);
                AbstractListPresenter.this.popup.hide();
            }
        });
        return oneMinuteRadioButton;
    }

    protected void saveRefreshValue(int newValue) {
    }

    protected int getRefreshValue() {
        return 0;
    }

    @OnClose
    public void onClose() {
        if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
        }
    }
}

