/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.gc.client.util;

import java.util.Date;

public class DateRange {
    private final Date startDate;
    private final Date endDate;
    private final int daysInBetween;

    public DateRange(Date startDate, Date endDate, int daysInBetween) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.daysInBetween = daysInBetween;
    }

    public Date getStartDate() {
        return new Date(this.startDate.getTime());
    }

    public Date getEndDate() {
        return new Date(this.endDate.getTime());
    }

    public int getDaysInBetween() {
        return this.daysInBetween;
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (this.startDate != null ? this.startDate.hashCode() : 0);
        hash = 23 * hash + (this.endDate != null ? this.endDate.hashCode() : 0);
        hash = 23 * hash + this.daysInBetween;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateRange other = (DateRange)obj;
        if (!(this.startDate == other.startDate || this.startDate != null && this.startDate.equals(other.startDate))) {
            return false;
        }
        if (!(this.endDate == other.endDate || this.endDate != null && this.endDate.equals(other.endDate))) {
            return false;
        }
        return this.daysInBetween == other.daysInBetween;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DateRange [startDate=");
        builder.append(this.startDate);
        builder.append(", endDate=");
        builder.append(this.endDate);
        builder.append(", daysInBetween=");
        builder.append(this.daysInBetween);
        builder.append("]");
        return builder.toString();
    }
}

