/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.gc.client.list.base;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import java.util.ArrayList;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.ga.model.GenericSummary;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.i18n.Constants;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.ext.widgets.common.client.tables.FilterPagedTable;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractMultiGridView<T extends GenericSummary, V extends AbstractListPresenter>
extends Composite
implements RequiresResize {
    public static String FILTER_TABLE_SETTINGS = "tableSettings";
    public static String USER_DEFINED = "ud_";
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @Inject
    public User identity;
    @Inject
    protected Event<NotificationEvent> notification;
    @Inject
    protected PlaceManager placeManager;
    @Inject
    private Caller<UserPreferencesService> preferencesService;
    @UiField
    org.gwtbootstrap3.client.ui.Column column;
    protected V presenter;
    protected FilterPagedTable<T> filterPagedTable;
    protected ExtendedPagedTable<T> currentListGrid;
    protected RowStyles<T> selectedStyles = new RowStyles<T>(){

        public String getStyleNames(T row, int rowIndex) {
            if (rowIndex == AbstractMultiGridView.this.selectedRow) {
                return "selected";
            }
            return null;
        }
    };
    protected NoSelectionModel<T> selectionModel;
    protected T selectedItem;
    protected int selectedRow = -1;
    protected Column actionsColumn;
    protected DefaultSelectionEventManager<T> noActionColumnManager;
    public GridGlobalPreferences currentGlobalPreferences;
    public Button createTabButton;

    public AbstractMultiGridView() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public void init(final V presenter, final GridGlobalPreferences preferences, final Button createNewGridButton) {
        this.presenter = presenter;
        this.currentGlobalPreferences = preferences;
        this.createTabButton = createNewGridButton;
        this.filterPagedTable = (FilterPagedTable)GWT.create(FilterPagedTable.class);
        this.column.add(this.filterPagedTable.makeWidget());
        this.filterPagedTable.setPreferencesService(this.preferencesService);
        ((UserPreferencesService)this.preferencesService.call((RemoteCallback)new RemoteCallback<MultiGridPreferencesStore>(){

            public void callback(MultiGridPreferencesStore multiGridPreferencesStore) {
                if (multiGridPreferencesStore == null) {
                    multiGridPreferencesStore = new MultiGridPreferencesStore(preferences.getKey());
                }
                String selectedGridId = multiGridPreferencesStore.getSelectedGrid();
                AbstractMultiGridView.this.filterPagedTable.setMultiGridPreferencesStore(multiGridPreferencesStore);
                presenter.onGridPreferencesStoreLoaded();
                ArrayList existingGrids = multiGridPreferencesStore.getGridsId();
                if (existingGrids != null && existingGrids.size() > 0) {
                    AbstractMultiGridView.this.resetDefaultFilterTitleAndDescription();
                    presenter.setAddingDefaultFilters(true);
                    for (int i = 0; i < existingGrids.size(); ++i) {
                        String key = (String)existingGrids.get(i);
                        final ExtendedPagedTable extendedPagedTable = AbstractMultiGridView.this.loadGridInstance(preferences, key);
                        AbstractMultiGridView.this.currentListGrid = extendedPagedTable;
                        extendedPagedTable.setDataProvider((AbstractDataProvider)presenter.getDataProvider());
                        final String filterKey = key;
                        AbstractMultiGridView.this.filterPagedTable.addTab(extendedPagedTable, key, new Command(){

                            public void execute() {
                                AbstractMultiGridView.this.currentListGrid = extendedPagedTable;
                                AbstractMultiGridView.this.applyFilterOnPresenter(filterKey);
                            }
                        });
                        if (AbstractMultiGridView.this.currentListGrid == null || !key.equals(selectedGridId)) continue;
                        AbstractMultiGridView.this.currentListGrid = extendedPagedTable;
                    }
                    AbstractMultiGridView.this.filterPagedTable.addAddTableButton(createNewGridButton);
                    presenter.setAddingDefaultFilters(false);
                    if (selectedGridId != null) {
                        multiGridPreferencesStore.setSelectedGrid(selectedGridId);
                        ((UserPreferencesService)AbstractMultiGridView.this.preferencesService.call()).saveUserPreferences((UserPreference)multiGridPreferencesStore);
                        AbstractMultiGridView.this.filterPagedTable.setSelectedTab();
                    }
                } else {
                    AbstractMultiGridView.this.initDefaultFilters(preferences, createNewGridButton);
                }
                AbstractMultiGridView.this.initSelectionModel();
            }
        })).loadUserPreferences(preferences.getKey(), UserPreferencesType.MULTIGRIDPREFERENCES);
    }

    public void onResize() {
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    public void showRestoreDefaultFilterConfirmationPopup() {
        YesNoCancelPopup yesNoCancelPopup = YesNoCancelPopup.newYesNoCancelPopup((String)Constants.INSTANCE.RestoreDefaultFilters(), (String)Constants.INSTANCE.AreYouSureRestoreDefaultFilters(), (Command)new Command(){

            public void execute() {
                AbstractMultiGridView.this.showBusyIndicator(Constants.INSTANCE.Loading());
                AbstractMultiGridView.this.restoreTabs();
            }
        }, null, (Command)new Command(){

            public void execute() {
            }
        });
        yesNoCancelPopup.show();
    }

    public void restoreTabs() {
        ArrayList existingGrids = this.getMultiGridPreferencesStore().getGridsId();
        ArrayList allTabs = new ArrayList(existingGrids.size());
        ((AbstractListPresenter)this.presenter).setAddingDefaultFilters(true);
        if (existingGrids != null && existingGrids.size() > 0) {
            int i;
            for (i = 0; i < existingGrids.size(); ++i) {
                allTabs.add(existingGrids.get(i));
            }
            for (i = 0; i < allTabs.size(); ++i) {
                this.filterPagedTable.removeTab((String)allTabs.get(i));
            }
        }
        this.filterPagedTable.removeTab(0);
        this.initDefaultFilters(this.currentGlobalPreferences, this.createTabButton);
    }

    public void initGenericToolBar(ExtendedPagedTable<T> extendedPagedTable) {
    }

    public String getValidKeyForAdditionalListGrid(String baseName) {
        return this.filterPagedTable.getValidKeyForAdditionalListGrid(baseName + USER_DEFINED);
    }

    public ExtendedPagedTable<T> createGridInstance(GridGlobalPreferences preferences, String key) {
        ExtendedPagedTable newListGrid = new ExtendedPagedTable(10, preferences);
        newListGrid.setShowLastPagerButton(true);
        newListGrid.setShowFastFordwardPagerButton(true);
        newListGrid.setPreferencesService(this.preferencesService);
        newListGrid.setGridPreferencesStore(new GridPreferencesStore(preferences));
        this.initColumns(newListGrid);
        this.initGenericToolBar(newListGrid);
        newListGrid.loadPageSizePreferences();
        newListGrid.createPageSizesListBox(5, 20, 5);
        this.initExtraButtons(newListGrid);
        return newListGrid;
    }

    public ExtendedPagedTable<T> loadGridInstance(final GridGlobalPreferences preferences, String key) {
        final ExtendedPagedTable newListGrid = new ExtendedPagedTable(10, preferences);
        newListGrid.setShowLastPagerButton(true);
        newListGrid.setShowFastFordwardPagerButton(true);
        ((UserPreferencesService)this.preferencesService.call((RemoteCallback)new RemoteCallback<GridPreferencesStore>(){

            public void callback(GridPreferencesStore preferencesStore) {
                newListGrid.setPreferencesService(AbstractMultiGridView.this.preferencesService);
                if (preferencesStore == null) {
                    newListGrid.setGridPreferencesStore(new GridPreferencesStore(preferences));
                } else {
                    newListGrid.setGridPreferencesStore(preferencesStore);
                }
                AbstractMultiGridView.this.initColumns(newListGrid);
                AbstractMultiGridView.this.initGenericToolBar(newListGrid);
                newListGrid.loadPageSizePreferences();
                newListGrid.createPageSizesListBox(5, 20, 5);
            }
        })).loadUserPreferences(key, UserPreferencesType.GRIDPREFERENCES);
        this.initExtraButtons(newListGrid);
        return newListGrid;
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    public ExtendedPagedTable<T> getListGrid() {
        return this.currentListGrid;
    }

    public abstract void initColumns(ExtendedPagedTable<T> var1);

    public abstract void initSelectionModel();

    public MultiGridPreferencesStore getMultiGridPreferencesStore() {
        if (this.filterPagedTable != null) {
            return this.filterPagedTable.getMultiGridPreferencesStore();
        }
        return null;
    }

    public void initExtraButtons(ExtendedPagedTable<T> extendedPagedTable) {
    }

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
    }

    public void selectFirstTabAndEnableQueries(final String firsTabKey) {
        ((AbstractListPresenter)this.presenter).setAddingDefaultFilters(false);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                AbstractMultiGridView.this.getMultiGridPreferencesStore().setSelectedGrid(firsTabKey);
                AbstractMultiGridView.this.filterPagedTable.setSelectedTab();
            }
        });
    }

    public void applyFilterOnPresenter(String key) {
    }

    public void setIdentity(User identity) {
        this.identity = identity;
    }

    public void setPreferencesService(Caller<UserPreferencesService> preferencesService) {
        this.preferencesService = preferencesService;
    }

    public void resetDefaultFilterTitleAndDescription() {
    }

    public FilterPagedTable<T> getFilterPagedTable() {
        return this.filterPagedTable;
    }

    public void setFilterPagedTable(FilterPagedTable<T> filterPagedTable) {
        this.filterPagedTable = filterPagedTable;
    }

    static interface Binder
    extends UiBinder<Widget, AbstractMultiGridView> {
    }
}

