/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.gc.client.list.base;

import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import org.gwtbootstrap3.client.ui.Button;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractMultiGridView;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.common.client.tables.FilterPagedTable;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractMultiGridViewTest {
    private static final String TEST_KEY = "TEST";
    private static final String TEST_KEY_GRID1 = "TEST_1";
    private static final String TEST_KEY_GRID2 = "TEST_2";
    private AbstractMultiGridView testListView;
    @Mock
    private AbstractListPresenter presenter;
    @Mock
    protected Button mockButton;
    private CallerMock<UserPreferencesService> callerMockUserPreferencesService;
    @Mock
    private UserPreferencesService userPreferencesServiceMock;
    @Mock
    private MultiGridPreferencesStore multiGridPreferencesStore;
    @Mock
    AsyncDataProvider dataProviderMock;
    @Mock
    protected FilterPagedTable filterPagedTable;

    @Before
    public void setupMocks() {
        this.testListView = (AbstractMultiGridView)Mockito.spy(AbstractMultiGridView.class);
        this.callerMockUserPreferencesService = new CallerMock((Object)this.userPreferencesServiceMock);
        this.testListView.setPreferencesService(this.callerMockUserPreferencesService);
        Mockito.when((Object)this.userPreferencesServiceMock.loadUserPreferences(TEST_KEY, UserPreferencesType.MULTIGRIDPREFERENCES)).thenReturn((Object)this.multiGridPreferencesStore);
        Mockito.when((Object)this.presenter.getDataProvider()).thenReturn((Object)this.dataProviderMock);
    }

    @Test
    public void initWithoutFiltersDefinedTest() {
        Mockito.when((Object)this.multiGridPreferencesStore.getSelectedGrid()).thenReturn((Object)"");
        Mockito.when((Object)this.multiGridPreferencesStore.getGridsId()).thenReturn(new ArrayList());
        GridGlobalPreferences ggp = new GridGlobalPreferences(TEST_KEY, new ArrayList(), new ArrayList());
        this.testListView.init(this.presenter, ggp, this.mockButton);
        ((UserPreferencesService)Mockito.verify((Object)this.userPreferencesServiceMock)).loadUserPreferences(TEST_KEY, UserPreferencesType.MULTIGRIDPREFERENCES);
        ((AbstractMultiGridView)Mockito.verify((Object)this.testListView)).initDefaultFilters(ggp, this.mockButton);
    }

    @Test
    public void initWithFilterStoredTest() {
        ArrayList<String> existingFilters = new ArrayList<String>();
        existingFilters.add(TEST_KEY_GRID1);
        existingFilters.add(TEST_KEY_GRID2);
        String selectedGrid = TEST_KEY_GRID1;
        Mockito.when((Object)this.multiGridPreferencesStore.getSelectedGrid()).thenReturn((Object)selectedGrid);
        Mockito.when((Object)this.multiGridPreferencesStore.getGridsId()).thenReturn(existingFilters);
        GridGlobalPreferences ggp = new GridGlobalPreferences(TEST_KEY, new ArrayList(), new ArrayList());
        this.testListView.init(this.presenter, ggp, this.mockButton);
        ((UserPreferencesService)Mockito.verify((Object)this.userPreferencesServiceMock)).loadUserPreferences(TEST_KEY, UserPreferencesType.MULTIGRIDPREFERENCES);
        ((AbstractMultiGridView)Mockito.verify((Object)this.testListView)).resetDefaultFilterTitleAndDescription();
        ((AbstractListPresenter)Mockito.verify((Object)this.presenter)).setAddingDefaultFilters(true);
        ((AbstractMultiGridView)Mockito.verify((Object)this.testListView)).loadGridInstance(ggp, TEST_KEY_GRID1);
        ((AbstractMultiGridView)Mockito.verify((Object)this.testListView)).loadGridInstance(ggp, TEST_KEY_GRID2);
        ((AbstractListPresenter)Mockito.verify((Object)this.presenter)).setAddingDefaultFilters(false);
        ExtendedPagedTable listGrid1 = new ExtendedPagedTable(10, ggp);
        ExtendedPagedTable listGrid2 = new ExtendedPagedTable(10, ggp);
        Mockito.when((Object)this.testListView.loadGridInstance(ggp, TEST_KEY_GRID1)).thenReturn((Object)listGrid1);
        Mockito.when((Object)this.testListView.loadGridInstance(ggp, TEST_KEY_GRID2)).thenReturn((Object)listGrid2);
        ((MultiGridPreferencesStore)Mockito.verify((Object)this.multiGridPreferencesStore)).setSelectedGrid(selectedGrid);
        ((UserPreferencesService)Mockito.verify((Object)this.userPreferencesServiceMock)).saveUserPreferences((UserPreference)this.multiGridPreferencesStore);
    }

    @Test
    public void validKeyForAdditionalFilterIncludesUserDefinedTest() {
        this.testListView.setFilterPagedTable(this.filterPagedTable);
        this.testListView.getValidKeyForAdditionalListGrid(TEST_KEY);
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable)).getValidKeyForAdditionalListGrid(TEST_KEY + AbstractMultiGridView.USER_DEFINED);
    }
}

