/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.gc.client.list.base;

import com.google.gwt.user.client.Timer;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.apache.commons.lang3.RandomStringUtils;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.jbpm.console.ng.gc.client.list.base.events.SearchEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractListPresenterTest {
    @Mock
    private Timer timer;
    @Mock
    private AbstractListView.ListView viewMock;
    @Mock
    HasData next;
    private AbstractListPresenter testListPresenter;

    @Before
    public void setupMocks() {
        this.testListPresenter = (AbstractListPresenter)Mockito.spy(AbstractScreenListPresenter.class);
        Mockito.when((Object)this.testListPresenter.getListView()).thenReturn((Object)this.viewMock);
        Mockito.when((Object)this.next.getVisibleRange()).thenReturn((Object)new Range(1, 1));
        this.testListPresenter.initDataProvider();
        this.testListPresenter.getDataProvider().addDataDisplay(this.next);
    }

    @Test
    public void autoRefreshDisabledByDefaultTest() {
        this.testListPresenter.setRefreshTimer(null);
        this.testListPresenter.updateRefreshTimer();
        Assert.assertNotNull((Object)this.testListPresenter.getRefreshTimer());
        Assert.assertFalse((boolean)this.testListPresenter.isAutoRefreshEnabled());
        this.testListPresenter.setRefreshTimer(this.timer);
        this.testListPresenter.setAutoRefreshSeconds(60);
        this.testListPresenter.updateRefreshTimer();
        Assert.assertFalse((boolean)this.testListPresenter.isAutoRefreshEnabled());
        ((Timer)Mockito.verify((Object)this.timer)).cancel();
    }

    @Test
    public void autoRefreshEnabledScheduleTimerTest() {
        this.testListPresenter.setAutoRefreshEnabled(true);
        this.testListPresenter.setAutoRefreshSeconds(60);
        this.testListPresenter.setRefreshTimer(this.timer);
        this.testListPresenter.updateRefreshTimer();
        Assert.assertNotNull((Object)this.testListPresenter.getRefreshTimer());
        ((Timer)Mockito.verify((Object)this.timer)).cancel();
        ((Timer)Mockito.verify((Object)this.timer)).schedule(60000);
    }

    @Test
    public void restoreTabsTest() {
        this.testListPresenter.onRestoreDefaultFilters();
        ((AbstractListView.ListView)Mockito.verify((Object)this.viewMock)).showRestoreDefaultFilterConfirmationPopup();
    }

    @Test
    public void testEmptySearchString() {
        SearchEvent searchEvent = new SearchEvent("");
        this.testListPresenter.onSearchEvent(searchEvent);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Range.class);
        ((HasData)Mockito.verify((Object)this.next)).setVisibleRangeAndClearData((Range)captor.capture(), Mockito.eq((boolean)true));
        Range range = (Range)captor.getValue();
        Assert.assertEquals((long)1L, (long)range.getStart());
        Assert.assertEquals((long)1L, (long)range.getLength());
        Assert.assertEquals((Object)searchEvent.getFilter(), (Object)this.testListPresenter.getTextSearchStr());
    }

    @Test
    public void testSearchString() {
        SearchEvent searchEvent = new SearchEvent(RandomStringUtils.random((int)10));
        this.testListPresenter.onSearchEvent(searchEvent);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Range.class);
        ((HasData)Mockito.verify((Object)this.next)).setVisibleRangeAndClearData((Range)captor.capture(), Mockito.eq((boolean)true));
        Range range = (Range)captor.getValue();
        Assert.assertEquals((long)0L, (long)range.getStart());
        Assert.assertEquals((long)1L, (long)range.getLength());
        Assert.assertEquals((Object)searchEvent.getFilter().toLowerCase(), (Object)this.testListPresenter.getTextSearchStr());
    }
}

