/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.console.ng.ht.backend.server.CommentSummaryHelper;
import org.jbpm.console.ng.ht.backend.server.TaskI18NHelper;
import org.jbpm.console.ng.ht.backend.server.TaskSummaryHelper;
import org.jbpm.console.ng.ht.model.CommentSummary;
import org.jbpm.console.ng.ht.model.IdentitySummary;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.service.TaskServiceEntryPoint;
import org.jbpm.task.Comment;
import org.jbpm.task.Content;
import org.jbpm.task.Group;
import org.jbpm.task.I18NText;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Status;
import org.jbpm.task.SubTasksStrategy;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.impl.factories.TaskFactory;
import org.jbpm.task.utils.ContentMarshallerHelper;

@Service
@ApplicationScoped
@Transactional
public class TaskServiceEntryPointImpl
implements TaskServiceEntryPoint {
    @Inject
    private org.jbpm.task.api.TaskServiceEntryPoint taskService;

    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId, String language) {
        return TaskSummaryHelper.adaptCollection(this.taskService.getTasksAssignedAsBusinessAdministrator(userId, language));
    }

    public List<TaskSummary> getTasksAssignedAsExcludedOwner(String userId, String language) {
        return TaskSummaryHelper.adaptCollection(this.taskService.getTasksAssignedAsExcludedOwner(userId, language));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, String language) {
        return TaskSummaryHelper.adaptCollection(this.taskService.getTasksAssignedAsPotentialOwner(userId, language));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language) {
        return TaskSummaryHelper.adaptCollection(this.taskService.getTasksAssignedAsPotentialOwner(userId, groupIds, language));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language, int firstResult, int maxResult) {
        return TaskSummaryHelper.adaptCollection(this.taskService.getTasksAssignedAsPotentialOwner(userId, groupIds, language, firstResult, maxResult));
    }

    public List<TaskSummary> getTasksAssignedAsRecipient(String userId, String language) {
        return TaskSummaryHelper.adaptCollection(this.taskService.getTasksAssignedAsRecipient(userId, language));
    }

    public List<TaskSummary> getTasksAssignedAsTaskInitiator(String userId, String language) {
        return TaskSummaryHelper.adaptCollection(this.taskService.getTasksAssignedAsTaskInitiator(userId, language));
    }

    public List<TaskSummary> getTasksAssignedAsTaskStakeholder(String userId, String language) {
        return TaskSummaryHelper.adaptCollection(this.taskService.getTasksAssignedAsTaskStakeholder(userId, language));
    }

    public List<TaskSummary> getTasksOwned(String userId) {
        return TaskSummaryHelper.adaptCollection(this.taskService.getTasksOwned(userId));
    }

    public List<TaskSummary> getTasksOwned(String userId, List<String> status, String language) {
        ArrayList<Status> statuses = new ArrayList<Status>();
        for (String s : status) {
            statuses.add(Status.valueOf((String)s));
        }
        return TaskSummaryHelper.adaptCollection(this.taskService.getTasksOwned(userId, statuses, language));
    }

    public List<TaskSummary> getSubTasksAssignedAsPotentialOwner(long parentId, String userId, String language) {
        return TaskSummaryHelper.adaptCollection(this.taskService.getSubTasksAssignedAsPotentialOwner(parentId, userId, language));
    }

    public List<TaskSummary> getTasksAssignedByGroup(String groupId, String language) {
        return TaskSummaryHelper.adaptCollection(this.taskService.getTasksAssignedByGroup(groupId, language));
    }

    public List<TaskSummary> getTasksAssignedByGroups(List<String> groupIds, String language) {
        return TaskSummaryHelper.adaptCollection(this.taskService.getTasksAssignedByGroups(groupIds, language));
    }

    public List<TaskSummary> getTasksAssignedPersonalAndGroupTasks(String userId, String groupId, String language) {
        List<TaskSummary> groupTasks = TaskSummaryHelper.adaptCollection(this.taskService.getTasksAssignedByGroup(groupId, language));
        List<TaskSummary> personalTasks = TaskSummaryHelper.adaptCollection(this.taskService.getTasksAssignedAsPotentialOwner(userId, language));
        groupTasks.addAll(personalTasks);
        return groupTasks;
    }

    public List<TaskSummary> getTasksAssignedPersonalAndGroupsTasks(String userId, List<String> groupIds, String language) {
        List<TaskSummary> groupTasks = TaskSummaryHelper.adaptCollection(this.taskService.getTasksAssignedByGroups(groupIds, language));
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Ready);
        statuses.add(Status.InProgress);
        statuses.add(Status.Reserved);
        statuses.add(Status.Created);
        List<TaskSummary> personalTasks = TaskSummaryHelper.adaptCollection(this.taskService.getTasksOwned(userId, statuses, language));
        groupTasks.addAll(personalTasks);
        return groupTasks;
    }

    public Map<String, List<TaskSummary>> getTasksAssignedPersonalAndGroupsTasksByDays(String userId, List<String> groupIds, String language) {
        Map<String, List<TaskSummary>> tasksAssignedByGroupsByDay = this.getTasksAssignedByGroupsByDay(userId, groupIds, language);
        Map<String, List<TaskSummary>> tasksOwnedByDay = this.getTasksOwnedByDay(userId, groupIds, language);
        for (String day : tasksOwnedByDay.keySet()) {
            tasksOwnedByDay.get(day).addAll((Collection<TaskSummary>)tasksAssignedByGroupsByDay.get(day));
        }
        return tasksOwnedByDay;
    }

    public Map<String, List<TaskSummary>> getTasksAssignedByGroupsByDay(String userId, List<String> groupIds, String language) {
        Date currentDay = new Date();
        LinkedHashMap<String, List<TaskSummary>> tasksByDay = new LinkedHashMap<String, List<TaskSummary>>();
        List<TaskSummary> todayTasks = TaskSummaryHelper.adaptCollection(this.taskService.getTasksAssignedByGroupsByExpirationDateOptional(groupIds, language, currentDay));
        SimpleDateFormat todayFormat = new SimpleDateFormat("EEEE");
        tasksByDay.put(todayFormat.format(currentDay), todayTasks);
        currentDay = new Date(currentDay.getTime() + 86400000L);
        for (int i = 1; i < 5; ++i) {
            List<TaskSummary> dayTasks = TaskSummaryHelper.adaptCollection(this.taskService.getTasksAssignedByGroupsByExpirationDate(groupIds, language, currentDay));
            SimpleDateFormat dayFormat = new SimpleDateFormat("EEEE");
            tasksByDay.put(dayFormat.format(currentDay), dayTasks);
            currentDay = new Date(currentDay.getTime() + 86400000L);
        }
        return tasksByDay;
    }

    public Map<String, List<TaskSummary>> getTasksOwnedByDay(String userId, List<String> groupIds, String language) {
        Date currentDay = new Date();
        LinkedHashMap<String, List<TaskSummary>> tasksByDay = new LinkedHashMap<String, List<TaskSummary>>();
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.InProgress);
        statuses.add(Status.Reserved);
        statuses.add(Status.Created);
        List<TaskSummary> todayTasks = TaskSummaryHelper.adaptCollection(this.taskService.getTasksOwnedByExpirationDateOptional(userId, statuses, currentDay));
        SimpleDateFormat todayFormat = new SimpleDateFormat("EEEE");
        tasksByDay.put(todayFormat.format(currentDay), todayTasks);
        currentDay = new Date(currentDay.getTime() + 86400000L);
        for (int i = 1; i < 5; ++i) {
            List<TaskSummary> dayTasks = TaskSummaryHelper.adaptCollection(this.taskService.getTasksOwnedByExpirationDate(userId, statuses, currentDay));
            SimpleDateFormat dayFormat = new SimpleDateFormat("EEEE");
            tasksByDay.put(dayFormat.format(currentDay), dayTasks);
            currentDay = new Date(currentDay.getTime() + 86400000L);
        }
        return tasksByDay;
    }

    public List<TaskSummary> getSubTasksByParent(long parentId) {
        return TaskSummaryHelper.adaptCollection(this.taskService.getSubTasksByParent(parentId));
    }

    public long addTask(String taskString, Map<String, Object> inputs, Map<String, Object> templateVars) {
        Task task = TaskFactory.evalTask((String)taskString, templateVars, (boolean)true);
        return this.taskService.addTask(task, inputs);
    }

    public long addTaskAndStart(String taskString, Map<String, Object> inputs, String userId, Map<String, Object> templateVars) {
        long taskId = this.addTask(taskString, inputs, templateVars);
        this.taskService.start(taskId, userId);
        return taskId;
    }

    public void start(long taskId, String user) {
        this.taskService.start(taskId, user);
    }

    public void startBatch(List<Long> taskIds, String user) {
        for (Long taskId : taskIds) {
            this.taskService.start(taskId.longValue(), user);
        }
    }

    public void forward(long taskId, String userId, String targetEntityId) {
        this.taskService.forward(taskId, userId, targetEntityId);
    }

    public void complete(long taskId, String user, Map<String, Object> params) {
        this.taskService.complete(taskId, user, params);
    }

    public void claim(long taskId, String user) {
        this.taskService.claim(taskId, user);
    }

    public void release(long taskId, String user) {
        this.taskService.release(taskId, user);
    }

    public void setPriority(long taskId, int priority) {
        this.taskService.setPriority(taskId, priority);
    }

    public void setTaskNames(long taskId, List<String> taskNames) {
        this.taskService.setTaskNames(taskId, TaskI18NHelper.adaptI18NList(taskNames));
    }

    public void setExpirationDate(long taskId, Date date) {
        this.taskService.setExpirationDate(taskId, date);
    }

    public void setDescriptions(long taskId, List<String> descriptions) {
        this.taskService.setDescriptions(taskId, TaskI18NHelper.adaptI18NList(descriptions));
    }

    public void setSkipable(long taskId, boolean skipable) {
        this.taskService.setSkipable(taskId, skipable);
    }

    public void setSubTaskStrategy(long taskId, String strategy) {
        this.taskService.setSubTaskStrategy(taskId, SubTasksStrategy.valueOf((String)strategy));
    }

    public int getPriority(long taskId) {
        return this.taskService.getPriority(taskId);
    }

    public Date getExpirationDate(long taskId) {
        return this.taskService.getExpirationDate(taskId);
    }

    public List<String> getDescriptions(long taskId) {
        return TaskI18NHelper.adaptStringList(this.taskService.getDescriptions(taskId));
    }

    public boolean isSkipable(long taskId) {
        return this.taskService.isSkipable(taskId);
    }

    public String getSubTaskStrategy(long taskId) {
        return this.taskService.getSubTaskStrategy(taskId).name();
    }

    public TaskSummary getTaskDetails(long taskId) {
        Task task = this.taskService.getTaskById(taskId);
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        ArrayList<String> potOwnersString = new ArrayList<String>(potentialOwners.size());
        for (OrganizationalEntity e : potentialOwners) {
            potOwnersString.add(e.getId());
        }
        return new TaskSummary(task.getId().longValue(), task.getTaskData().getProcessInstanceId(), task.getNames() != null && task.getNames().size() > 0 ? ((I18NText)task.getNames().get(0)).getText() : "", task.getSubjects() != null && task.getSubjects().size() > 0 ? ((I18NText)task.getSubjects().get(0)).getText() : "", task.getDescriptions() != null && task.getDescriptions().size() > 0 ? ((I18NText)task.getDescriptions().get(0)).getText() : "", task.getTaskData().getStatus().name(), task.getPriority(), task.getTaskData().isSkipable(), task.getTaskData().getActualOwner() != null ? task.getTaskData().getActualOwner().getId() : "", task.getTaskData().getCreatedBy() != null ? task.getTaskData().getCreatedBy().getId() : "", task.getTaskData().getCreatedOn(), task.getTaskData().getActivationTime(), task.getTaskData().getExpirationTime(), task.getTaskData().getProcessId(), task.getTaskData().getProcessSessionId(), task.getSubTaskStrategy().name(), (int)task.getTaskData().getParentId(), potOwnersString);
    }

    public long saveContent(long taskId, Map<String, String> values) {
        return this.addContent(taskId, values);
    }

    public long addContent(long taskId, Content content) {
        return this.taskService.addContent(taskId, content);
    }

    public long addContent(long taskId, Map<String, Object> values) {
        return this.taskService.addContent(taskId, values);
    }

    public void deleteContent(long taskId, long contentId) {
        this.taskService.deleteContent(taskId, contentId);
    }

    public List<Content> getAllContentByTaskId(long taskId) {
        return this.taskService.getAllContentByTaskId(taskId);
    }

    public Content getContentById(long contentId) {
        return this.taskService.getContentById(contentId);
    }

    public Map<String, String> getContentListById(long contentId) {
        Content contentById = this.getContentById(contentId);
        Object unmarshall = ContentMarshallerHelper.unmarshall((byte[])contentById.getContent(), null);
        return (Map)unmarshall;
    }

    public Map<String, String> getContentListByTaskId(long taskId) {
        Task taskInstanceById = this.taskService.getTaskById(taskId);
        long documentContentId = taskInstanceById.getTaskData().getDocumentContentId();
        Content contentById = this.getContentById(documentContentId);
        if (contentById == null) {
            return new HashMap<String, String>();
        }
        Object unmarshall = ContentMarshallerHelper.unmarshall((byte[])contentById.getContent(), null);
        if (unmarshall instanceof String && ((String)unmarshall).equals("")) {
            return new HashMap<String, String>();
        }
        return (Map)unmarshall;
    }

    public Map<String, String> getTaskOutputContentByTaskId(long taskId) {
        Task taskInstanceById = this.taskService.getTaskById(taskId);
        long documentContentId = taskInstanceById.getTaskData().getOutputContentId();
        if (documentContentId > 0L) {
            Content contentById = this.getContentById(documentContentId);
            if (contentById == null) {
                return new HashMap<String, String>();
            }
            Object unmarshall = ContentMarshallerHelper.unmarshall((byte[])contentById.getContent(), null);
            return (Map)unmarshall;
        }
        return new HashMap<String, String>();
    }

    public int getCompletedTaskByUserId(String userId) {
        return this.taskService.getCompletedTaskByUserId(userId);
    }

    public int getPendingTaskByUserId(String userId) {
        return this.taskService.getPendingTaskByUserId(userId);
    }

    public IdentitySummary getOrganizationalEntityById(String entityId) {
        OrganizationalEntity entity = this.taskService.getOrganizationalEntityById(entityId);
        if (entity != null) {
            IdentitySummary idSummary = new IdentitySummary(entity.getId(), "");
            if (entity instanceof User) {
                idSummary.setType("user");
            } else {
                idSummary.setType("group");
            }
            return idSummary;
        }
        return null;
    }

    public List<IdentitySummary> getOrganizationalEntities() {
        List users = this.taskService.getUsers();
        List groups = this.taskService.getGroups();
        ArrayList<IdentitySummary> allEntitites = new ArrayList<IdentitySummary>();
        if (users != null) {
            for (User user : users) {
                allEntitites.add(new IdentitySummary(user.getId(), "user"));
            }
        }
        if (users != null) {
            for (Group group : groups) {
                allEntitites.add(new IdentitySummary(group.getId(), "group"));
            }
        }
        return allEntitites;
    }

    public long addComment(long taskId, String text, String addedBy, Date addedOn) {
        Comment comment = new Comment();
        comment.setText(text);
        comment.setAddedAt(addedOn);
        comment.setAddedBy(new User(addedBy));
        return this.taskService.addComment(taskId, comment);
    }

    public void deleteComment(long taskId, long commentId) {
        this.taskService.deleteComment(taskId, commentId);
    }

    public List<CommentSummary> getAllCommentsByTaskId(long taskId) {
        return CommentSummaryHelper.adaptCollection(this.taskService.getAllCommentsByTaskId(taskId));
    }

    public CommentSummary getCommentById(long commentId) {
        return CommentSummaryHelper.adapt(this.taskService.getCommentById(commentId));
    }

    public void updateSimpleTaskDetails(long taskId, List<String> taskNames, int priority, List<String> taskDescription, String subTaskStrategy, Date dueDate) {
        this.setPriority(taskId, priority);
        this.setTaskNames(taskId, taskNames);
        this.setDescriptions(taskId, taskDescription);
        this.setSubTaskStrategy(taskId, subTaskStrategy);
        this.setExpirationDate(taskId, dueDate);
    }

    public void claimBatch(List<Long> taskIds, String user) {
        for (Long taskId : taskIds) {
            this.taskService.claim(taskId.longValue(), user);
        }
    }

    public void completeBatch(List<Long> taskIds, String user, Map<String, Object> params) {
        for (Long taskId : taskIds) {
            this.taskService.complete(taskId.longValue(), user, params);
        }
    }

    public void releaseBatch(List<Long> taskIds, String user) {
        for (Long taskId : taskIds) {
            this.taskService.release(taskId.longValue(), user);
        }
    }
}

