/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.console.ng.ht.backend.server.HumanTasksBackendBaseTest;
import org.jbpm.console.ng.ht.model.Day;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.services.task.impl.factories.TaskFactory;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.task.model.Task;

public abstract class TaskServiceEntryPointBaseTest
extends HumanTasksBackendBaseTest {
    @Test
    public void testGetTasksOwnedFromDateToDateByDaysNoTasks() {
        ArrayList<String> statuses = new ArrayList<String>();
        statuses.add("InProgress");
        statuses.add("Reserved");
        statuses.add("Created");
        Map tasksByDays = this.consoleTaskService.getTasksOwnedFromDateToDateByDays("Bobba Fet", statuses, this.createDate("2013-04-18"), 3, "en-UK");
        Assert.assertEquals((long)3L, (long)tasksByDays.size());
        for (Map.Entry entry : tasksByDays.entrySet()) {
            Assert.assertEquals((long)0L, (long)((List)entry.getValue()).size());
        }
    }

    @Test
    public void testGetTasksOwnedFromDateToDateByDays() {
        int i;
        String taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
        taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"yyyy-MM-dd\").parse(\"2011-10-15\") } ), ";
        taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')], }),";
        taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'Before the start date task 1')] })";
        this.createAndAddTask(taskStr);
        taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
        taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"yyyy-MM-dd\").parse(\"2013-04-19\") } ), ";
        taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')], }),";
        taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'Before the start date task 2')] })";
        this.createAndAddTask(taskStr);
        taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
        taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"yyyy-MM-dd\").parse(\"2013-04-24\") } ), ";
        taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')], }),";
        taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'After the end date task 1')] })";
        this.createAndAddTask(taskStr);
        taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
        taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"yyyy-MM-dd\").parse(\"2014-05-18\") } ), ";
        taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')], }),";
        taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'After the end date task 2')] })";
        this.createAndAddTask(taskStr);
        taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
        taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"yyyy-MM-dd\").parse(\"2013-04-20\") } ), ";
        taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Darth Vader')], }),";
        taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'Correct day but different owner')] })";
        this.createAndAddTask(taskStr);
        taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
        taskStr = taskStr + "expirationTime = null } ), ";
        taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')], }),";
        taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'No expiration date specified')] })";
        this.createAndAddTask(taskStr);
        int noExpDateTasksNr = 1;
        int firstDayTasksNr = 15;
        int secondDayTasksNr = 0;
        int thirdDayTasksNr = 1;
        int fourthDayTasksNr = 100;
        Date firstDay = this.createDate("2013-04-20");
        Date secondDay = this.createDate("2013-04-21");
        Date thirdDay = this.createDate("2013-04-22");
        Date fourthDay = this.createDate("2013-04-23");
        for (i = 0; i < firstDayTasksNr; ++i) {
            taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
            taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"yyyy-MM-dd\").parse(\"2013-04-20\") } ), ";
            taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')], }),";
            taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'First day task " + i + "')] })";
            this.createAndAddTask(taskStr);
        }
        for (i = 0; i < thirdDayTasksNr; ++i) {
            taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
            taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"yyyy-MM-dd\").parse(\"2013-04-22\") } ), ";
            taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')], }),";
            taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'Third day task " + i + "')] })";
            this.createAndAddTask(taskStr);
        }
        long beforeCreatingHundreadTasks = System.currentTimeMillis();
        System.out.println(beforeCreatingHundreadTasks);
        for (int i2 = 0; i2 < fourthDayTasksNr; ++i2) {
            taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
            taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"yyyy-MM-dd\").parse(\"2013-04-23\") } ), ";
            taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Bobba Fet')], }),";
            taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'Fourth day task " + i2 + "')] })";
            this.createAndAddTask(taskStr);
        }
        long afterCreatingHundreadTasks = System.currentTimeMillis();
        System.out.println(afterCreatingHundreadTasks);
        ArrayList<String> statuses = new ArrayList<String>();
        statuses.add("InProgress");
        statuses.add("Reserved");
        statuses.add("Created");
        Map tasksByDays = this.consoleTaskService.getTasksOwnedFromDateToDateByDays("Bobba Fet", statuses, this.createDate("2013-04-20"), 4, "en-UK");
        Assert.assertEquals((long)4L, (long)tasksByDays.size());
        for (Map.Entry entry : tasksByDays.entrySet()) {
            Date date = ((Day)entry.getKey()).getDate();
            List tasks = (List)entry.getValue();
            if (date.equals(firstDay)) {
                Assert.assertEquals((long)(firstDayTasksNr + noExpDateTasksNr), (long)tasks.size());
            } else if (date.equals(secondDay)) {
                Assert.assertEquals((long)secondDayTasksNr, (long)tasks.size());
            } else if (date.equals(thirdDay)) {
                Assert.assertEquals((long)thirdDayTasksNr, (long)tasks.size());
            } else if (date.equals(fourthDay)) {
                Assert.assertEquals((long)fourthDayTasksNr, (long)tasks.size());
            } else {
                Assert.fail((String)("Unexpected date in results map! Date=" + date.toString()));
            }
            this.checkTasksHaveExpectedExpirationDate(date, tasks);
        }
    }

    @Test
    public void testGetTasksAsssignedFromDateToDateByGroupsByDaysNoTasks() {
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Jedi Knights");
        groupIds.add("Sith Lords");
        Map tasksByDays = this.consoleTaskService.getTasksAssignedFromDateToDateByGroupsByDays("Anakin", groupIds, this.createDate("2013-04-18"), 3, "en-UK");
        Assert.assertEquals((long)3L, (long)tasksByDays.size());
        for (Map.Entry entry : tasksByDays.entrySet()) {
            Assert.assertEquals((long)0L, (long)((List)entry.getValue()).size());
        }
    }

    @Test
    public void testGetTasksAsssignedFromDateToDateByGroupsByDays() {
        int i;
        String taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
        taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"yyyy-MM-dd\").parse(\"2011-10-15\") } ), ";
        taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new Group('Jedi Knights')], }),";
        taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'Before the start date task 1')] })";
        this.createAndAddTask(taskStr);
        taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
        taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"yyyy-MM-dd\").parse(\"2013-04-19\") } ), ";
        taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new Group('Jedi Knights')], }),";
        taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'Before the start date task 2')] })";
        this.createAndAddTask(taskStr);
        taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
        taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"yyyy-MM-dd\").parse(\"2013-04-24\") } ), ";
        taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new Group('Sith Lords')], }),";
        taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'After the end date task 1')] })";
        this.createAndAddTask(taskStr);
        taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
        taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"yyyy-MM-dd\").parse(\"2014-05-18\") } ), ";
        taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new Group('Jedi Knights')], }),";
        taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'After the end date task 2')] })";
        this.createAndAddTask(taskStr);
        taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
        taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"yyyy-MM-dd\").parse(\"2013-04-20\") } ), ";
        taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new Group('Bounty Hunters')], }),";
        taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'Correct day but different owner')] })";
        this.createAndAddTask(taskStr);
        taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
        taskStr = taskStr + "expirationTime = null } ), ";
        taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new Group('Jedi Knights')], }),";
        taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'No expiration date specified')] })";
        this.createAndAddTask(taskStr);
        int noExpDateTasksNr = 1;
        int firstDayTasksNr = 0;
        int secondDayTasksNr = 10;
        int thirdDayTasksNr = 1;
        int fourthDayTasksNr = 50;
        Date firstDay = this.createDate("2013-04-20");
        Date secondDay = this.createDate("2013-04-21");
        Date thirdDay = this.createDate("2013-04-22");
        Date fourthDay = this.createDate("2013-04-23");
        for (i = 0; i < secondDayTasksNr; ++i) {
            taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
            taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"yyyy-MM-dd\").parse(\"2013-04-21\") } ), ";
            taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new Group('Jedi Knights')], }),";
            taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'Second day task " + i + "')] })";
            this.createAndAddTask(taskStr);
        }
        for (i = 0; i < thirdDayTasksNr; ++i) {
            taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
            taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"yyyy-MM-dd\").parse(\"2013-04-22\") } ), ";
            taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new Group('Jedi Knights')], }),";
            taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'Third day task " + i + "')] })";
            this.createAndAddTask(taskStr);
        }
        for (i = 0; i < fourthDayTasksNr; ++i) {
            taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
            taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"yyyy-MM-dd\").parse(\"2013-04-23\") } ), ";
            taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new Group('Sith Lords')], }),";
            taskStr = taskStr + "names = [ new I18NText( 'en-UK', 'Fourth day task " + i + "')] })";
            this.createAndAddTask(taskStr);
        }
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Jedi Knights");
        groupIds.add("Sith Lords");
        Map tasksByDays = this.consoleTaskService.getTasksAssignedFromDateToDateByGroupsByDays("Anakin", groupIds, this.createDate("2013-04-20"), 4, "en-UK");
        Assert.assertEquals((long)4L, (long)tasksByDays.size());
        for (Map.Entry entry : tasksByDays.entrySet()) {
            Date date = ((Day)entry.getKey()).getDate();
            List tasks = (List)entry.getValue();
            if (date.equals(firstDay)) {
                Assert.assertEquals((long)(firstDayTasksNr + noExpDateTasksNr), (long)tasks.size());
            } else if (date.equals(secondDay)) {
                Assert.assertEquals((long)secondDayTasksNr, (long)tasks.size());
            } else if (date.equals(thirdDay)) {
                Assert.assertEquals((long)thirdDayTasksNr, (long)tasks.size());
            } else if (date.equals(fourthDay)) {
                Assert.assertEquals((long)fourthDayTasksNr, (long)tasks.size());
            } else {
                Assert.fail((String)("Unexpected date in results map! Date=" + date.toString()));
            }
            this.checkTasksHaveExpectedExpirationDate(date, tasks);
        }
        Map tasksByDays2 = this.consoleTaskService.getTasksAssignedFromDateToDateByGroupsByDays("Anakin", groupIds, this.createDate("2013-04-20"), 4, "en-UK");
        Assert.assertEquals((Object)tasksByDays, (Object)tasksByDays2);
    }

    protected void createAndAddTask(String taskStr) {
        TaskImpl task = TaskFactory.evalTask((Reader)new StringReader(taskStr));
        this.taskService.addTask((Task)task, new HashMap());
    }

    protected void checkTasksHaveExpectedExpirationDate(Date expectedDate, List<TaskSummary> tasks) {
        for (TaskSummary task : tasks) {
            if (task.getExpirationTime() == null) continue;
            Assert.assertEquals((Object)expectedDate, (Object)task.getExpirationTime());
        }
    }
}

