/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.ht.backend.server.TaskSummaryHelper;
import org.jbpm.console.ng.ht.model.TaskKey;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.service.TaskQueryService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.task.query.QueryFilterImpl;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.InternalTaskService;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class TaskQueryServiceImpl
implements TaskQueryService {
    @Inject
    private InternalTaskService taskService;
    @Inject
    private RuntimeDataService runtimeDataService;

    public PageResponse<TaskSummary> getData(QueryFilter filter) {
        PageResponse response = new PageResponse();
        List statusesString = null;
        String userId = "";
        String taskRole = "";
        if (filter.getParams() != null) {
            userId = (String)filter.getParams().get("userId");
            statusesString = (List)filter.getParams().get("statuses");
            taskRole = (String)filter.getParams().get("taskRole");
        }
        ArrayList<Status> statuses = new ArrayList<Status>();
        for (String s : statusesString) {
            statuses.add(Status.valueOf((String)s));
        }
        QueryFilterImpl qf = new QueryFilterImpl(filter.getOffset().intValue(), filter.getCount() + 1, filter.getOrderBy(), filter.isAscending().booleanValue());
        List<Object> taskSummaries = new ArrayList();
        taskSummaries = "Administrator".equals(taskRole) ? TaskSummaryHelper.adaptCollection(this.runtimeDataService.getTasksAssignedAsBusinessAdministrator(userId, (org.kie.internal.query.QueryFilter)qf)) : TaskSummaryHelper.adaptCollection(this.runtimeDataService.getTasksAssignedAsPotentialOwner(userId, null, statuses, (org.kie.internal.query.QueryFilter)qf));
        response.setStartRowIndex(filter.getOffset().intValue());
        response.setTotalRowSize(taskSummaries.size() - 1);
        if (taskSummaries.size() > filter.getCount()) {
            response.setTotalRowSizeExact(false);
        } else {
            response.setTotalRowSizeExact(true);
        }
        if (!taskSummaries.isEmpty() && taskSummaries.size() > filter.getCount() + filter.getOffset()) {
            response.setPageRowList(new ArrayList<Object>(taskSummaries.subList(filter.getOffset(), filter.getOffset() + filter.getCount())));
            response.setLastPage(false);
        } else {
            response.setPageRowList(new ArrayList<Object>(taskSummaries));
            response.setLastPage(true);
        }
        return response;
    }

    public TaskSummary getItem(TaskKey key) {
        Task task = this.taskService.getTaskById(key.getTaskId().longValue());
        if (task != null) {
            List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
            ArrayList<String> potOwnersString = null;
            if (potentialOwners != null) {
                potOwnersString = new ArrayList<String>(potentialOwners.size());
                for (OrganizationalEntity e : potentialOwners) {
                    potOwnersString.add(e.getId());
                }
            }
            return new TaskSummary(task.getId().longValue(), task.getName(), task.getDescription(), task.getTaskData().getStatus().name(), task.getPriority(), task.getTaskData().getActualOwner() != null ? task.getTaskData().getActualOwner().getId() : "", task.getTaskData().getCreatedBy() != null ? task.getTaskData().getCreatedBy().getId() : "", task.getTaskData().getCreatedOn(), task.getTaskData().getActivationTime(), task.getTaskData().getExpirationTime(), task.getTaskData().getProcessId(), task.getTaskData().getProcessSessionId(), task.getTaskData().getProcessInstanceId(), task.getTaskData().getDeploymentId(), (long)((int)task.getTaskData().getParentId()));
        }
        return null;
    }
}

