/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.util.Collections;
import org.jbpm.console.ng.ht.backend.server.TaskOperationsServiceImpl;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.PeopleAssignmentsImpl;
import org.jbpm.services.task.impl.model.TaskDataImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.User;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TaskOperationsServiceImplTest {
    @Mock
    private UserTaskService taskService;
    @InjectMocks
    TaskOperationsServiceImpl taskOperationsService;

    @Test
    public void testAllowDelegateStatusCompleted() {
        long takId = 1L;
        TaskImpl task = new TaskImpl();
        TaskDataImpl taskData = new TaskDataImpl();
        taskData.setStatus(Status.Completed);
        task.setTaskData((TaskData)taskData);
        Mockito.when((Object)this.taskService.getTask(Long.valueOf(1L))).thenReturn((Object)task);
        Assert.assertFalse((boolean)this.taskOperationsService.allowDelegate(1L, null, null));
    }

    @Test
    public void testAllowDelegateNoTask() {
        Assert.assertFalse((boolean)this.taskOperationsService.allowDelegate(1L, null, null));
    }

    @Test
    public void testAllowDelegateNoData() {
        long takId = 1L;
        String userId = "user";
        String groupId = "group";
        TaskImpl task = new TaskImpl();
        TaskDataImpl taskData = new TaskDataImpl();
        task.setTaskData((TaskData)taskData);
        PeopleAssignmentsImpl peopleAssignments = new PeopleAssignmentsImpl();
        task.setPeopleAssignments((PeopleAssignments)peopleAssignments);
        Mockito.when((Object)this.taskService.getTask(Long.valueOf(1L))).thenReturn((Object)task);
        Assert.assertFalse((boolean)this.taskOperationsService.allowDelegate(1L, "user", Collections.singleton("group")));
    }

    @Test
    public void testAllowDelegateActualOwner() {
        long takId = 1L;
        String userId = "user";
        TaskImpl task = new TaskImpl();
        TaskDataImpl taskData = new TaskDataImpl();
        taskData.setActualOwner((User)new UserImpl("user"));
        task.setTaskData((TaskData)taskData);
        PeopleAssignmentsImpl peopleAssignments = new PeopleAssignmentsImpl();
        task.setPeopleAssignments((PeopleAssignments)peopleAssignments);
        Mockito.when((Object)this.taskService.getTask(Long.valueOf(1L))).thenReturn((Object)task);
        Assert.assertTrue((boolean)this.taskOperationsService.allowDelegate(1L, "user", Collections.emptySet()));
    }

    @Test
    public void testAllowDelegateInitiator() {
        long takId = 1L;
        String userId = "user";
        TaskImpl task = new TaskImpl();
        task.setTaskData((TaskData)new TaskDataImpl());
        PeopleAssignmentsImpl peopleAssignments = new PeopleAssignmentsImpl();
        peopleAssignments.setTaskInitiator((User)new UserImpl("user"));
        task.setPeopleAssignments((PeopleAssignments)peopleAssignments);
        Mockito.when((Object)this.taskService.getTask(Long.valueOf(1L))).thenReturn((Object)task);
        Assert.assertTrue((boolean)this.taskOperationsService.allowDelegate(1L, "user", Collections.emptySet()));
    }

    @Test
    public void testAllowDelegateUserInPotentialOwner() {
        long takId = 1L;
        String userId = "user";
        TaskImpl task = new TaskImpl();
        task.setTaskData((TaskData)new TaskDataImpl());
        PeopleAssignmentsImpl peopleAssignments = new PeopleAssignmentsImpl();
        peopleAssignments.setPotentialOwners(Collections.singletonList(new UserImpl("user")));
        task.setPeopleAssignments((PeopleAssignments)peopleAssignments);
        Mockito.when((Object)this.taskService.getTask(Long.valueOf(1L))).thenReturn((Object)task);
        Assert.assertTrue((boolean)this.taskOperationsService.allowDelegate(1L, "user", Collections.emptySet()));
    }

    @Test
    public void testAllowDelegateGroupInPotentialOwner() {
        long takId = 1L;
        String userId = "user";
        String groupId = "group";
        TaskImpl task = new TaskImpl();
        task.setTaskData((TaskData)new TaskDataImpl());
        PeopleAssignmentsImpl peopleAssignments = new PeopleAssignmentsImpl();
        peopleAssignments.setPotentialOwners(Collections.singletonList(new GroupImpl("group")));
        task.setPeopleAssignments((PeopleAssignments)peopleAssignments);
        Mockito.when((Object)this.taskService.getTask(Long.valueOf(1L))).thenReturn((Object)task);
        Assert.assertTrue((boolean)this.taskOperationsService.allowDelegate(1L, "user", Collections.singleton("group")));
    }

    @Test
    public void testAllowDelegateUserInBusinessAdministrators() {
        long takId = 1L;
        String userId = "user";
        TaskImpl task = new TaskImpl();
        task.setTaskData((TaskData)new TaskDataImpl());
        PeopleAssignmentsImpl peopleAssignments = new PeopleAssignmentsImpl();
        peopleAssignments.setBusinessAdministrators(Collections.singletonList(new UserImpl("user")));
        task.setPeopleAssignments((PeopleAssignments)peopleAssignments);
        Mockito.when((Object)this.taskService.getTask(Long.valueOf(1L))).thenReturn((Object)task);
        Assert.assertTrue((boolean)this.taskOperationsService.allowDelegate(1L, "user", Collections.emptySet()));
    }

    @Test
    public void testAllowDelegateGroupInBusinessAdministrators() {
        long takId = 1L;
        String userId = "user";
        String groupId = "group";
        TaskImpl task = new TaskImpl();
        task.setTaskData((TaskData)new TaskDataImpl());
        PeopleAssignmentsImpl peopleAssignments = new PeopleAssignmentsImpl();
        peopleAssignments.setBusinessAdministrators(Collections.singletonList(new GroupImpl("group")));
        task.setPeopleAssignments((PeopleAssignments)peopleAssignments);
        Mockito.when((Object)this.taskService.getTask(Long.valueOf(1L))).thenReturn((Object)task);
        Assert.assertTrue((boolean)this.taskOperationsService.allowDelegate(1L, "user", Collections.singleton("group")));
    }
}

