/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.jbpm.console.ng.ht.backend.server.RemoteTaskServiceImpl;
import org.jbpm.console.ng.ht.model.TaskEventSummary;
import org.jbpm.console.ng.ht.service.TaskService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.api.model.instance.TaskEventInstance;
import org.kie.server.api.model.instance.TaskInstance;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RemoteTaskServiceImplTest {
    private static final String CURRENT_USER = "Jan";
    private static final String OTHER_USER = "OTHER_USER";
    @InjectMocks
    private RemoteTaskServiceImpl remoteTaskService;
    @Mock
    IdentityProvider identityProvider;

    @Before
    public void initMocks() {
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)CURRENT_USER);
    }

    @Test
    public void allowDelegateStatusCompleted() {
        TaskInstance task = new TaskInstance();
        task.setStatus("Completed");
        Assert.assertFalse((boolean)this.remoteTaskService.isDelegationAllowed(task));
    }

    @Test
    public void allowDelegateActualOwner() {
        TaskInstance task = new TaskInstance();
        task.setActualOwner(CURRENT_USER);
        Assert.assertTrue((boolean)this.remoteTaskService.isDelegationAllowed(task));
    }

    @Test
    public void allowDelegateActualOwnerNotCurrentUser() {
        TaskInstance task = new TaskInstance();
        task.setActualOwner(OTHER_USER);
        Assert.assertFalse((boolean)this.remoteTaskService.isDelegationAllowed(task));
    }

    @Test
    public void allowDelegateCreatedBy() {
        TaskInstance task = new TaskInstance();
        task.setCreatedBy(CURRENT_USER);
        Assert.assertTrue((boolean)this.remoteTaskService.isDelegationAllowed(task));
    }

    @Test
    public void allowDelegateCreatedByNotCurrentUser() {
        TaskInstance task = new TaskInstance();
        task.setCreatedBy(OTHER_USER);
        Assert.assertFalse((boolean)this.remoteTaskService.isDelegationAllowed(task));
    }

    @Test
    public void allowDelegatePotentialOwner() {
        TaskInstance task = new TaskInstance();
        task.setPotentialOwners(Arrays.asList(CURRENT_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        Assert.assertTrue((boolean)this.remoteTaskService.isDelegationAllowed(task));
    }

    @Test
    public void allowDelegatePotentialOwnerNotCurrentUser() {
        TaskInstance task = new TaskInstance();
        task.setPotentialOwners(Arrays.asList(OTHER_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        Assert.assertFalse((boolean)this.remoteTaskService.isDelegationAllowed(task));
    }

    @Test
    public void allowDelegateBusinessAdmins() {
        TaskInstance task = new TaskInstance();
        task.setBusinessAdmins(Arrays.asList(CURRENT_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        Assert.assertTrue((boolean)this.remoteTaskService.isDelegationAllowed(task));
    }

    @Test
    public void allowDelegateBusinessAdminsNotCurrentUser() {
        TaskInstance task = new TaskInstance();
        task.setBusinessAdmins(Arrays.asList(OTHER_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        Assert.assertFalse((boolean)this.remoteTaskService.isDelegationAllowed(task));
    }

    @Test
    public void testBuildTaskEventSummary() {
        TaskEventInstance event = TaskEventInstance.builder().id(Long.valueOf(1L)).taskId(Long.valueOf(2L)).type("UPDATED").user("admin").date(new Date()).workItemId(Long.valueOf(3L)).message("message").build();
        TaskEventSummary summary = this.remoteTaskService.build(event);
        Assert.assertNotNull((Object)summary);
        Assert.assertEquals((Object)event.getId(), (Object)summary.getEventId());
        Assert.assertEquals((Object)event.getTaskId(), (Object)summary.getTaskId());
        Assert.assertEquals((Object)event.getType(), (Object)summary.getType());
        Assert.assertEquals((Object)event.getUserId(), (Object)summary.getUserId());
        Assert.assertEquals((Object)event.getLogTime(), (Object)summary.getLogTime());
        Assert.assertEquals((Object)event.getWorkItemId(), (Object)summary.getWorkItemId());
        Assert.assertEquals((Object)event.getMessage(), (Object)summary.getMessage());
    }

    @Test
    public void testInvalidServerTemplate() throws Exception {
        Method[] methods;
        for (Method method : methods = TaskService.class.getMethods()) {
            Class<?> returnType = method.getReturnType();
            Object[] args = new Object[method.getParameterCount()];
            Object result = method.invoke((Object)this.remoteTaskService, args);
            this.assertMethodResult(method, returnType, result);
            args[0] = "";
            result = method.invoke((Object)this.remoteTaskService, args);
            this.assertMethodResult(method, returnType, result);
        }
    }

    private void assertMethodResult(Method method, Class<?> returnType, Object result) {
        if (Collection.class.isAssignableFrom(returnType)) {
            Assert.assertNotNull((String)String.format("Returned collection for method %s should not be null", method.getName()), (Object)result);
            Assert.assertTrue((String)String.format("Returned collection for method %s should be empty", method.getName()), (boolean)((Collection)result).isEmpty());
        } else {
            Assert.assertNull((String)String.format("Returned object for method %s should be null", method.getName()), (Object)result);
        }
    }
}

