/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetClientServiceError;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.list.base.DataSetQueryHelper;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.service.TaskLifeCycleService;
import org.jbpm.console.ng.ht.service.TaskQueryService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.paging.PageResponse;

@Dependent
@WorkbenchScreen(identifier="DataSet Tasks List")
public class DataSetTasksListGridPresenter
extends AbstractScreenListPresenter<TaskSummary> {
    @Inject
    private DataSetTaskListView view;
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private Caller<TaskQueryService> taskQueryService;
    @Inject
    private Caller<TaskLifeCycleService> taskOperationsService;
    @Inject
    DataSetQueryHelper dataSetQueryHelper;
    @Inject
    private ErrorPopupPresenter errorPopup;

    public DataSetTasksListGridPresenter() {
        this.dataProvider = new AsyncDataProvider<TaskSummary>(){

            protected void onRangeChanged(HasData<TaskSummary> display) {
                DataSetTasksListGridPresenter.this.view.showBusyIndicator(DataSetTasksListGridPresenter.this.constants.Loading());
                Range visibleRange = DataSetTasksListGridPresenter.this.view.getListGrid().getVisibleRange();
                DataSetTasksListGridPresenter.this.getData(visibleRange);
            }
        };
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(final Range visibleRange) {
        try {
            FilterSettings currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings();
            if (currentTableSettings != null) {
                currentTableSettings.setTablePageSize(this.view.getListGrid().getPageSize());
                ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
                if (columnSortList != null && columnSortList.size() > 0) {
                    this.dataSetQueryHelper.setLastOrderedColumn(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
                    this.dataSetQueryHelper.setLastSortOrder(columnSortList.size() > 0 && columnSortList.get(0).isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
                } else {
                    this.dataSetQueryHelper.setLastOrderedColumn("createdOn");
                    this.dataSetQueryHelper.setLastSortOrder(SortOrder.ASCENDING);
                }
                this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
                this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(visibleRange.getStart()), new DataSetReadyCallback(){

                    public void callback(DataSet dataSet) {
                        if (dataSet != null) {
                            ArrayList<TaskSummary> myTasksFromDataSet = new ArrayList<TaskSummary>();
                            for (int i = 0; i < dataSet.getRowCount(); ++i) {
                                myTasksFromDataSet.add(new TaskSummary(DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnLongValue(dataSet, "taskId", i).longValue(), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "name", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "description", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "status", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnIntValue(dataSet, "priority", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "actualOwner", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "createdBy", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnDateValue(dataSet, "createdOn", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnDateValue(dataSet, "activationTime", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnDateValue(dataSet, "dueDate", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "processId", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnLongValue(dataSet, "processSessionId", i).longValue(), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnLongValue(dataSet, "processInstanceId", i).longValue(), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "deploymentId", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnLongValue(dataSet, "parentId", i).longValue(), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "potentialOwners", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "businessAdministrators", i)));
                            }
                            PageResponse taskSummaryPageResponse = new PageResponse();
                            taskSummaryPageResponse.setPageRowList(myTasksFromDataSet);
                            taskSummaryPageResponse.setStartRowIndex(visibleRange.getStart());
                            taskSummaryPageResponse.setTotalRowSize(dataSet.getRowCountNonTrimmed());
                            taskSummaryPageResponse.setTotalRowSizeExact(true);
                            if (visibleRange.getStart() + dataSet.getRowCount() == dataSet.getRowCountNonTrimmed()) {
                                taskSummaryPageResponse.setLastPage(true);
                            } else {
                                taskSummaryPageResponse.setLastPage(false);
                            }
                            DataSetTasksListGridPresenter.this.updateDataOnCallback(taskSummaryPageResponse);
                        }
                        DataSetTasksListGridPresenter.this.view.hideBusyIndicator();
                    }

                    public void notFound() {
                        DataSetTasksListGridPresenter.this.view.hideBusyIndicator();
                        DataSetTasksListGridPresenter.this.errorPopup.showMessage("Not found DataSet with UUID [  jbpmHumanTasks ] ");
                        GWT.log((String)"DataSet with UUID [  jbpmHumanTasks ] not found.");
                    }

                    public boolean onError(DataSetClientServiceError error) {
                        DataSetTasksListGridPresenter.this.view.hideBusyIndicator();
                        DataSetTasksListGridPresenter.this.errorPopup.showMessage("DataSet with UUID [  jbpmHumanTasks ] error: " + error.getThrowable());
                        GWT.log((String)"DataSet with UUID [  jbpmHumanTasks ] error: ", (Throwable)error.getThrowable());
                        return false;
                    }
                });
            } else {
                this.view.hideBusyIndicator();
            }
        }
        catch (Exception e) {
            GWT.log((String)"Error looking up dataset with UUID [ jbpmHumanTasks ]");
        }
    }

    public void filterGrid(FilterSettings tableSettings) {
        this.dataSetQueryHelper.setCurrentTableSetting(tableSettings);
        this.refreshGrid();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Tasks_List() + "DB";
    }

    @WorkbenchPartView
    public UberView<DataSetTasksListGridPresenter> getView() {
        return this.view;
    }

    public void releaseTask(Long taskId, String userId) {
        ((TaskLifeCycleService)this.taskOperationsService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                DataSetTasksListGridPresenter.this.view.displayNotification("Task Released");
                DataSetTasksListGridPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                DataSetTasksListGridPresenter.this.errorPopup.showMessage("Unexpected error encountered : " + throwable.getMessage());
                return true;
            }
        })).release(taskId.longValue(), userId);
    }

    public void claimTask(Long taskId, String userId, String deploymentId) {
        ((TaskLifeCycleService)this.taskOperationsService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                DataSetTasksListGridPresenter.this.view.displayNotification("Task Claimed");
                DataSetTasksListGridPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                DataSetTasksListGridPresenter.this.errorPopup.showMessage("Unexpected error encountered : " + throwable.getMessage());
                return true;
            }
        })).claim(taskId.longValue(), userId, deploymentId);
    }

    public static interface DataSetTaskListView
    extends AbstractListView.ListView<TaskSummary, DataSetTasksListGridPresenter> {
    }
}

