/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskdetails;

import com.github.gwtbootstrap.client.ui.ControlLabel;
import com.github.gwtbootstrap.client.ui.Label;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.gc.client.util.UTCDateBox;
import org.jbpm.console.ng.gc.client.util.UTCTimeBox;
import org.jbpm.console.ng.ht.client.editors.taskdetails.TaskDetailsPresenter;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated(value="TaskDetailsViewImpl.html")
public class TaskDetailsViewImpl
extends Composite
implements TaskDetailsPresenter.TaskDetailsView {
    private TaskDetailsPresenter presenter;
    @Inject
    @DataField
    public TextBox userText;
    @Inject
    @DataField
    public TextBox taskStatusText;
    @Inject
    @DataField
    public TextArea taskDescriptionTextArea;
    @Inject
    @DataField
    public ListBox taskPriorityListBox;
    @Inject
    @DataField
    public Label logTextLabel;
    @Inject
    @DataField
    public Label taskLogsLabel;
    @Inject
    @DataField
    public HTML logTextArea;
    @Inject
    @DataField
    public UTCDateBox dueDate;
    @Inject
    @DataField
    public UTCTimeBox dueDateTime;
    @Inject
    @DataField
    public Button updateTaskButton;
    @Inject
    @DataField
    public ControlLabel taskStatusLabel;
    @Inject
    @DataField
    public ControlLabel userLabel;
    @Inject
    @DataField
    public ControlLabel dueDateLabel;
    @Inject
    @DataField
    public ControlLabel taskPriorityLabel;
    @Inject
    @DataField
    public ControlLabel taskDescriptionLabel;
    @Inject
    @DataField
    public ControlLabel detailsAccordionLabel;
    @Inject
    private PlaceManager placeManager;
    private String[] priorities = new String[]{"0 - High", "1", "2", "3", "4", "5 - Medium", "6", "7", "8", "9", "10 - Low"};
    @Inject
    private Event<NotificationEvent> notification;
    private Constants constants = (Constants)GWT.create(Constants.class);

    @Override
    public void init(TaskDetailsPresenter presenter) {
        this.presenter = presenter;
        this.logTextLabel.setText(this.constants.Task_Log());
        for (String priority : this.priorities) {
            this.taskPriorityListBox.addItem(priority);
        }
        this.taskStatusLabel.add((Widget)new HTMLPanel(this.constants.Status()));
        this.userLabel.add((Widget)new HTMLPanel(this.constants.User()));
        this.dueDateLabel.add((Widget)new HTMLPanel(this.constants.Due_On()));
        this.taskPriorityLabel.add((Widget)new HTMLPanel(this.constants.Priority()));
        this.taskDescriptionLabel.add((Widget)new HTMLPanel(this.constants.Description()));
        this.detailsAccordionLabel.add((Widget)new HTMLPanel(this.constants.Details()));
        this.taskLogsLabel.setText(this.constants.Logs());
        this.taskLogsLabel.setStyleName("");
        this.updateTaskButton.setText(this.constants.Update());
    }

    @EventHandler(value={"updateTaskButton"})
    public void updateTaskButton(ClickEvent e) {
        this.presenter.updateTask(this.taskDescriptionTextArea.getText(), this.userText.getText(), this.dueDate.getValue() != null && this.dueDateTime.getValue() != null ? UTCDateBox.utc2date((Long)(this.dueDate.getValue() + this.dueDateTime.getValue())) : null, this.taskPriorityListBox.getSelectedIndex());
    }

    @Override
    public TextBox getUserText() {
        return this.userText;
    }

    @Override
    public TextArea getTaskDescriptionTextArea() {
        return this.taskDescriptionTextArea;
    }

    @Override
    public ListBox getTaskPriorityListBox() {
        return this.taskPriorityListBox;
    }

    @Override
    public UTCDateBox getDueDate() {
        return this.dueDate;
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @Override
    public String[] getPriorities() {
        return this.priorities;
    }

    @Override
    public TextBox getTaskStatusText() {
        return this.taskStatusText;
    }

    @Override
    public HTML getLogTextArea() {
        return this.logTextArea;
    }

    @Override
    public UTCTimeBox getDueDateTime() {
        return this.dueDateTime;
    }

    @Override
    public Button getUpdateTaskButton() {
        return this.updateTaskButton;
    }
}

