/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash;

import com.github.gwtbootstrap.client.ui.Button;
import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.cell.client.NumberCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.security.shared.api.Group;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.filter.FilterSettingsBuilderHelper;
import org.jbpm.console.ng.df.client.list.base.DataSetEditorManager;
import org.jbpm.console.ng.ga.model.GenericSummary;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractMultiGridView;
import org.jbpm.console.ng.gc.client.util.TaskUtils;
import org.jbpm.console.ng.ht.client.editors.quicknewtask.QuickNewTaskPopup;
import org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash.DataSetTasksListGridPresenter;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.model.events.NewTaskEvent;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.ColumnMeta;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.common.client.tables.popup.NewTabFilterPopup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
public class DataSetTasksListGridViewImpl
extends AbstractMultiGridView<TaskSummary, DataSetTasksListGridPresenter>
implements DataSetTasksListGridPresenter.DataSetTaskListView {
    public static String DATASET_TASK_LIST_PREFIX = "DataSetTaskListGrid";
    public static String HUMAN_TASKS_DATASET = "jbpmHumanTasks";
    public static String HUMAN_TASKS_WITH_USERS_DATASET = "jbpmHumanTasksWithUser";
    public static String HUMAN_TASKS_WITH_ADMINS_DATASET = "jbpmHumanTasksWithAdmin";
    public static final String COLUMN_ACTIVATIONTIME = "activationTime";
    public static final String COLUMN_ACTUALOWNER = "actualOwner";
    public static final String COLUMN_CREATEDBY = "createdBy";
    public static final String COLUMN_CREATEDON = "createdOn";
    public static final String COLUMN_DEPLOYMENTID = "deploymentId";
    public static final String COLUMN_DESCRIPTION = "description";
    public static final String COLUMN_DUEDATE = "dueDate";
    public static final String COLUMN_NAME = "name";
    public static final String COLUMN_PARENTID = "parentId";
    public static final String COLUMN_PRIORITY = "priority";
    public static final String COLUMN_PROCESSID = "processId";
    public static final String COLUMN_PROCESSINSTANCEID = "processInstanceId";
    public static final String COLUMN_PROCESSSESSIONID = "processSessionId";
    public static final String COLUMN_STATUS = "status";
    public static final String COLUMN_TASKID = "taskId";
    public static final String COLUMN_WORKITEMID = "workItemId";
    public static final String COLUMN_ORGANIZATIONAL_ENTITY = "oeid";
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private final Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private Event<TaskSelectionEvent> taskSelected;
    @Inject
    private QuickNewTaskPopup quickNewTaskPopup;
    @Inject
    private NewTabFilterPopup newTabFilterPopup;
    @Inject
    private DataSetEditorManager dataSetEditorManager;

    public void init(final DataSetTasksListGridPresenter presenter) {
        final ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add(this.constants.Task());
        final ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add(this.constants.Task());
        initColumns.add(this.constants.Description());
        initColumns.add(this.constants.Actions());
        final Button button = new Button();
        button.setText("+");
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final String key = DataSetTasksListGridViewImpl.this.getValidKeyForAdditionalListGrid(DATASET_TASK_LIST_PREFIX + "_");
                Command addNewGrid = new Command(){

                    public void execute() {
                        final ExtendedPagedTable extendedPagedTable = DataSetTasksListGridViewImpl.this.createGridInstance(new GridGlobalPreferences(key, initColumns, bannedColumns), key);
                        presenter.addDataDisplay((HasData)extendedPagedTable);
                        extendedPagedTable.setDataProvider(presenter.getDataProvider());
                        DataSetTasksListGridViewImpl.this.filterPagedTable.createNewTab((PagedTable)extendedPagedTable, key, button, new Command(){

                            public void execute() {
                                DataSetTasksListGridViewImpl.this.currentListGrid = extendedPagedTable;
                                DataSetTasksListGridViewImpl.this.applyFilterOnPresenter(key);
                            }
                        });
                        DataSetTasksListGridViewImpl.this.applyFilterOnPresenter(key);
                    }
                };
                FilterSettings tableSettings = DataSetTasksListGridViewImpl.this.createTableSettingsPrototype();
                tableSettings.setKey(key);
                DataSetTasksListGridViewImpl.this.dataSetEditorManager.showTableSettingsEditor(DataSetTasksListGridViewImpl.this.filterPagedTable, Constants.INSTANCE.New_FilteredList(), tableSettings, addNewGrid);
            }
        });
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences(DATASET_TASK_LIST_PREFIX, initColumns, bannedColumns), button);
    }

    public void initSelectionModel() {
        final ExtendedPagedTable extendedPagedTable = this.getListGrid();
        this.selectedStyles = new RowStyles<TaskSummary>(){

            public String getStyleNames(TaskSummary row, int rowIndex) {
                if (rowIndex == DataSetTasksListGridViewImpl.this.selectedRow) {
                    return "selected";
                }
                if (row.getStatus().equals("InProgress") || row.getStatus().equals("Ready")) {
                    if (row.getPriority() == 5) {
                        return "five";
                    }
                    if (row.getPriority() == 4) {
                        return "four";
                    }
                    if (row.getPriority() == 3) {
                        return "three";
                    }
                    if (row.getPriority() == 2) {
                        return "two";
                    }
                    if (row.getPriority() == 1) {
                        return "one";
                    }
                } else if (row.getStatus().equals("Completed")) {
                    return "completed";
                }
                return null;
            }
        };
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Tasks_Found());
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                boolean close = false;
                if (DataSetTasksListGridViewImpl.this.selectedRow == -1) {
                    DataSetTasksListGridViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.setRowStyles(DataSetTasksListGridViewImpl.this.selectedStyles);
                    extendedPagedTable.redraw();
                } else if (extendedPagedTable.getKeyboardSelectedRow() != DataSetTasksListGridViewImpl.this.selectedRow) {
                    extendedPagedTable.setRowStyles(DataSetTasksListGridViewImpl.this.selectedStyles);
                    DataSetTasksListGridViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                } else {
                    close = true;
                }
                DataSetTasksListGridViewImpl.this.selectedItem = (GenericSummary)DataSetTasksListGridViewImpl.this.selectionModel.getLastSelectedObject();
                DefaultPlaceRequest defaultPlaceRequest = new DefaultPlaceRequest("Task Details Multi");
                PlaceStatus status = DataSetTasksListGridViewImpl.this.placeManager.getStatus((PlaceRequest)defaultPlaceRequest);
                boolean logOnly = false;
                if (((TaskSummary)DataSetTasksListGridViewImpl.this.selectedItem).getStatus().equals("Completed") && ((TaskSummary)DataSetTasksListGridViewImpl.this.selectedItem).isLogOnly()) {
                    logOnly = true;
                }
                if (status == PlaceStatus.CLOSE) {
                    DataSetTasksListGridViewImpl.this.placeManager.goTo((PlaceRequest)defaultPlaceRequest);
                    DataSetTasksListGridViewImpl.this.taskSelected.fire((Object)new TaskSelectionEvent(((TaskSummary)DataSetTasksListGridViewImpl.this.selectedItem).getTaskId(), ((TaskSummary)DataSetTasksListGridViewImpl.this.selectedItem).getTaskName(), ((TaskSummary)DataSetTasksListGridViewImpl.this.selectedItem).isForAdmin(), logOnly));
                } else if (status == PlaceStatus.OPEN && !close) {
                    DataSetTasksListGridViewImpl.this.taskSelected.fire((Object)new TaskSelectionEvent(((TaskSummary)DataSetTasksListGridViewImpl.this.selectedItem).getTaskId(), ((TaskSummary)DataSetTasksListGridViewImpl.this.selectedItem).getTaskName(), ((TaskSummary)DataSetTasksListGridViewImpl.this.selectedItem).isForAdmin(), logOnly));
                } else if (status == PlaceStatus.OPEN && close) {
                    DataSetTasksListGridViewImpl.this.placeManager.closePlace("Task Details Multi");
                }
            }
        });
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<TaskSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<TaskSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<TaskSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType()) && extendedPagedTable.getColumnIndex(DataSetTasksListGridViewImpl.this.actionsColumn) == event.getColumn()) {
                    return DefaultSelectionEventManager.SelectAction.IGNORE;
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
        extendedPagedTable.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        extendedPagedTable.setRowStyles(this.selectedStyles);
    }

    public void initExtraButtons(ExtendedPagedTable extendedPagedTable) {
    }

    public void initColumns(ExtendedPagedTable extendedPagedTable) {
        this.initCellPreview(extendedPagedTable);
        Column taskIdColumn = this.initTaskIdColumn();
        Column taskNameColumn = this.initTaskNameColumn();
        Column descriptionColumn = this.initTaskDescriptionColumn();
        Column processIdColumn = this.initProcesIdColumn();
        Column processInstanceIdColumn = this.initProcessInstanceIdColumn();
        Column taskPriorityColumn = this.initTaskPriorityColumn();
        Column statusColumn = this.initTaskStatusColumn();
        Column createdOnDateColumn = this.initTaskCreatedOnColumn();
        Column dueDateColumn = this.initTaskDueColumn();
        this.actionsColumn = this.initActionsColumn(extendedPagedTable);
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(taskIdColumn, this.constants.Id()));
        columnMetas.add(new ColumnMeta(taskNameColumn, this.constants.Task()));
        columnMetas.add(new ColumnMeta(descriptionColumn, this.constants.Description()));
        columnMetas.add(new ColumnMeta(processIdColumn, this.constants.Process_Name()));
        columnMetas.add(new ColumnMeta(processInstanceIdColumn, this.constants.Process_Id()));
        columnMetas.add(new ColumnMeta(taskPriorityColumn, this.constants.Priority()));
        columnMetas.add(new ColumnMeta(statusColumn, this.constants.Status()));
        columnMetas.add(new ColumnMeta(createdOnDateColumn, "CreatedOn"));
        columnMetas.add(new ColumnMeta(dueDateColumn, "DueOn"));
        columnMetas.add(new ColumnMeta(this.actionsColumn, this.constants.Actions()));
        extendedPagedTable.addColumns(columnMetas);
    }

    private void initCellPreview(final ExtendedPagedTable extendedPagedTable) {
        extendedPagedTable.addCellPreviewHandler((CellPreviewEvent.Handler)new CellPreviewEvent.Handler<TaskSummary>(){

            public void onCellPreview(CellPreviewEvent<TaskSummary> event) {
                if ("mouseover".equalsIgnoreCase(event.getNativeEvent().getType())) {
                    DataSetTasksListGridViewImpl.this.onMouseOverGrid(extendedPagedTable, (CellPreviewEvent<TaskSummary>)event);
                }
            }
        });
    }

    private void onMouseOverGrid(ExtendedPagedTable extendedPagedTable, CellPreviewEvent<TaskSummary> event) {
        TaskSummary task = (TaskSummary)event.getValue();
        if (task.getDescription() != null) {
            extendedPagedTable.setTooltip(extendedPagedTable.getKeyboardSelectedRow(), event.getColumn(), task.getDescription());
        }
    }

    private Column initTaskIdColumn() {
        Column<TaskSummary, Number> taskIdColumn = new Column<TaskSummary, Number>((Cell)new NumberCell()){

            public Number getValue(TaskSummary object) {
                return object.getTaskId();
            }
        };
        taskIdColumn.setSortable(true);
        taskIdColumn.setDataStoreName(COLUMN_TASKID);
        return taskIdColumn;
    }

    private Column initTaskNameColumn() {
        Column<TaskSummary, String> taskNameColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return object.getTaskName();
            }
        };
        taskNameColumn.setSortable(true);
        taskNameColumn.setDataStoreName(COLUMN_NAME);
        return taskNameColumn;
    }

    private Column initTaskDescriptionColumn() {
        Column<TaskSummary, String> descriptionColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return object.getDescription();
            }
        };
        descriptionColumn.setSortable(true);
        descriptionColumn.setDataStoreName(COLUMN_DESCRIPTION);
        return descriptionColumn;
    }

    private Column initTaskPriorityColumn() {
        Column<TaskSummary, Number> taskPriorityColumn = new Column<TaskSummary, Number>((Cell)new NumberCell()){

            public Number getValue(TaskSummary object) {
                return object.getPriority();
            }
        };
        taskPriorityColumn.setSortable(true);
        taskPriorityColumn.setDataStoreName(COLUMN_PRIORITY);
        return taskPriorityColumn;
    }

    private Column initTaskStatusColumn() {
        Column<TaskSummary, String> statusColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return object.getStatus();
            }
        };
        statusColumn.setSortable(true);
        statusColumn.setDataStoreName(COLUMN_STATUS);
        return statusColumn;
    }

    private Column initTaskCreatedOnColumn() {
        Column<TaskSummary, String> createdOnDateColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                if (object.getCreatedOn() != null) {
                    Date createdOn = object.getCreatedOn();
                    DateTimeFormat format = DateTimeFormat.getFormat((String)"dd/MM/yyyy HH:mm");
                    return format.format(createdOn);
                }
                return "";
            }
        };
        createdOnDateColumn.setSortable(true);
        createdOnDateColumn.setDataStoreName(COLUMN_CREATEDON);
        return createdOnDateColumn;
    }

    private Column initTaskDueColumn() {
        Column<TaskSummary, String> dueDateColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                if (object.getExpirationTime() != null) {
                    Date expirationTime = object.getExpirationTime();
                    DateTimeFormat format = DateTimeFormat.getFormat((String)"dd/MM/yyyy HH:mm");
                    return format.format(expirationTime);
                }
                return "";
            }
        };
        dueDateColumn.setSortable(true);
        dueDateColumn.setDataStoreName(COLUMN_DUEDATE);
        return dueDateColumn;
    }

    private Column initProcesIdColumn() {
        Column<TaskSummary, String> taskProcessIdColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return object.getProcessId();
            }
        };
        taskProcessIdColumn.setSortable(true);
        taskProcessIdColumn.setDataStoreName(COLUMN_PROCESSID);
        return taskProcessIdColumn;
    }

    private Column initProcessInstanceIdColumn() {
        Column<TaskSummary, Number> taskProcessInstanceIdColumn = new Column<TaskSummary, Number>((Cell)new NumberCell()){

            public Number getValue(TaskSummary object) {
                return object.getProcessInstanceId();
            }
        };
        taskProcessInstanceIdColumn.setSortable(true);
        taskProcessInstanceIdColumn.setDataStoreName(COLUMN_PROCESSINSTANCEID);
        return taskProcessInstanceIdColumn;
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        ((DataSetTasksListGridPresenter)this.presenter).refreshGrid();
    }

    private Column initActionsColumn(final ExtendedPagedTable extendedPagedTable) {
        LinkedList<Object> cells = new LinkedList<Object>();
        cells.add(new ClaimActionHasCell(this.constants.Claim(), new ActionCell.Delegate<TaskSummary>(){

            public void execute(TaskSummary task) {
                ((DataSetTasksListGridPresenter)DataSetTasksListGridViewImpl.this.presenter).claimTask(task.getTaskId(), DataSetTasksListGridViewImpl.this.identity.getIdentifier(), task.getDeploymentId());
                DataSetTasksListGridViewImpl.this.taskSelected.fire((Object)new TaskSelectionEvent(task.getTaskId(), task.getTaskName()));
                extendedPagedTable.refresh();
            }
        }));
        cells.add(new ReleaseActionHasCell(this.constants.Release(), new ActionCell.Delegate<TaskSummary>(){

            public void execute(TaskSummary task) {
                ((DataSetTasksListGridPresenter)DataSetTasksListGridViewImpl.this.presenter).releaseTask(task.getTaskId(), DataSetTasksListGridViewImpl.this.identity.getIdentifier());
                DataSetTasksListGridViewImpl.this.taskSelected.fire((Object)new TaskSelectionEvent(task.getTaskId(), task.getTaskName()));
                extendedPagedTable.refresh();
            }
        }));
        cells.add(new CompleteActionHasCell(this.constants.Complete(), new ActionCell.Delegate<TaskSummary>(){

            public void execute(TaskSummary task) {
                DataSetTasksListGridViewImpl.this.placeManager.goTo("Task Details Multi");
                boolean logOnly = false;
                if (task.getStatus().equals("Completed") && task.isLogOnly()) {
                    logOnly = true;
                }
                DataSetTasksListGridViewImpl.this.taskSelected.fire((Object)new TaskSelectionEvent(task.getTaskId(), task.getName(), task.isForAdmin(), logOnly));
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<TaskSummary, TaskSummary> actionsColumn = new Column<TaskSummary, TaskSummary>((Cell)cell){

            public TaskSummary getValue(TaskSummary object) {
                return object;
            }
        };
        return actionsColumn;
    }

    public void refreshNewTask(@Observes NewTaskEvent newTask) {
        ((DataSetTasksListGridPresenter)this.presenter).refreshGrid();
        PlaceStatus status = this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest("Task Details Multi"));
        if (status == PlaceStatus.OPEN) {
            this.taskSelected.fire((Object)new TaskSelectionEvent(newTask.getNewTaskId(), newTask.getNewTaskName()));
        } else {
            this.placeManager.goTo("Task Details Multi");
            this.taskSelected.fire((Object)new TaskSelectionEvent(newTask.getNewTaskId(), newTask.getNewTaskName()));
        }
        this.selectionModel.setSelected((Object)new TaskSummary(newTask.getNewTaskId(), newTask.getNewTaskName()), true);
    }

    private PlaceStatus getPlaceStatus(String place) {
        DefaultPlaceRequest defaultPlaceRequest = new DefaultPlaceRequest(place);
        PlaceStatus status = this.placeManager.getStatus((PlaceRequest)defaultPlaceRequest);
        return status;
    }

    private void closePlace(String place) {
        if (this.getPlaceStatus(place) == PlaceStatus.OPEN) {
            this.placeManager.closePlace(place);
        }
    }

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
        List states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ACTIVE);
        this.initGenericTabFilter(preferences, DATASET_TASK_LIST_PREFIX + "_0", Constants.INSTANCE.Active(), "Filter " + Constants.INSTANCE.Active(), states, "Potential Owner");
        states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.PERSONAL);
        this.initGenericTabFilter(preferences, DATASET_TASK_LIST_PREFIX + "_1", Constants.INSTANCE.Personal(), "Filter " + Constants.INSTANCE.Personal(), states, "Potential Owner");
        states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.GROUP);
        this.initGroupTabFilter(preferences, DATASET_TASK_LIST_PREFIX + "_2", Constants.INSTANCE.Group(), "Filter " + Constants.INSTANCE.Group(), states, "Potential Owner");
        states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ALL);
        this.initGenericTabFilter(preferences, DATASET_TASK_LIST_PREFIX + "_3", Constants.INSTANCE.All(), "Filter " + Constants.INSTANCE.All(), states, "Potential Owner");
        states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ADMIN);
        this.initAdminTabFilter(preferences, DATASET_TASK_LIST_PREFIX + "_4", Constants.INSTANCE.Task_Admin(), "Filter " + Constants.INSTANCE.Task_Admin(), states, "Administrator");
        this.filterPagedTable.addAddTableButton(createTabButton);
        this.getMultiGridPreferencesStore().setSelectedGrid(DATASET_TASK_LIST_PREFIX + "_0");
        this.filterPagedTable.setSelectedTab();
        this.applyFilterOnPresenter(DATASET_TASK_LIST_PREFIX + "_0");
    }

    private void initGroupTabFilter(GridGlobalPreferences preferences, final String key, String tabName, String tabDesc, List<String> states, String role) {
        ExtendedPagedTable extendedPagedTable;
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset(HUMAN_TASKS_WITH_USERS_DATASET);
        ArrayList<String> names = new ArrayList<String>();
        for (String s : states) {
            names.add(s);
        }
        builder.filter(COLUMN_STATUS, new ColumnFilter[]{FilterFactory.equalsTo((String)COLUMN_STATUS, names)});
        Set groups = this.identity.getGroups();
        builder.filter(COLUMN_ACTUALOWNER, new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)""))});
        ArrayList<ColumnFilter> condList = new ArrayList<ColumnFilter>();
        for (Group g : groups) {
            condList.add(FilterFactory.equalsTo((Comparable)((Object)g.getName())));
        }
        builder.filter(COLUMN_ORGANIZATIONAL_ENTITY, new ColumnFilter[]{FilterFactory.OR(condList)});
        builder.group(COLUMN_TASKID);
        builder.setColumn(COLUMN_ACTIVATIONTIME, "Activation Time", "MMM dd E, yyyy");
        builder.setColumn(COLUMN_ACTUALOWNER, this.constants.Actual_Owner());
        builder.setColumn(COLUMN_CREATEDBY, "CreatedBy");
        builder.setColumn(COLUMN_CREATEDON, "Created on", "MMM dd E, yyyy");
        builder.setColumn(COLUMN_DEPLOYMENTID, "DeploymentId");
        builder.setColumn(COLUMN_DESCRIPTION, this.constants.Description());
        builder.setColumn(COLUMN_DUEDATE, "Due Date", "MMM dd E, yyyy");
        builder.setColumn(COLUMN_NAME, this.constants.Task());
        builder.setColumn(COLUMN_PARENTID, "ParentId");
        builder.setColumn(COLUMN_PRIORITY, "Priority");
        builder.setColumn(COLUMN_PROCESSID, "ProcessId");
        builder.setColumn(COLUMN_PROCESSINSTANCEID, "ProcessInstanceId");
        builder.setColumn(COLUMN_PROCESSSESSIONID, "ProcessSesionId");
        builder.setColumn(COLUMN_STATUS, this.constants.Status());
        builder.setColumn(COLUMN_TASKID, this.constants.Id());
        builder.setColumn(COLUMN_WORKITEMID, "WorkItemId");
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault(COLUMN_CREATEDON, SortOrder.DESCENDING);
        FilterSettings tableSettings = builder.buildSettings();
        tableSettings.setKey(key);
        tableSettings.setTableName(tabName);
        tableSettings.setTableDescription(tabDesc);
        HashMap<String, String> tabSettingsValues = new HashMap<String, String>();
        tabSettingsValues.put(FILTER_TABLE_SETTINGS, this.dataSetEditorManager.getTableSettingsToStr(tableSettings));
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, tableSettings.getTableName());
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, tableSettings.getTableDescription());
        this.filterPagedTable.saveNewTabSettings(key, tabSettingsValues);
        this.currentListGrid = extendedPagedTable = this.createGridInstance(new GridGlobalPreferences(key, preferences.getInitialColumns(), preferences.getBannedColumns()), key);
        ((DataSetTasksListGridPresenter)this.presenter).addDataDisplay((HasData)extendedPagedTable);
        extendedPagedTable.setDataProvider(((DataSetTasksListGridPresenter)this.presenter).getDataProvider());
        this.filterPagedTable.addTab((PagedTable)extendedPagedTable, key, new Command(){

            public void execute() {
                DataSetTasksListGridViewImpl.this.currentListGrid = extendedPagedTable;
                DataSetTasksListGridViewImpl.this.applyFilterOnPresenter(key);
            }
        });
    }

    private void initAdminTabFilter(GridGlobalPreferences preferences, final String key, String tabName, String tabDesc, List<String> states, String role) {
        ExtendedPagedTable extendedPagedTable;
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset(HUMAN_TASKS_WITH_ADMINS_DATASET);
        ArrayList<String> names = new ArrayList<String>();
        for (String s : states) {
            names.add(s);
        }
        builder.filter(COLUMN_STATUS, new ColumnFilter[]{FilterFactory.equalsTo((String)COLUMN_STATUS, names)});
        Set groups = this.identity.getGroups();
        ArrayList<ColumnFilter> condList = new ArrayList<ColumnFilter>();
        for (Group g : groups) {
            condList.add(FilterFactory.equalsTo((Comparable)((Object)g.getName())));
        }
        condList.add(FilterFactory.equalsTo((Comparable)((Object)this.identity.getIdentifier())));
        builder.filter(COLUMN_ORGANIZATIONAL_ENTITY, new ColumnFilter[]{FilterFactory.OR(condList)});
        builder.group(COLUMN_TASKID);
        builder.setColumn(COLUMN_ACTIVATIONTIME, "Activation Time", "MMM dd E, yyyy");
        builder.setColumn(COLUMN_ACTUALOWNER, this.constants.Actual_Owner());
        builder.setColumn(COLUMN_CREATEDBY, "CreatedBy");
        builder.setColumn(COLUMN_CREATEDON, "Created on", "MMM dd E, yyyy");
        builder.setColumn(COLUMN_DEPLOYMENTID, "DeploymentId");
        builder.setColumn(COLUMN_DESCRIPTION, this.constants.Description());
        builder.setColumn(COLUMN_DUEDATE, "Due Date", "MMM dd E, yyyy");
        builder.setColumn(COLUMN_NAME, this.constants.Task());
        builder.setColumn(COLUMN_PARENTID, "ParentId");
        builder.setColumn(COLUMN_PRIORITY, "Priority");
        builder.setColumn(COLUMN_PROCESSID, "ProcessId");
        builder.setColumn(COLUMN_PROCESSINSTANCEID, "ProcessInstanceId");
        builder.setColumn(COLUMN_PROCESSSESSIONID, "ProcessSesionId");
        builder.setColumn(COLUMN_STATUS, this.constants.Status());
        builder.setColumn(COLUMN_TASKID, this.constants.Id());
        builder.setColumn(COLUMN_WORKITEMID, "WorkItemId");
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault(COLUMN_CREATEDON, SortOrder.DESCENDING);
        FilterSettings tableSettings = builder.buildSettings();
        tableSettings.setKey(key);
        tableSettings.setTableName(tabName);
        tableSettings.setTableDescription(tabDesc);
        HashMap<String, String> tabSettingsValues = new HashMap<String, String>();
        tabSettingsValues.put(FILTER_TABLE_SETTINGS, this.dataSetEditorManager.getTableSettingsToStr(tableSettings));
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, tableSettings.getTableName());
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, tableSettings.getTableDescription());
        this.filterPagedTable.saveNewTabSettings(key, tabSettingsValues);
        this.currentListGrid = extendedPagedTable = this.createGridInstance(new GridGlobalPreferences(key, preferences.getInitialColumns(), preferences.getBannedColumns()), key);
        ((DataSetTasksListGridPresenter)this.presenter).addDataDisplay((HasData)extendedPagedTable);
        extendedPagedTable.setDataProvider(((DataSetTasksListGridPresenter)this.presenter).getDataProvider());
        this.filterPagedTable.addTab((PagedTable)extendedPagedTable, key, new Command(){

            public void execute() {
                DataSetTasksListGridViewImpl.this.currentListGrid = extendedPagedTable;
                DataSetTasksListGridViewImpl.this.applyFilterOnPresenter(key);
            }
        });
    }

    private void initGenericTabFilter(GridGlobalPreferences preferences, final String key, String tabName, String tabDesc, List<String> states, String role) {
        ExtendedPagedTable extendedPagedTable;
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset(HUMAN_TASKS_DATASET);
        ArrayList<String> names = new ArrayList<String>();
        for (String s : states) {
            names.add(s);
        }
        builder.filter(new ColumnFilter[]{FilterFactory.equalsTo((String)COLUMN_STATUS, names)});
        builder.setColumn(COLUMN_ACTIVATIONTIME, "Activation Time", "MMM dd E, yyyy");
        builder.setColumn(COLUMN_ACTUALOWNER, this.constants.Actual_Owner());
        builder.setColumn(COLUMN_CREATEDBY, "CreatedBy");
        builder.setColumn(COLUMN_CREATEDON, "Created on", "MMM dd E, yyyy");
        builder.setColumn(COLUMN_DEPLOYMENTID, "DeploymentId");
        builder.setColumn(COLUMN_DESCRIPTION, this.constants.Description());
        builder.setColumn(COLUMN_DUEDATE, "Due Date", "MMM dd E, yyyy");
        builder.setColumn(COLUMN_NAME, this.constants.Task());
        builder.setColumn(COLUMN_PARENTID, "ParentId");
        builder.setColumn(COLUMN_PRIORITY, "Priority");
        builder.setColumn(COLUMN_PROCESSID, "ProcessId");
        builder.setColumn(COLUMN_PROCESSINSTANCEID, "ProcessInstanceId");
        builder.setColumn(COLUMN_PROCESSSESSIONID, "ProcessSesionId");
        builder.setColumn(COLUMN_STATUS, this.constants.Status());
        builder.setColumn(COLUMN_TASKID, this.constants.Id());
        builder.setColumn(COLUMN_WORKITEMID, "WorkItemId");
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault(COLUMN_CREATEDON, SortOrder.DESCENDING);
        FilterSettings tableSettings = builder.buildSettings();
        tableSettings.setKey(key);
        tableSettings.setTableName(tabName);
        tableSettings.setTableDescription(tabDesc);
        HashMap<String, String> tabSettingsValues = new HashMap<String, String>();
        tabSettingsValues.put(FILTER_TABLE_SETTINGS, this.dataSetEditorManager.getTableSettingsToStr(tableSettings));
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, tableSettings.getTableName());
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, tableSettings.getTableDescription());
        this.filterPagedTable.saveNewTabSettings(key, tabSettingsValues);
        this.currentListGrid = extendedPagedTable = this.createGridInstance(new GridGlobalPreferences(key, preferences.getInitialColumns(), preferences.getBannedColumns()), key);
        ((DataSetTasksListGridPresenter)this.presenter).addDataDisplay((HasData)extendedPagedTable);
        extendedPagedTable.setDataProvider(((DataSetTasksListGridPresenter)this.presenter).getDataProvider());
        this.filterPagedTable.addTab((PagedTable)extendedPagedTable, key, new Command(){

            public void execute() {
                DataSetTasksListGridViewImpl.this.currentListGrid = extendedPagedTable;
                DataSetTasksListGridViewImpl.this.applyFilterOnPresenter(key);
            }
        });
    }

    public void applyFilterOnPresenter(HashMap<String, Object> params) {
        String tableSettingsJSON = (String)params.get(FILTER_TABLE_SETTINGS);
        FilterSettings tableSettings = this.dataSetEditorManager.getStrToTableSettings(tableSettingsJSON);
        ((DataSetTasksListGridPresenter)this.presenter).filterGrid(tableSettings);
    }

    public void applyFilterOnPresenter(String key) {
        this.initSelectionModel();
        this.applyFilterOnPresenter(this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(key));
    }

    public FilterSettings createTableSettingsPrototype() {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset(HUMAN_TASKS_DATASET);
        builder.setColumn(COLUMN_ACTIVATIONTIME, "Activation Time", "MMM dd E, yyyy");
        builder.setColumn(COLUMN_ACTUALOWNER, this.constants.Actual_Owner());
        builder.setColumn(COLUMN_CREATEDBY, "CreatedBy");
        builder.setColumn(COLUMN_CREATEDON, "Created on", "MMM dd E, yyyy");
        builder.setColumn(COLUMN_DEPLOYMENTID, "DeploymentId");
        builder.setColumn(COLUMN_DESCRIPTION, this.constants.Description());
        builder.setColumn(COLUMN_DUEDATE, "Due Date", "MMM dd E, yyyy");
        builder.setColumn(COLUMN_NAME, this.constants.Task());
        builder.setColumn(COLUMN_PARENTID, "ParentId");
        builder.setColumn(COLUMN_PRIORITY, "Priority");
        builder.setColumn(COLUMN_PROCESSID, "ProcessId");
        builder.setColumn(COLUMN_PROCESSINSTANCEID, "ProcessInstanceId");
        builder.setColumn(COLUMN_PROCESSSESSIONID, "ProcessSesionId");
        builder.setColumn(COLUMN_STATUS, this.constants.Status());
        builder.setColumn(COLUMN_TASKID, this.constants.Id());
        builder.setColumn(COLUMN_WORKITEMID, "WorkItemId");
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault(COLUMN_CREATEDON, SortOrder.DESCENDING);
        builder.tableWidth(1000);
        return builder.buildSettings();
    }

    @Override
    public int getRefreshValue() {
        return this.getMultiGridPreferencesStore().getRefreshInterval();
    }

    @Override
    public void saveRefreshValue(int newValue) {
        this.filterPagedTable.saveNewRefreshInterval(newValue);
    }

    @Override
    public void restoreTabs() {
        ArrayList existingGrids = this.getMultiGridPreferencesStore().getGridsId();
        ArrayList allTabs = new ArrayList(existingGrids.size());
        if (existingGrids != null && existingGrids.size() > 0) {
            int i;
            for (i = 0; i < existingGrids.size(); ++i) {
                allTabs.add(existingGrids.get(i));
            }
            for (i = 0; i < allTabs.size(); ++i) {
                this.filterPagedTable.removeTab((String)allTabs.get(i));
            }
        }
        this.filterPagedTable.tabPanel.remove(0);
        this.initDefaultFilters(this.currentGlobalPreferences, this.createTabButton);
    }

    protected class ReleaseActionHasCell
    implements HasCell<TaskSummary, TaskSummary> {
        private ActionCell<TaskSummary> cell;

        public ReleaseActionHasCell(String text, ActionCell.Delegate<TaskSummary> delegate) {
            this.cell = new ActionCell<TaskSummary>(text, delegate){

                public void render(Cell.Context context, TaskSummary value, SafeHtmlBuilder sb) {
                    if (value.getActualOwner() != null && value.getActualOwner().equals(DataSetTasksListGridViewImpl.this.identity.getIdentifier()) && (value.getStatus().equals("Reserved") || value.getStatus().equals("InProgress"))) {
                        SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                        mysb.appendHtmlConstant("<a href='javascript:;' class='btn btn-mini' style='margin-right:5px;' title='" + DataSetTasksListGridViewImpl.this.constants.Release() + "'>" + DataSetTasksListGridViewImpl.this.constants.Release() + "</a>");
                        sb.append(mysb.toSafeHtml());
                    }
                }
            };
        }

        public Cell<TaskSummary> getCell() {
            return this.cell;
        }

        public FieldUpdater<TaskSummary, TaskSummary> getFieldUpdater() {
            return null;
        }

        public TaskSummary getValue(TaskSummary object) {
            return object;
        }
    }

    protected class ClaimActionHasCell
    implements HasCell<TaskSummary, TaskSummary> {
        private ActionCell<TaskSummary> cell;

        public ClaimActionHasCell(String text, ActionCell.Delegate<TaskSummary> delegate) {
            this.cell = new ActionCell<TaskSummary>(text, delegate){

                public void render(Cell.Context context, TaskSummary value, SafeHtmlBuilder sb) {
                    if (value.getStatus().equals("Ready")) {
                        SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                        mysb.appendHtmlConstant("<a href='javascript:;' class='btn btn-mini' style='margin-right:5px;' title='" + DataSetTasksListGridViewImpl.this.constants.Claim() + "'>" + DataSetTasksListGridViewImpl.this.constants.Claim() + "</a>");
                        sb.append(mysb.toSafeHtml());
                    }
                }
            };
        }

        public Cell<TaskSummary> getCell() {
            return this.cell;
        }

        public FieldUpdater<TaskSummary, TaskSummary> getFieldUpdater() {
            return null;
        }

        public TaskSummary getValue(TaskSummary object) {
            return object;
        }
    }

    protected class CompleteActionHasCell
    implements HasCell<TaskSummary, TaskSummary> {
        private ActionCell<TaskSummary> cell;

        public CompleteActionHasCell(String text, ActionCell.Delegate<TaskSummary> delegate) {
            this.cell = new ActionCell<TaskSummary>(text, delegate){

                public void render(Cell.Context context, TaskSummary value, SafeHtmlBuilder sb) {
                    if (value.getActualOwner() != null && value.getStatus().equals("InProgress")) {
                        SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                        mysb.appendHtmlConstant("<a href='javascript:;' class='btn btn-mini' style='margin-right:5px;' title='" + DataSetTasksListGridViewImpl.this.constants.Complete() + "'>" + DataSetTasksListGridViewImpl.this.constants.Complete() + "</a>");
                        sb.append(mysb.toSafeHtml());
                    }
                }
            };
        }

        public Cell<TaskSummary> getCell() {
            return this.cell;
        }

        public FieldUpdater<TaskSummary, TaskSummary> getFieldUpdater() {
            return null;
        }

        public TaskSummary getValue(TaskSummary object) {
            return object;
        }
    }

    static interface Binder
    extends UiBinder<Widget, DataSetTasksListGridViewImpl> {
    }
}

