/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskdetails;

import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.service.DataServiceEntryPoint;
import org.jbpm.console.ng.ga.service.ItemKey;
import org.jbpm.console.ng.gc.client.util.UTCDateBox;
import org.jbpm.console.ng.gc.client.util.UTCTimeBox;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.TaskKey;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.model.events.TaskCalendarEvent;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.service.TaskOperationsService;
import org.jbpm.console.ng.ht.service.TaskQueryService;
import org.jbpm.console.ng.pr.model.events.ProcessInstancesWithDetailsRequestEvent;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

@Dependent
public class TaskDetailsPresenter {
    private Constants constants = Constants.INSTANCE;
    @Inject
    private PlaceManager placeManager;
    @Inject
    TaskDetailsView view;
    @Inject
    private Event<ProcessInstancesWithDetailsRequestEvent> processInstanceSelected;
    @Inject
    private Caller<TaskQueryService> taskQueryService;
    @Inject
    private Caller<TaskOperationsService> taskOperationsService;
    @Inject
    private Caller<DataServiceEntryPoint> dataServices;
    @Inject
    private Event<TaskRefreshedEvent> taskRefreshed;
    @Inject
    private Event<TaskCalendarEvent> taskCalendarEvent;
    private long currentTaskId = 0L;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getView() {
        return this.view;
    }

    public void updateTask(String taskDescription, String userId, Date dueDate, int priority) {
        if (this.currentTaskId > 0L) {
            ArrayList<String> descriptions = new ArrayList<String>();
            descriptions.add(taskDescription);
            ((TaskOperationsService)this.taskOperationsService.call((RemoteCallback)new RemoteCallback<Void>(){

                public void callback(Void nothing) {
                    TaskDetailsPresenter.this.view.displayNotification("Task Details Updated for Task id = " + TaskDetailsPresenter.this.currentTaskId + ")");
                    TaskDetailsPresenter.this.taskRefreshed.fire((Object)new TaskRefreshedEvent(TaskDetailsPresenter.this.currentTaskId));
                    TaskDetailsPresenter.this.taskCalendarEvent.fire((Object)new TaskCalendarEvent(Long.valueOf(TaskDetailsPresenter.this.currentTaskId)));
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    ErrorPopup.showMessage((String)TaskDetailsPresenter.this.constants.UnexpectedError(throwable.getMessage()));
                    return true;
                }
            })).updateTask(this.currentTaskId, priority, descriptions, dueDate);
        }
    }

    public void refreshTask() {
        ((TaskQueryService)this.taskQueryService.call((RemoteCallback)new RemoteCallback<TaskSummary>(){

            public void callback(TaskSummary details) {
                if (details == null) {
                    TaskDetailsPresenter.this.view.getTaskDescriptionTextArea().setEnabled(false);
                    TaskDetailsPresenter.this.view.getDueDate().setEnabled(false);
                    TaskDetailsPresenter.this.view.getUserText().setEnabled(false);
                    TaskDetailsPresenter.this.view.getTaskStatusText().setEnabled(false);
                    TaskDetailsPresenter.this.view.getDueDateTime().setEnabled(false);
                    TaskDetailsPresenter.this.view.getTaskPriorityListBox().setEnabled(false);
                    TaskDetailsPresenter.this.view.getUpdateTaskButton().setEnabled(false);
                    return;
                }
                if (details.getStatus().equals("Completed")) {
                    TaskDetailsPresenter.this.view.getTaskDescriptionTextArea().setEnabled(false);
                    TaskDetailsPresenter.this.view.getDueDate().setEnabled(false);
                    TaskDetailsPresenter.this.view.getUserText().setEnabled(false);
                    TaskDetailsPresenter.this.view.getTaskStatusText().setEnabled(false);
                    TaskDetailsPresenter.this.view.getDueDateTime().setEnabled(false);
                    TaskDetailsPresenter.this.view.getTaskPriorityListBox().setEnabled(false);
                    TaskDetailsPresenter.this.view.getUpdateTaskButton().setEnabled(false);
                }
                TaskDetailsPresenter.this.view.getTaskDescriptionTextArea().setText(details.getDescription());
                TaskDetailsPresenter.this.view.getDueDate().setValue(UTCDateBox.date2utc((Date)details.getExpirationTime()));
                TaskDetailsPresenter.this.view.getDueDateTime().setValue(UTCDateBox.date2utc((Date)details.getExpirationTime()));
                TaskDetailsPresenter.this.view.getUserText().setText(details.getActualOwner());
                TaskDetailsPresenter.this.view.getUserText().setEnabled(false);
                TaskDetailsPresenter.this.view.getTaskStatusText().setText(details.getStatus());
                TaskDetailsPresenter.this.view.getTaskStatusText().setEnabled(false);
                int i = 0;
                i = 0;
                for (String priority : TaskDetailsPresenter.this.view.getPriorities()) {
                    if (details.getPriority() == i) {
                        TaskDetailsPresenter.this.view.getTaskPriorityListBox().setValue(String.valueOf(i));
                    }
                    ++i;
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)TaskDetailsPresenter.this.constants.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).getItem((ItemKey)new TaskKey(Long.valueOf(this.currentTaskId)));
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.currentTaskId = event.getTaskId();
        this.refreshTask();
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.currentTaskId == event.getTaskId()) {
            this.refreshTask();
        }
    }

    public static interface TaskDetailsView
    extends IsWidget {
        public void init(TaskDetailsPresenter var1);

        public void displayNotification(String var1);

        public TextArea getTaskDescriptionTextArea();

        public Select getTaskPriorityListBox();

        public UTCDateBox getDueDate();

        public UTCTimeBox getDueDateTime();

        public TextBox getUserText();

        public String[] getPriorities();

        public TextBox getTaskStatusText();

        public Button getUpdateTaskButton();
    }
}

