/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.list.base.DataSetQueryHelper;
import org.jbpm.console.ng.gc.client.dataset.AbstractDataSetReadyCallback;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.jbpm.console.ng.gc.client.list.base.events.SearchEvent;
import org.jbpm.console.ng.gc.client.menu.RestoreDefaultFiltersMenuBuilder;
import org.jbpm.console.ng.ht.client.editors.quicknewtask.QuickNewTaskPopup;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.service.TaskLifeCycleService;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.ext.widgets.common.client.menu.RefreshSelectorMenuBuilder;
import org.uberfire.mvp.Command;
import org.uberfire.paging.PageResponse;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="DataSet Tasks List")
public class DataSetTasksListGridPresenter
extends AbstractScreenListPresenter<TaskSummary> {
    @Inject
    private DataSetTaskListView view;
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private Caller<TaskLifeCycleService> taskOperationsService;
    @Inject
    DataSetQueryHelper dataSetQueryHelper;
    @Inject
    private DataSetQueryHelper dataSetQueryHelperDomainSpecific;
    @Inject
    private QuickNewTaskPopup quickNewTaskPopup;
    @Inject
    private ErrorPopupPresenter errorPopup;
    private RefreshSelectorMenuBuilder refreshSelectorMenuBuilder = new RefreshSelectorMenuBuilder((RefreshSelectorMenuBuilder.SupportsRefreshInterval)this);

    public DataSetTasksListGridPresenter() {
        this.dataProvider = new AsyncDataProvider<TaskSummary>(){

            protected void onRangeChanged(HasData<TaskSummary> display) {
                DataSetTasksListGridPresenter.this.view.showBusyIndicator(DataSetTasksListGridPresenter.this.constants.Loading());
                Range visibleRange = DataSetTasksListGridPresenter.this.view.getListGrid().getVisibleRange();
                DataSetTasksListGridPresenter.this.getData(visibleRange);
            }
        };
    }

    public DataSetTasksListGridPresenter(DataSetTaskListView view, Caller<TaskLifeCycleService> taskOperationsService, DataSetQueryHelper dataSetQueryHelper, DataSetQueryHelper dataSetQueryHelperDomainSpecific) {
        this.view = view;
        this.taskOperationsService = taskOperationsService;
        this.dataSetQueryHelper = dataSetQueryHelper;
        this.dataSetQueryHelperDomainSpecific = dataSetQueryHelperDomainSpecific;
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(Range visibleRange) {
        try {
            FilterSettings currentTableSettings;
            if (!this.isAddingDefaultFilters() && (currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings()) != null) {
                currentTableSettings.setTablePageSize(this.view.getListGrid().getPageSize());
                ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
                if (columnSortList != null && columnSortList.size() > 0) {
                    this.dataSetQueryHelper.setLastOrderedColumn(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
                    this.dataSetQueryHelper.setLastSortOrder(columnSortList.size() > 0 && columnSortList.get(0).isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
                } else {
                    this.dataSetQueryHelper.setLastOrderedColumn("createdOn");
                    this.dataSetQueryHelper.setLastSortOrder(SortOrder.ASCENDING);
                }
                if (this.textSearchStr != null && this.textSearchStr.trim().length() > 0) {
                    DataSetFilter filter = new DataSetFilter();
                    ArrayList<ColumnFilter> filters = new ArrayList<ColumnFilter>();
                    filters.add(FilterFactory.likeTo((String)"name", (String)("%" + this.textSearchStr.toLowerCase() + "%"), (boolean)false));
                    filters.add(FilterFactory.likeTo((String)"description", (String)("%" + this.textSearchStr.toLowerCase() + "%"), (boolean)false));
                    filters.add(FilterFactory.likeTo((String)"processId", (String)("%" + this.textSearchStr.toLowerCase() + "%"), (boolean)false));
                    filter.addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                    if (currentTableSettings.getDataSetLookup().getFirstFilterOp() != null) {
                        currentTableSettings.getDataSetLookup().getFirstFilterOp().addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                    } else {
                        currentTableSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
                    }
                    this.textSearchStr = "";
                }
                this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
                this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(visibleRange.getStart()), this.createDataSetTaskCallback(visibleRange.getStart(), currentTableSettings));
            }
        }
        catch (Exception e) {
            this.errorPopup.showMessage(Constants.INSTANCE.UnexpectedError(e.getMessage()));
        }
    }

    protected DataSetReadyCallback createDataSetTaskCallback(final int startRange, final FilterSettings tableSettings) {
        return new AbstractDataSetReadyCallback(this.errorPopup, (AbstractListView.BasicListView)this.view, tableSettings.getDataSet()){

            public void callback(DataSet dataSet) {
                if (dataSet != null) {
                    ArrayList<TaskSummary> myTasksFromDataSet = new ArrayList<TaskSummary>();
                    for (int i = 0; i < dataSet.getRowCount(); ++i) {
                        myTasksFromDataSet.add(DataSetTasksListGridPresenter.this.createTaskSummaryFromDataSet(dataSet, i));
                    }
                    List ops = tableSettings.getDataSetLookup().getOperationList();
                    String filterValue = DataSetTasksListGridPresenter.this.isFilteredByTaskName(ops);
                    if (filterValue != null) {
                        DataSetTasksListGridPresenter.this.getDomainSpecifDataForTasks(startRange, dataSet.getRowCountNonTrimmed(), filterValue, myTasksFromDataSet);
                    } else {
                        PageResponse taskSummaryPageResponse = new PageResponse();
                        taskSummaryPageResponse.setPageRowList(myTasksFromDataSet);
                        taskSummaryPageResponse.setStartRowIndex(startRange);
                        taskSummaryPageResponse.setTotalRowSize(dataSet.getRowCountNonTrimmed());
                        taskSummaryPageResponse.setTotalRowSizeExact(true);
                        if (startRange + dataSet.getRowCount() == dataSet.getRowCountNonTrimmed()) {
                            taskSummaryPageResponse.setLastPage(true);
                        } else {
                            taskSummaryPageResponse.setLastPage(false);
                        }
                        DataSetTasksListGridPresenter.this.updateDataOnCallback(taskSummaryPageResponse);
                    }
                }
                DataSetTasksListGridPresenter.this.view.hideBusyIndicator();
            }
        };
    }

    protected String isFilteredByTaskName(List<DataSetOp> ops) {
        for (DataSetOp dataSetOp : ops) {
            if (!dataSetOp.getType().equals((Object)DataSetOpType.FILTER)) continue;
            List filters = ((DataSetFilter)dataSetOp).getColumnFilterList();
            for (ColumnFilter filter : filters) {
                List parameters;
                if (!(filter instanceof CoreFunctionFilter)) continue;
                CoreFunctionFilter coreFilter = (CoreFunctionFilter)filter;
                if (!filter.getColumnId().toUpperCase().equals("name".toUpperCase()) || ((CoreFunctionFilter)filter).getType() != CoreFunctionType.EQUALS_TO || (parameters = coreFilter.getParameters()).size() <= 0) continue;
                return parameters.get(0).toString();
            }
        }
        return null;
    }

    public void getDomainSpecifDataForTasks(int startRange, int rowCountNotTrimmed, String filterValue, List<TaskSummary> myTasksFromDataSet) {
        FilterSettings variablesTableSettings = this.view.getVariablesTableSettings(filterValue);
        variablesTableSettings.setTablePageSize(-1);
        this.dataSetQueryHelperDomainSpecific.setDataSetHandler(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setCurrentTableSettings(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setLastOrderedColumn("taskId");
        this.dataSetQueryHelperDomainSpecific.setLastSortOrder(SortOrder.ASCENDING);
        ArrayList<Long> tasksIds = new ArrayList<Long>();
        for (TaskSummary task : myTasksFromDataSet) {
            tasksIds.add(task.getTaskId());
        }
        DataSetFilter filter = new DataSetFilter();
        ColumnFilter filter1 = FilterFactory.equalsTo((String)"taskId", tasksIds);
        filter.addFilterColumn(new ColumnFilter[]{filter1});
        variablesTableSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
        this.dataSetQueryHelperDomainSpecific.lookupDataSet(Integer.valueOf(0), this.createDataSetDomainSpecificCallback(startRange, rowCountNotTrimmed, myTasksFromDataSet, variablesTableSettings.getDataSet()));
    }

    protected DataSetReadyCallback createDataSetDomainSpecificCallback(final int startRange, final int totalRowSize, final List<TaskSummary> instances, DataSet dataset) {
        return new AbstractDataSetReadyCallback(this.errorPopup, (AbstractListView.BasicListView)this.view, dataset){

            public void callback(DataSet dataSet) {
                if (dataSet.getRowCount() > 0) {
                    HashSet<String> columns = new HashSet<String>();
                    for (int i = 0; i < dataSet.getRowCount(); ++i) {
                        Long taskId = DataSetTasksListGridPresenter.this.dataSetQueryHelperDomainSpecific.getColumnLongValue(dataSet, "taskId", i);
                        String variableName = DataSetTasksListGridPresenter.this.dataSetQueryHelperDomainSpecific.getColumnStringValue(dataSet, "varname", i);
                        String variableValue = DataSetTasksListGridPresenter.this.dataSetQueryHelperDomainSpecific.getColumnStringValue(dataSet, "varvalue", i);
                        for (TaskSummary task : instances) {
                            if (!task.getTaskId().equals(taskId)) continue;
                            task.addDomainData(variableName, variableValue);
                            columns.add(variableName);
                        }
                    }
                    DataSetTasksListGridPresenter.this.view.addDomainSpecifColumns((ExtendedPagedTable<TaskSummary>)DataSetTasksListGridPresenter.this.view.getListGrid(), columns);
                }
                PageResponse taskSummaryPageResponse = new PageResponse();
                taskSummaryPageResponse.setPageRowList(instances);
                taskSummaryPageResponse.setStartRowIndex(startRange);
                taskSummaryPageResponse.setTotalRowSize(totalRowSize);
                taskSummaryPageResponse.setTotalRowSizeExact(true);
                if (startRange + instances.size() == totalRowSize) {
                    taskSummaryPageResponse.setLastPage(true);
                } else {
                    taskSummaryPageResponse.setLastPage(false);
                }
                DataSetTasksListGridPresenter.this.updateDataOnCallback(taskSummaryPageResponse);
            }
        };
    }

    protected TaskSummary createTaskSummaryFromDataSet(DataSet dataSet, int i) {
        return new TaskSummary(this.dataSetQueryHelper.getColumnLongValue(dataSet, "taskId", i).longValue(), this.dataSetQueryHelper.getColumnStringValue(dataSet, "name", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "description", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "status", i), this.dataSetQueryHelper.getColumnIntValue(dataSet, "priority", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "actualOwner", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "createdBy", i), this.dataSetQueryHelper.getColumnDateValue(dataSet, "createdOn", i), this.dataSetQueryHelper.getColumnDateValue(dataSet, "activationTime", i), this.dataSetQueryHelper.getColumnDateValue(dataSet, "dueDate", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processId", i), this.dataSetQueryHelper.getColumnLongValue(dataSet, "processSessionId", i).longValue(), this.dataSetQueryHelper.getColumnLongValue(dataSet, "processInstanceId", i).longValue(), this.dataSetQueryHelper.getColumnStringValue(dataSet, "deploymentId", i), this.dataSetQueryHelper.getColumnLongValue(dataSet, "parentId", i).longValue(), "jbpmHumanTasksWithAdmin".equals(dataSet.getUUID()));
    }

    public void filterGrid(FilterSettings tableSettings) {
        this.dataSetQueryHelper.setCurrentTableSettings(tableSettings);
        this.refreshGrid();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Tasks_List();
    }

    @WorkbenchPartView
    public UberView<DataSetTasksListGridPresenter> getView() {
        return this.view;
    }

    public void releaseTask(final Long taskId, String userId) {
        ((TaskLifeCycleService)this.taskOperationsService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                DataSetTasksListGridPresenter.this.view.displayNotification(Constants.INSTANCE.TaskReleased(String.valueOf(taskId)));
                DataSetTasksListGridPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                DataSetTasksListGridPresenter.this.errorPopup.showMessage(Constants.INSTANCE.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).release(taskId.longValue(), userId);
    }

    public void claimTask(final Long taskId, String userId, String deploymentId) {
        ((TaskLifeCycleService)this.taskOperationsService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                DataSetTasksListGridPresenter.this.view.displayNotification(Constants.INSTANCE.TaskClaimed(String.valueOf(taskId)));
                DataSetTasksListGridPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                DataSetTasksListGridPresenter.this.errorPopup.showMessage(Constants.INSTANCE.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).claim(taskId.longValue(), userId, deploymentId);
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.New_Task()).respondsWith(new Command(){

            public void execute() {
                DataSetTasksListGridPresenter.this.quickNewTaskPopup.show();
            }
        })).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.refreshSelectorMenuBuilder).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RestoreDefaultFiltersMenuBuilder((RestoreDefaultFiltersMenuBuilder.SupportsRestoreDefaultFilters)this)).endMenu()).build();
    }

    public void onGridPreferencesStoreLoaded() {
        this.refreshSelectorMenuBuilder.loadOptions(this.view.getRefreshValue());
    }

    public void onUpdateRefreshInterval(boolean enableAutoRefresh, int newInterval) {
        super.onUpdateRefreshInterval(enableAutoRefresh, newInterval);
        this.view.saveRefreshValue(newInterval);
    }

    protected void onSearchEvent(@Observes SearchEvent searchEvent) {
        this.textSearchStr = searchEvent.getFilter();
        if (this.textSearchStr != null && this.textSearchStr.trim().length() > 0) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("textSearch", this.textSearchStr);
            this.dataSetQueryHelper.getCurrentTableSettings().getKey();
            this.view.applyFilterOnPresenter(this.dataSetQueryHelper.getCurrentTableSettings().getKey());
        }
    }

    public static interface DataSetTaskListView
    extends AbstractListView.ListView<TaskSummary, DataSetTasksListGridPresenter> {
        public int getRefreshValue();

        public void saveRefreshValue(int var1);

        public void applyFilterOnPresenter(String var1);

        public void addDomainSpecifColumns(ExtendedPagedTable<TaskSummary> var1, Set<String> var2);

        public FilterSettings getVariablesTableSettings(String var1);
    }
}

