/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskcomments;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Date;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.ht.client.editors.taskcomments.TaskCommentsPresenter;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.service.TaskCommentsService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskCommentsPresenterTest {
    private static final Long TASK_ID = 1L;
    private static final Long COMMENT_ID = 1L;
    private static final String USR_ID = "Jan";
    private CallerMock<TaskCommentsService> callerMock;
    @Mock
    private TaskCommentsService commentsServiceMock;
    @Mock
    private TaskCommentsPresenter.TaskCommentsView viewMock;
    @Mock
    private User userMock;
    private TaskCommentsPresenter presenter;

    @Before
    public void setupMocks() {
        Mockito.when((Object)this.userMock.getIdentifier()).thenReturn((Object)USR_ID);
        this.callerMock = new CallerMock((Object)this.commentsServiceMock);
        this.presenter = new TaskCommentsPresenter(this.viewMock, this.callerMock, this.userMock);
    }

    @Test
    public void commentsUpdatedWhenTaskSelectedOrRefreshed() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(TASK_ID));
        ((TaskCommentsService)Mockito.verify((Object)this.commentsServiceMock)).getAllCommentsByTaskId(TASK_ID.longValue());
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.viewMock)).redrawDataGrid();
        this.presenter.onTaskRefreshedEvent(new TaskRefreshedEvent(TASK_ID.longValue()));
        ((TaskCommentsService)Mockito.verify((Object)this.commentsServiceMock, (VerificationMode)Mockito.times((int)2))).getAllCommentsByTaskId(TASK_ID.longValue());
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).redrawDataGrid();
    }

    @Test
    public void emptyCommentNotAccepted() {
        this.presenter.addTaskComment("");
        ((TaskCommentsService)Mockito.verify((Object)this.commentsServiceMock, (VerificationMode)Mockito.never())).addComment(Matchers.anyLong(), Matchers.anyString(), Matchers.anyString(), (Date)Matchers.any(Date.class));
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.viewMock)).displayNotification("CommentCannotBeEmpty");
    }

    @Test
    public void commentInputClearedAfterCommetAdded() {
        String comment = "Working on it, man.";
        this.presenter.addTaskComment(comment);
        ((TaskCommentsService)Mockito.verify((Object)this.commentsServiceMock)).addComment(Matchers.anyLong(), (String)Matchers.eq((Object)comment), (String)Matchers.eq((Object)USR_ID), (Date)Matchers.any(Date.class));
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.viewMock)).clearCommentInput();
    }

    @Test
    public void removeCommentAdded() {
        this.presenter.removeTaskComment(COMMENT_ID.longValue());
        ((TaskCommentsService)Mockito.verify((Object)this.commentsServiceMock)).deleteComment(Matchers.anyLong(), ((Long)Matchers.eq((Object)COMMENT_ID)).longValue());
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.viewMock)).clearCommentInput();
        ((TaskCommentsService)Mockito.verify((Object)this.commentsServiceMock)).getAllCommentsByTaskId(Matchers.anyLong());
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.viewMock)).redrawDataGrid();
    }
}

