/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskdetails;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.gc.client.util.UTCDateBox;
import org.jbpm.console.ng.gc.client.util.UTCTimeBox;
import org.jbpm.console.ng.ht.client.editors.taskdetails.TaskDetailsPresenter;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated(value="TaskDetailsViewImpl.html")
public class TaskDetailsViewImpl
extends Composite
implements TaskDetailsPresenter.TaskDetailsView {
    private TaskDetailsPresenter presenter;
    @Inject
    @DataField
    public TextBox userText;
    @Inject
    @DataField
    public TextBox taskStatusText;
    @Inject
    @DataField
    public TextArea taskDescriptionTextArea;
    @Inject
    @DataField
    public Select taskPriorityListBox;
    @Inject
    @DataField
    public UTCDateBox dueDate;
    @Inject
    @DataField
    public UTCTimeBox dueDateTime;
    @Inject
    @DataField
    public Button updateTaskButton;
    @Inject
    @DataField
    public FormLabel taskStatusLabel;
    @Inject
    @DataField
    public FormLabel userLabel;
    @Inject
    @DataField
    public FormLabel dueDateLabel;
    @Inject
    @DataField
    public FormLabel taskPriorityLabel;
    @Inject
    @DataField
    public FormLabel taskDescriptionLabel;
    @Inject
    private PlaceManager placeManager;
    private String[] priorities = new String[]{"0 - " + constants.High(), "1", "2", "3", "4", "5 - " + constants.Medium(), "6", "7", "8", "9", "10 - " + constants.Low()};
    private static Constants constants = Constants.INSTANCE;
    @Inject
    private Event<NotificationEvent> notification;

    @Override
    public void init(TaskDetailsPresenter presenter) {
        this.presenter = presenter;
        for (int i = 0; i < this.priorities.length; ++i) {
            Option option = new Option();
            option.setText(this.priorities[i]);
            option.setValue(String.valueOf(i));
            this.taskPriorityListBox.add((Widget)option);
        }
        this.refreshPriorities();
        this.taskStatusLabel.setText(constants.Status());
        this.userLabel.setText(constants.User());
        this.dueDateLabel.setText(constants.Due_On());
        this.taskPriorityLabel.setText(constants.Priority());
        this.taskDescriptionLabel.setText(constants.Description());
        this.updateTaskButton.setText(constants.Update());
        this.dueDate.getDateBox().setContainer((Widget)this);
    }

    @EventHandler(value={"updateTaskButton"})
    public void updateTaskButton(ClickEvent e) {
        this.presenter.updateTask(this.taskDescriptionTextArea.getText(), this.userText.getText(), this.dueDate.getValue() != null && this.dueDateTime.getValue() != null ? UTCDateBox.utc2date((Long)(this.dueDate.getValue() + this.dueDateTime.getValue())) : null, Integer.valueOf(this.taskPriorityListBox.getValue()));
    }

    @Override
    public void setTaskDescription(String text) {
        this.taskDescriptionTextArea.setText(text);
    }

    @Override
    public void setDueDate(Long date) {
        this.dueDate.setValue(date);
    }

    @Override
    public void setDueDateTime(Long time) {
        this.dueDateTime.setValue(time);
    }

    @Override
    public void setUser(String user) {
        this.userText.setText(user);
    }

    @Override
    public void setUserEnabled(Boolean enabled) {
        this.userText.setEnabled(enabled.booleanValue());
    }

    @Override
    public void setTaskStatus(String status) {
        this.taskStatusText.setText(status);
    }

    @Override
    public void setTaskStatusEnabled(Boolean enabled) {
        this.taskStatusText.setEnabled(enabled.booleanValue());
    }

    @Override
    public void setTaskPriority(String priority) {
        this.taskPriorityListBox.setValue(priority);
    }

    @Override
    public void setTaskDescriptionEnabled(Boolean enabled) {
        this.taskDescriptionTextArea.setEnabled(enabled.booleanValue());
    }

    @Override
    public void setDueDateEnabled(Boolean enabled) {
        this.dueDate.setEnabled(enabled.booleanValue());
    }

    @Override
    public void setDueDateTimeEnabled(Boolean enabled) {
        this.dueDateTime.setEnabled(enabled.booleanValue());
    }

    @Override
    public void setTaskPriorityEnabled(Boolean enabled) {
        this.taskPriorityListBox.setEnabled(enabled.booleanValue());
        this.refreshPriorities();
    }

    @Override
    public void setUpdateTaskVisible(Boolean enabled) {
        this.updateTaskButton.setVisible(enabled.booleanValue());
    }

    private void refreshPriorities() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                TaskDetailsViewImpl.this.taskPriorityListBox.refresh();
            }
        });
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }
}

