/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.NumberCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.filter.FilterSettingsBuilderHelper;
import org.jbpm.console.ng.df.client.list.base.DataSetEditorManager;
import org.jbpm.console.ng.ga.model.GenericSummary;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractMultiGridView;
import org.jbpm.console.ng.gc.client.util.ButtonActionCell;
import org.jbpm.console.ng.gc.client.util.DateUtils;
import org.jbpm.console.ng.gc.client.util.TaskUtils;
import org.jbpm.console.ng.ht.client.editors.quicknewtask.QuickNewTaskPopup;
import org.jbpm.console.ng.ht.client.editors.taskslist.grid.AbstractTasksListGridPresenter;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.model.events.NewTaskEvent;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.ColumnMeta;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.common.client.tables.popup.NewTabFilterPopup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
public class DataSetTasksListGridViewImpl
extends AbstractMultiGridView<TaskSummary, AbstractTasksListGridPresenter>
implements AbstractTasksListGridPresenter.DataSetTaskListView {
    public static String DATASET_TASK_LIST_PREFIX = "DataSetTaskListGrid";
    private final Constants constants = Constants.INSTANCE;
    public static final String COL_ID_ACTIONS = "actions";
    @Inject
    private Event<TaskSelectionEvent> taskSelected;
    @Inject
    private QuickNewTaskPopup quickNewTaskPopup;
    @Inject
    private NewTabFilterPopup newTabFilterPopup;
    @Inject
    private DataSetEditorManager dataSetEditorManager;

    public void init(final AbstractTasksListGridPresenter presenter) {
        final ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add("name");
        bannedColumns.add(COL_ID_ACTIONS);
        final ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add("name");
        initColumns.add("description");
        initColumns.add(COL_ID_ACTIONS);
        final Button button = (Button)GWT.create(Button.class);
        button.setIcon(IconType.PLUS);
        button.setSize(ButtonSize.SMALL);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final String key = DataSetTasksListGridViewImpl.this.getValidKeyForAdditionalListGrid(DATASET_TASK_LIST_PREFIX + "_");
                Command addNewGrid = new Command(){

                    public void execute() {
                        final ExtendedPagedTable extendedPagedTable = DataSetTasksListGridViewImpl.this.createGridInstance(new GridGlobalPreferences(key, initColumns, bannedColumns), key);
                        extendedPagedTable.setDataProvider((AbstractDataProvider)presenter.getDataProvider());
                        DataSetTasksListGridViewImpl.this.filterPagedTable.createNewTab((PagedTable)extendedPagedTable, key, button, new Command(){

                            public void execute() {
                                DataSetTasksListGridViewImpl.this.currentListGrid = extendedPagedTable;
                                DataSetTasksListGridViewImpl.this.applyFilterOnPresenter(key);
                            }
                        });
                        DataSetTasksListGridViewImpl.this.applyFilterOnPresenter(key);
                    }
                };
                FilterSettings tableSettings = DataSetTasksListGridViewImpl.this.createTableSettingsPrototype();
                tableSettings.setKey(key);
                DataSetTasksListGridViewImpl.this.dataSetEditorManager.showTableSettingsEditor(DataSetTasksListGridViewImpl.this.filterPagedTable, Constants.INSTANCE.New_FilteredList(), tableSettings, addNewGrid);
            }
        });
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences(DATASET_TASK_LIST_PREFIX, initColumns, bannedColumns), button);
    }

    public void initSelectionModel() {
        final ExtendedPagedTable extendedPagedTable = this.getListGrid();
        this.selectedStyles = new RowStyles<TaskSummary>(){

            public String getStyleNames(TaskSummary row, int rowIndex) {
                if (rowIndex == DataSetTasksListGridViewImpl.this.selectedRow) {
                    return "selected";
                }
                if (row.getStatus().equals("InProgress") || row.getStatus().equals("Ready")) {
                    if (row.getPriority() == 5) {
                        return "five";
                    }
                    if (row.getPriority() == 4) {
                        return "four";
                    }
                    if (row.getPriority() == 3) {
                        return "three";
                    }
                    if (row.getPriority() == 2) {
                        return "two";
                    }
                    if (row.getPriority() == 1) {
                        return "one";
                    }
                } else if (row.getStatus().equals("Completed")) {
                    return "completed";
                }
                return null;
            }
        };
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Tasks_Found());
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                boolean close = false;
                if (DataSetTasksListGridViewImpl.this.selectedRow == -1) {
                    DataSetTasksListGridViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.setRowStyles(DataSetTasksListGridViewImpl.this.selectedStyles);
                    extendedPagedTable.redraw();
                } else if (extendedPagedTable.getKeyboardSelectedRow() != DataSetTasksListGridViewImpl.this.selectedRow) {
                    extendedPagedTable.setRowStyles(DataSetTasksListGridViewImpl.this.selectedStyles);
                    DataSetTasksListGridViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                } else {
                    close = true;
                }
                DataSetTasksListGridViewImpl.this.selectedItem = (GenericSummary)DataSetTasksListGridViewImpl.this.selectionModel.getLastSelectedObject();
                DefaultPlaceRequest defaultPlaceRequest = new DefaultPlaceRequest("Task Details Multi");
                PlaceStatus status = DataSetTasksListGridViewImpl.this.placeManager.getStatus((PlaceRequest)defaultPlaceRequest);
                boolean logOnly = false;
                if (((TaskSummary)DataSetTasksListGridViewImpl.this.selectedItem).getStatus().equals("Completed") && ((TaskSummary)DataSetTasksListGridViewImpl.this.selectedItem).isLogOnly()) {
                    logOnly = true;
                }
                if (status == PlaceStatus.CLOSE) {
                    DataSetTasksListGridViewImpl.this.placeManager.goTo((PlaceRequest)defaultPlaceRequest);
                    DataSetTasksListGridViewImpl.this.taskSelected.fire((Object)new TaskSelectionEvent(((TaskSummary)DataSetTasksListGridViewImpl.this.selectedItem).getTaskId(), ((TaskSummary)DataSetTasksListGridViewImpl.this.selectedItem).getTaskName(), ((TaskSummary)DataSetTasksListGridViewImpl.this.selectedItem).isForAdmin(), logOnly));
                } else if (status == PlaceStatus.OPEN && !close) {
                    DataSetTasksListGridViewImpl.this.taskSelected.fire((Object)new TaskSelectionEvent(((TaskSummary)DataSetTasksListGridViewImpl.this.selectedItem).getTaskId(), ((TaskSummary)DataSetTasksListGridViewImpl.this.selectedItem).getTaskName(), ((TaskSummary)DataSetTasksListGridViewImpl.this.selectedItem).isForAdmin(), logOnly));
                } else if (status == PlaceStatus.OPEN && close) {
                    DataSetTasksListGridViewImpl.this.placeManager.closePlace("Task Details Multi");
                }
            }
        });
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<TaskSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<TaskSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<TaskSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType()) && extendedPagedTable.getColumnIndex(DataSetTasksListGridViewImpl.this.actionsColumn) == event.getColumn()) {
                    return DefaultSelectionEventManager.SelectAction.IGNORE;
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
        extendedPagedTable.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        extendedPagedTable.setRowStyles(this.selectedStyles);
    }

    public void initColumns(ExtendedPagedTable extendedPagedTable) {
        this.initCellPreview(extendedPagedTable);
        Column taskIdColumn = this.initTaskIdColumn();
        Column taskNameColumn = this.initTaskNameColumn();
        Column descriptionColumn = this.initTaskDescriptionColumn();
        Column processIdColumn = this.initProcessIdColumn();
        Column processInstanceIdColumn = this.initProcessInstanceIdColumn();
        Column taskPriorityColumn = this.initTaskPriorityColumn();
        Column statusColumn = this.initTaskStatusColumn();
        Column createdOnDateColumn = this.initTaskCreatedOnColumn();
        Column dueDateColumn = this.initTaskDueColumn();
        this.actionsColumn = this.initActionsColumn(extendedPagedTable);
        ArrayList<ColumnMeta<TaskSummary>> columnMetas = new ArrayList<ColumnMeta<TaskSummary>>();
        columnMetas.add(new ColumnMeta(taskIdColumn, this.constants.Id()));
        columnMetas.add(new ColumnMeta(taskNameColumn, this.constants.Task()));
        columnMetas.add(new ColumnMeta(descriptionColumn, this.constants.Description()));
        columnMetas.add(new ColumnMeta(processIdColumn, this.constants.Process_Name()));
        columnMetas.add(new ColumnMeta(processInstanceIdColumn, this.constants.Process_Id()));
        columnMetas.add(new ColumnMeta(taskPriorityColumn, this.constants.Priority()));
        columnMetas.add(new ColumnMeta(statusColumn, this.constants.Status()));
        columnMetas.add(new ColumnMeta(createdOnDateColumn, this.constants.Created_On()));
        columnMetas.add(new ColumnMeta(dueDateColumn, this.constants.Due_On()));
        columnMetas.add(new ColumnMeta(this.actionsColumn, this.constants.Actions()));
        List columPreferenceList = extendedPagedTable.getGridPreferencesStore().getColumnPreferences();
        for (GridColumnPreference colPref : columPreferenceList) {
            if (this.isColumnAdded(columnMetas, colPref.getName())) continue;
            Column genericColumn = this.initGenericColumn(colPref.getName());
            genericColumn.setSortable(false);
            columnMetas.add((ColumnMeta<TaskSummary>)new ColumnMeta(genericColumn, colPref.getName(), true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
    }

    private void initCellPreview(final ExtendedPagedTable extendedPagedTable) {
        extendedPagedTable.addCellPreviewHandler((CellPreviewEvent.Handler)new CellPreviewEvent.Handler<TaskSummary>(){

            public void onCellPreview(CellPreviewEvent<TaskSummary> event) {
                if ("mouseover".equalsIgnoreCase(event.getNativeEvent().getType())) {
                    DataSetTasksListGridViewImpl.this.onMouseOverGrid(extendedPagedTable, (CellPreviewEvent<TaskSummary>)event);
                }
            }
        });
    }

    private void onMouseOverGrid(ExtendedPagedTable extendedPagedTable, CellPreviewEvent<TaskSummary> event) {
        TaskSummary task = (TaskSummary)event.getValue();
        if (task.getDescription() != null) {
            extendedPagedTable.setTooltip(extendedPagedTable.getKeyboardSelectedRow(), event.getColumn(), task.getDescription());
        }
    }

    private Column initTaskIdColumn() {
        Column<TaskSummary, Number> taskIdColumn = new Column<TaskSummary, Number>((Cell)new NumberCell()){

            public Number getValue(TaskSummary object) {
                return object.getTaskId();
            }
        };
        taskIdColumn.setSortable(true);
        taskIdColumn.setDataStoreName("taskId");
        return taskIdColumn;
    }

    private Column initTaskNameColumn() {
        Column<TaskSummary, String> taskNameColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return object.getTaskName();
            }
        };
        taskNameColumn.setSortable(true);
        taskNameColumn.setDataStoreName("name");
        return taskNameColumn;
    }

    private Column initTaskDescriptionColumn() {
        Column<TaskSummary, String> descriptionColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return object.getDescription();
            }
        };
        descriptionColumn.setSortable(true);
        descriptionColumn.setDataStoreName("description");
        return descriptionColumn;
    }

    private Column initTaskPriorityColumn() {
        Column<TaskSummary, Number> taskPriorityColumn = new Column<TaskSummary, Number>((Cell)new NumberCell()){

            public Number getValue(TaskSummary object) {
                return object.getPriority();
            }
        };
        taskPriorityColumn.setSortable(true);
        taskPriorityColumn.setDataStoreName("priority");
        return taskPriorityColumn;
    }

    private Column initTaskStatusColumn() {
        Column<TaskSummary, String> statusColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return object.getStatus();
            }
        };
        statusColumn.setSortable(true);
        statusColumn.setDataStoreName("status");
        return statusColumn;
    }

    private Column initTaskCreatedOnColumn() {
        Column<TaskSummary, String> createdOnDateColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return DateUtils.getDateTimeStr((Date)object.getCreatedOn());
            }
        };
        createdOnDateColumn.setSortable(true);
        createdOnDateColumn.setDataStoreName("createdOn");
        return createdOnDateColumn;
    }

    private Column initTaskDueColumn() {
        Column<TaskSummary, String> dueDateColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return DateUtils.getDateTimeStr((Date)object.getExpirationTime());
            }
        };
        dueDateColumn.setSortable(true);
        dueDateColumn.setDataStoreName("dueDate");
        return dueDateColumn;
    }

    private Column initProcessIdColumn() {
        Column<TaskSummary, String> taskProcessIdColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return object.getProcessId();
            }
        };
        taskProcessIdColumn.setSortable(true);
        taskProcessIdColumn.setDataStoreName("processId");
        return taskProcessIdColumn;
    }

    private Column initProcessInstanceIdColumn() {
        Column<TaskSummary, Number> taskProcessInstanceIdColumn = new Column<TaskSummary, Number>((Cell)new NumberCell()){

            public Number getValue(TaskSummary object) {
                return object.getProcessInstanceId();
            }
        };
        taskProcessInstanceIdColumn.setSortable(true);
        taskProcessInstanceIdColumn.setDataStoreName("processInstanceId");
        return taskProcessInstanceIdColumn;
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        ((AbstractTasksListGridPresenter)this.presenter).refreshGrid();
    }

    private Column initActionsColumn(final ExtendedPagedTable extendedPagedTable) {
        LinkedList<ButtonActionCell> cells = new LinkedList<ButtonActionCell>();
        cells.add(new ClaimActionHasCell(this.constants.Claim(), new ActionCell.Delegate<TaskSummary>(){

            public void execute(TaskSummary task) {
                ((AbstractTasksListGridPresenter)DataSetTasksListGridViewImpl.this.presenter).claimTask(task.getTaskId(), DataSetTasksListGridViewImpl.this.identity.getIdentifier(), task.getDeploymentId());
                DataSetTasksListGridViewImpl.this.taskSelected.fire((Object)new TaskSelectionEvent(task.getTaskId(), task.getTaskName()));
                extendedPagedTable.refresh();
            }
        }));
        cells.add(new ReleaseActionHasCell(this.constants.Release(), new ActionCell.Delegate<TaskSummary>(){

            public void execute(TaskSummary task) {
                ((AbstractTasksListGridPresenter)DataSetTasksListGridViewImpl.this.presenter).releaseTask(task.getTaskId(), DataSetTasksListGridViewImpl.this.identity.getIdentifier());
                DataSetTasksListGridViewImpl.this.taskSelected.fire((Object)new TaskSelectionEvent(task.getTaskId(), task.getTaskName()));
                extendedPagedTable.refresh();
            }
        }));
        cells.add(new CompleteActionHasCell(this.constants.Open(), new ActionCell.Delegate<TaskSummary>(){

            public void execute(TaskSummary task) {
                DataSetTasksListGridViewImpl.this.placeManager.goTo("Task Details Multi");
                boolean logOnly = false;
                if (task.getStatus().equals("Completed") && task.isLogOnly()) {
                    logOnly = true;
                }
                DataSetTasksListGridViewImpl.this.selectedRow = -1;
                DataSetTasksListGridViewImpl.this.taskSelected.fire((Object)new TaskSelectionEvent(task.getTaskId(), task.getName(), task.isForAdmin(), logOnly));
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<TaskSummary, TaskSummary> actionsColumn = new Column<TaskSummary, TaskSummary>((Cell)cell){

            public TaskSummary getValue(TaskSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        return actionsColumn;
    }

    public void refreshNewTask(@Observes NewTaskEvent newTask) {
        ((AbstractTasksListGridPresenter)this.presenter).refreshGrid();
        PlaceStatus status = this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest("Task Details Multi"));
        if (status == PlaceStatus.OPEN) {
            this.taskSelected.fire((Object)new TaskSelectionEvent(newTask.getNewTaskId(), newTask.getNewTaskName()));
        } else {
            this.placeManager.goTo("Task Details Multi");
            this.taskSelected.fire((Object)new TaskSelectionEvent(newTask.getNewTaskId(), newTask.getNewTaskName()));
        }
        this.selectionModel.setSelected((Object)new TaskSummary(newTask.getNewTaskId(), newTask.getNewTaskName()), true);
    }

    private PlaceStatus getPlaceStatus(String place) {
        DefaultPlaceRequest defaultPlaceRequest = new DefaultPlaceRequest(place);
        PlaceStatus status = this.placeManager.getStatus((PlaceRequest)defaultPlaceRequest);
        return status;
    }

    private void closePlace(String place) {
        if (this.getPlaceStatus(place) == PlaceStatus.OPEN) {
            this.placeManager.closePlace(place);
        }
    }

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
        ((AbstractTasksListGridPresenter)this.presenter).setAddingDefaultFilters(true);
        List states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ACTIVE);
        this.initOwnTabFilter(preferences, DATASET_TASK_LIST_PREFIX + "_0", Constants.INSTANCE.Active(), Constants.INSTANCE.FilterActive(), states, "Potential Owner");
        states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.PERSONAL);
        this.initPersonalTabFilter(preferences, DATASET_TASK_LIST_PREFIX + "_1", Constants.INSTANCE.Personal(), Constants.INSTANCE.FilterPersonal(), states, "Potential Owner");
        states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.GROUP);
        this.initGroupTabFilter(preferences, DATASET_TASK_LIST_PREFIX + "_2", Constants.INSTANCE.Group(), Constants.INSTANCE.FilterGroup(), states, "Potential Owner");
        states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ALL);
        this.initOwnTabFilter(preferences, DATASET_TASK_LIST_PREFIX + "_3", Constants.INSTANCE.All(), Constants.INSTANCE.FilterAll(), states, "Potential Owner");
        states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ADMIN);
        this.initAdminTabFilter(preferences, DATASET_TASK_LIST_PREFIX + "_4", Constants.INSTANCE.Task_Admin(), Constants.INSTANCE.FilterTaskAdmin(), states, "Administrator");
        this.filterPagedTable.addAddTableButton(createTabButton);
        ((AbstractTasksListGridPresenter)this.presenter).setAddingDefaultFilters(false);
        this.getMultiGridPreferencesStore().setSelectedGrid(DATASET_TASK_LIST_PREFIX + "_0");
        this.filterPagedTable.setSelectedTab();
        this.applyFilterOnPresenter(DATASET_TASK_LIST_PREFIX + "_0");
    }

    private void initGroupTabFilter(GridGlobalPreferences preferences, final String key, String tabName, String tabDesc, List<String> states, String role) {
        ExtendedPagedTable extendedPagedTable;
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmHumanTasksWithUser");
        ArrayList<String> names = new ArrayList<String>();
        for (String s : states) {
            names.add(s);
        }
        builder.filter("status", new ColumnFilter[]{FilterFactory.equalsTo((String)"status", names)});
        builder.filter("actualOwner", new ColumnFilter[]{FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"")), FilterFactory.isNull()})});
        builder.group("taskId");
        builder.setColumn("activationTime", this.constants.ActivationTime(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("actualOwner", this.constants.Actual_Owner());
        builder.setColumn("createdBy", this.constants.CreatedBy());
        builder.setColumn("createdOn", this.constants.Created_On(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("deploymentId", this.constants.DeploymentId());
        builder.setColumn("description", this.constants.Description());
        builder.setColumn("dueDate", this.constants.DueDate(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("name", this.constants.Task());
        builder.setColumn("parentId", this.constants.ParentId());
        builder.setColumn("priority", this.constants.Priority());
        builder.setColumn("processId", this.constants.Process_Id());
        builder.setColumn("processInstanceId", this.constants.Process_Instance_Id());
        builder.setColumn("processSessionId", this.constants.ProcessSessionId());
        builder.setColumn("status", this.constants.Status());
        builder.setColumn("taskId", this.constants.Id());
        builder.setColumn("workItemId", this.constants.WorkItemId());
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("createdOn", SortOrder.DESCENDING);
        FilterSettings tableSettings = builder.buildSettings();
        tableSettings.setKey(key);
        tableSettings.setTableName(tabName);
        tableSettings.setTableDescription(tabDesc);
        HashMap<String, String> tabSettingsValues = new HashMap<String, String>();
        tabSettingsValues.put(FILTER_TABLE_SETTINGS, this.dataSetEditorManager.getTableSettingsToStr(tableSettings));
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, tableSettings.getTableName());
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, tableSettings.getTableDescription());
        this.filterPagedTable.saveNewTabSettings(key, tabSettingsValues);
        this.currentListGrid = extendedPagedTable = this.createGridInstance(new GridGlobalPreferences(key, preferences.getInitialColumns(), preferences.getBannedColumns()), key);
        extendedPagedTable.setDataProvider((AbstractDataProvider)((AbstractTasksListGridPresenter)this.presenter).getDataProvider());
        this.filterPagedTable.addTab((PagedTable)extendedPagedTable, key, new Command(){

            public void execute() {
                DataSetTasksListGridViewImpl.this.currentListGrid = extendedPagedTable;
                DataSetTasksListGridViewImpl.this.applyFilterOnPresenter(key);
            }
        });
    }

    private void initAdminTabFilter(GridGlobalPreferences preferences, final String key, String tabName, String tabDesc, List<String> states, String role) {
        ExtendedPagedTable extendedPagedTable;
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmHumanTasksWithAdmin");
        ArrayList<String> names = new ArrayList<String>();
        for (String s : states) {
            names.add(s);
        }
        builder.filter("status", new ColumnFilter[]{FilterFactory.equalsTo((String)"status", names)});
        builder.group("taskId");
        builder.setColumn("activationTime", this.constants.ActivationTime(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("actualOwner", this.constants.Actual_Owner());
        builder.setColumn("createdBy", this.constants.CreatedBy());
        builder.setColumn("createdOn", this.constants.Created_On(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("deploymentId", this.constants.DeploymentId());
        builder.setColumn("description", this.constants.Description());
        builder.setColumn("dueDate", this.constants.DueDate(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("name", this.constants.Task());
        builder.setColumn("parentId", this.constants.ParentId());
        builder.setColumn("priority", this.constants.Priority());
        builder.setColumn("processId", this.constants.Process_Id());
        builder.setColumn("processInstanceId", this.constants.Process_Instance_Id());
        builder.setColumn("processSessionId", this.constants.ProcessSessionId());
        builder.setColumn("status", this.constants.Status());
        builder.setColumn("taskId", this.constants.Id());
        builder.setColumn("workItemId", this.constants.WorkItemId());
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("createdOn", SortOrder.DESCENDING);
        FilterSettings tableSettings = builder.buildSettings();
        tableSettings.setKey(key);
        tableSettings.setTableName(tabName);
        tableSettings.setTableDescription(tabDesc);
        HashMap<String, String> tabSettingsValues = new HashMap<String, String>();
        tabSettingsValues.put(FILTER_TABLE_SETTINGS, this.dataSetEditorManager.getTableSettingsToStr(tableSettings));
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, tableSettings.getTableName());
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, tableSettings.getTableDescription());
        this.filterPagedTable.saveNewTabSettings(key, tabSettingsValues);
        this.currentListGrid = extendedPagedTable = this.createGridInstance(new GridGlobalPreferences(key, preferences.getInitialColumns(), preferences.getBannedColumns()), key);
        extendedPagedTable.setDataProvider((AbstractDataProvider)((AbstractTasksListGridPresenter)this.presenter).getDataProvider());
        this.filterPagedTable.addTab((PagedTable)extendedPagedTable, key, new Command(){

            public void execute() {
                DataSetTasksListGridViewImpl.this.currentListGrid = extendedPagedTable;
                DataSetTasksListGridViewImpl.this.applyFilterOnPresenter(key);
            }
        });
    }

    private void initPersonalTabFilter(GridGlobalPreferences preferences, final String key, String tabName, String tabDesc, List<String> states, String role) {
        ExtendedPagedTable extendedPagedTable;
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmHumanTasks");
        ArrayList<String> names = new ArrayList<String>();
        for (String s : states) {
            names.add(s);
        }
        builder.filter(new ColumnFilter[]{FilterFactory.equalsTo((String)"status", names)});
        builder.filter(new ColumnFilter[]{FilterFactory.equalsTo((String)"actualOwner", (Comparable)((Object)this.identity.getIdentifier()))});
        builder.setColumn("activationTime", "Activation Time", DateUtils.getDateTimeFormatMask());
        builder.setColumn("actualOwner", this.constants.Actual_Owner());
        builder.setColumn("createdBy", this.constants.CreatedBy());
        builder.setColumn("createdOn", this.constants.Created_On(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("deploymentId", this.constants.DeploymentId());
        builder.setColumn("description", this.constants.Description());
        builder.setColumn("dueDate", this.constants.DueDate(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("name", this.constants.Task());
        builder.setColumn("parentId", this.constants.ParentId());
        builder.setColumn("priority", this.constants.Priority());
        builder.setColumn("processId", this.constants.Process_Id());
        builder.setColumn("processInstanceId", this.constants.Process_Instance_Id());
        builder.setColumn("processSessionId", this.constants.ProcessSessionId());
        builder.setColumn("status", this.constants.Status());
        builder.setColumn("taskId", this.constants.Id());
        builder.setColumn("workItemId", this.constants.WorkItemId());
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("createdOn", SortOrder.DESCENDING);
        FilterSettings tableSettings = builder.buildSettings();
        tableSettings.setKey(key);
        tableSettings.setTableName(tabName);
        tableSettings.setTableDescription(tabDesc);
        HashMap<String, String> tabSettingsValues = new HashMap<String, String>();
        tabSettingsValues.put(FILTER_TABLE_SETTINGS, this.dataSetEditorManager.getTableSettingsToStr(tableSettings));
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, tableSettings.getTableName());
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, tableSettings.getTableDescription());
        this.filterPagedTable.saveNewTabSettings(key, tabSettingsValues);
        this.currentListGrid = extendedPagedTable = this.createGridInstance(new GridGlobalPreferences(key, preferences.getInitialColumns(), preferences.getBannedColumns()), key);
        extendedPagedTable.setDataProvider((AbstractDataProvider)((AbstractTasksListGridPresenter)this.presenter).getDataProvider());
        this.filterPagedTable.addTab((PagedTable)extendedPagedTable, key, new Command(){

            public void execute() {
                DataSetTasksListGridViewImpl.this.currentListGrid = extendedPagedTable;
                DataSetTasksListGridViewImpl.this.applyFilterOnPresenter(key);
            }
        });
    }

    private void initOwnTabFilter(GridGlobalPreferences preferences, final String key, String tabName, String tabDesc, List<String> states, String role) {
        ExtendedPagedTable extendedPagedTable;
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmHumanTasksWithUser");
        ArrayList<String> names = new ArrayList<String>();
        for (String s : states) {
            names.add(s);
        }
        builder.filter("status", new ColumnFilter[]{FilterFactory.equalsTo((String)"status", names)});
        builder.group("taskId");
        builder.setColumn("activationTime", this.constants.ActivationTime(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("actualOwner", this.constants.Actual_Owner());
        builder.setColumn("createdBy", this.constants.CreatedBy());
        builder.setColumn("createdOn", this.constants.Created_On(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("deploymentId", this.constants.DeploymentId());
        builder.setColumn("description", this.constants.Description());
        builder.setColumn("dueDate", this.constants.DueDate(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("name", this.constants.Task());
        builder.setColumn("parentId", this.constants.ParentId());
        builder.setColumn("priority", this.constants.Priority());
        builder.setColumn("processId", this.constants.Process_Id());
        builder.setColumn("processInstanceId", this.constants.Process_Instance_Id());
        builder.setColumn("processSessionId", this.constants.ProcessSessionId());
        builder.setColumn("status", this.constants.Status());
        builder.setColumn("taskId", this.constants.Id());
        builder.setColumn("workItemId", this.constants.WorkItemId());
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("createdOn", SortOrder.DESCENDING);
        FilterSettings tableSettings = builder.buildSettings();
        tableSettings.setKey(key);
        tableSettings.setTableName(tabName);
        tableSettings.setTableDescription(tabDesc);
        HashMap<String, String> tabSettingsValues = new HashMap<String, String>();
        tabSettingsValues.put(FILTER_TABLE_SETTINGS, this.dataSetEditorManager.getTableSettingsToStr(tableSettings));
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, tableSettings.getTableName());
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, tableSettings.getTableDescription());
        this.filterPagedTable.saveNewTabSettings(key, tabSettingsValues);
        this.currentListGrid = extendedPagedTable = this.createGridInstance(new GridGlobalPreferences(key, preferences.getInitialColumns(), preferences.getBannedColumns()), key);
        extendedPagedTable.setDataProvider((AbstractDataProvider)((AbstractTasksListGridPresenter)this.presenter).getDataProvider());
        this.filterPagedTable.addTab((PagedTable)extendedPagedTable, key, new Command(){

            public void execute() {
                DataSetTasksListGridViewImpl.this.currentListGrid = extendedPagedTable;
                DataSetTasksListGridViewImpl.this.applyFilterOnPresenter(key);
            }
        });
    }

    public void applyFilterOnPresenter(HashMap<String, Object> params) {
        String tableSettingsJSON = (String)params.get(FILTER_TABLE_SETTINGS);
        FilterSettings tableSettings = this.dataSetEditorManager.getStrToTableSettings(tableSettingsJSON);
        ((AbstractTasksListGridPresenter)this.presenter).filterGrid(tableSettings);
    }

    @Override
    public void applyFilterOnPresenter(String key) {
        this.initSelectionModel();
        this.applyFilterOnPresenter(this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(key));
    }

    public FilterSettings createTableSettingsPrototype() {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmHumanTasksWithUser");
        builder.group("taskId");
        builder.setColumn("activationTime", this.constants.ActivationTime(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("actualOwner", this.constants.Actual_Owner());
        builder.setColumn("createdBy", this.constants.CreatedBy());
        builder.setColumn("createdOn", this.constants.Created_On(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("deploymentId", this.constants.DeploymentId());
        builder.setColumn("description", this.constants.Description());
        builder.setColumn("dueDate", this.constants.DueDate(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("name", this.constants.Task());
        builder.setColumn("parentId", this.constants.ParentId());
        builder.setColumn("priority", this.constants.Priority());
        builder.setColumn("processId", this.constants.Process_Id());
        builder.setColumn("processInstanceId", this.constants.Process_Instance_Id());
        builder.setColumn("processSessionId", this.constants.ProcessSessionId());
        builder.setColumn("status", this.constants.Status());
        builder.setColumn("taskId", this.constants.Id());
        builder.setColumn("workItemId", this.constants.WorkItemId());
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("createdOn", SortOrder.DESCENDING);
        return builder.buildSettings();
    }

    @Override
    public int getRefreshValue() {
        return this.getMultiGridPreferencesStore().getRefreshInterval();
    }

    @Override
    public void saveRefreshValue(int newValue) {
        this.filterPagedTable.saveNewRefreshInterval(newValue);
    }

    private boolean isColumnAdded(List<ColumnMeta<TaskSummary>> columnMetas, String caption) {
        if (caption != null) {
            for (ColumnMeta<TaskSummary> colMet : columnMetas) {
                if (!caption.equals(colMet.getColumn().getDataStoreName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addDomainSpecifColumns(ExtendedPagedTable<TaskSummary> extendedPagedTable, Set<String> columns) {
        extendedPagedTable.storeColumnToPreferences();
        HashMap<String, String> modifiedCaptions = new HashMap<String, String>();
        ArrayList<ColumnMeta> existingExtraColumns = new ArrayList<ColumnMeta>();
        for (ColumnMeta cm : extendedPagedTable.getColumnMetaList()) {
            if (cm.isExtraColumn()) {
                existingExtraColumns.add(cm);
                continue;
            }
            if (!columns.contains(cm.getCaption())) continue;
            for (String c : columns) {
                if (!c.equals(cm.getCaption())) continue;
                modifiedCaptions.put(c, "Var_" + c);
            }
        }
        for (ColumnMeta colMet : existingExtraColumns) {
            if (!columns.contains(colMet.getCaption())) {
                extendedPagedTable.removeColumnMeta(colMet);
                continue;
            }
            columns.remove(colMet.getCaption());
        }
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        String caption = "";
        Iterator<String> i$ = columns.iterator();
        while (i$.hasNext()) {
            String c;
            caption = c = i$.next();
            if (modifiedCaptions.get(c) != null) {
                caption = (String)modifiedCaptions.get(c);
            }
            Column genericColumn = this.initGenericColumn(c);
            genericColumn.setSortable(false);
            columnMetas.add(new ColumnMeta(genericColumn, caption, true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
    }

    @Override
    public FilterSettings getVariablesTableSettings(String taskName) {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmHumanTasksWithVariables");
        builder.filter(new ColumnFilter[]{FilterFactory.equalsTo((String)"TASKNAME", (Comparable)((Object)taskName))});
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("taskId", SortOrder.ASCENDING);
        FilterSettings varTableSettings = builder.buildSettings();
        varTableSettings.setTablePageSize(-1);
        return varTableSettings;
    }

    private Column initGenericColumn(final String key) {
        Column<TaskSummary, String> genericColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return object.getDomainDataValue(key);
            }
        };
        genericColumn.setSortable(true);
        genericColumn.setDataStoreName(key);
        return genericColumn;
    }

    public void resetDefaultFilterTitleAndDescription() {
        HashMap tabSettingsValues = null;
        tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(DATASET_TASK_LIST_PREFIX + "_0");
        if (tabSettingsValues != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, Constants.INSTANCE.Active());
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, Constants.INSTANCE.FilterActive());
            this.filterPagedTable.saveTabSettings(DATASET_TASK_LIST_PREFIX + "_0", tabSettingsValues);
        }
        if ((tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(DATASET_TASK_LIST_PREFIX + "_1")) != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, Constants.INSTANCE.Personal());
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, Constants.INSTANCE.FilterPersonal());
            this.filterPagedTable.saveTabSettings(DATASET_TASK_LIST_PREFIX + "_1", tabSettingsValues);
        }
        if ((tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(DATASET_TASK_LIST_PREFIX + "_2")) != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, Constants.INSTANCE.Group());
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, Constants.INSTANCE.FilterGroup());
            this.filterPagedTable.saveTabSettings(DATASET_TASK_LIST_PREFIX + "_2", tabSettingsValues);
        }
        if ((tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(DATASET_TASK_LIST_PREFIX + "_3")) != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, Constants.INSTANCE.All());
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, Constants.INSTANCE.FilterAll());
            this.filterPagedTable.saveTabSettings(DATASET_TASK_LIST_PREFIX + "_3", tabSettingsValues);
        }
        if ((tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(DATASET_TASK_LIST_PREFIX + "_4")) != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, Constants.INSTANCE.Task_Admin());
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, Constants.INSTANCE.FilterTaskAdmin());
            this.filterPagedTable.saveTabSettings(DATASET_TASK_LIST_PREFIX + "_4", tabSettingsValues);
        }
    }

    protected class ReleaseActionHasCell
    extends ButtonActionCell<TaskSummary> {
        public ReleaseActionHasCell(String text, ActionCell.Delegate<TaskSummary> delegate) {
            super(text, delegate);
        }

        public void render(Cell.Context context, TaskSummary value, SafeHtmlBuilder sb) {
            if (value.getActualOwner() != null && value.getActualOwner().equals(DataSetTasksListGridViewImpl.this.identity.getIdentifier()) && (value.getStatus().equals("Reserved") || value.getStatus().equals("InProgress"))) {
                super.render(context, (Object)value, sb);
            }
        }
    }

    protected class ClaimActionHasCell
    extends ButtonActionCell<TaskSummary> {
        public ClaimActionHasCell(String text, ActionCell.Delegate<TaskSummary> delegate) {
            super(text, delegate);
        }

        public void render(Cell.Context context, TaskSummary value, SafeHtmlBuilder sb) {
            if (value.getStatus().equals("Ready")) {
                super.render(context, (Object)value, sb);
            }
        }
    }

    protected class CompleteActionHasCell
    extends ButtonActionCell<TaskSummary> {
        public CompleteActionHasCell(String text, ActionCell.Delegate<TaskSummary> delegate) {
            super(text, delegate);
        }

        public void render(Cell.Context context, TaskSummary value, SafeHtmlBuilder sb) {
            if (value.getActualOwner() != null && value.getStatus().equals("InProgress")) {
                super.render(context, (Object)value, sb);
            }
        }
    }
}

