/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskadmin;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FormControlStatic;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.TaskAssignmentSummary;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.service.TaskLifeCycleService;
import org.jbpm.console.ng.ht.service.TaskOperationsService;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

@Dependent
public class TaskAdminPresenter {
    private Constants constants = Constants.INSTANCE;
    @Inject
    private TaskAdminView view;
    @Inject
    private User identity;
    @Inject
    protected Caller<TaskLifeCycleService> taskServices;
    @Inject
    protected Caller<TaskOperationsService> taskOperationsServices;
    private long currentTaskId = 0L;
    @Inject
    private Event<TaskRefreshedEvent> taskRefreshed;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getView() {
        return this.view;
    }

    public void forwardTask(String entity) {
        ((TaskLifeCycleService)this.taskServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                TaskAdminPresenter.this.view.displayNotification(TaskAdminPresenter.this.constants.TaskSuccessfullyForwarded());
                TaskAdminPresenter.this.taskRefreshed.fire((Object)new TaskRefreshedEvent(TaskAdminPresenter.this.currentTaskId));
                TaskAdminPresenter.this.refreshTaskPotentialOwners();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)TaskAdminPresenter.this.constants.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).delegate(this.currentTaskId, this.identity.getIdentifier(), entity);
    }

    public void reminder() {
        ((TaskOperationsService)this.taskOperationsServices.call((RemoteCallback)new RemoteCallback<TaskAssignmentSummary>(){

            public void callback(TaskAssignmentSummary ts) {
                TaskAdminPresenter.this.view.displayNotification(TaskAdminPresenter.this.constants.ReminderSentTo(TaskAdminPresenter.this.identity.getIdentifier()));
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)TaskAdminPresenter.this.constants.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).executeReminderForTask(this.currentTaskId, this.identity.getIdentifier());
    }

    public void refreshTaskPotentialOwners() {
        ArrayList<Long> taskIds = new ArrayList<Long>(1);
        taskIds.add(this.currentTaskId);
        ((TaskOperationsService)this.taskOperationsServices.call((RemoteCallback)new RemoteCallback<TaskAssignmentSummary>(){

            public void callback(TaskAssignmentSummary ts) {
                if (ts == null) {
                    TaskAdminPresenter.this.view.getReminderButton().setEnabled(false);
                    TaskAdminPresenter.this.view.getForwardButton().setEnabled(false);
                    TaskAdminPresenter.this.view.getUserOrGroupText().setEnabled(false);
                    return;
                }
                if (ts.getPotOwnersString() != null && ts.getPotOwnersString().isEmpty()) {
                    TaskAdminPresenter.this.view.getUsersGroupsControlsPanel().setText(Constants.INSTANCE.No_Potential_Owners());
                } else {
                    TaskAdminPresenter.this.view.getUsersGroupsControlsPanel().setText("" + ts.getPotOwnersString().toString());
                }
                TaskAdminPresenter.this.view.getForwardButton().setEnabled(true);
                TaskAdminPresenter.this.view.getUserOrGroupText().setEnabled(true);
                if (ts.getActualOwner() == null || ts.getActualOwner().equals("")) {
                    TaskAdminPresenter.this.view.getReminderButton().setEnabled(false);
                    TaskAdminPresenter.this.view.getActualOwnerPanel().setText(Constants.INSTANCE.No_Actual_Owner());
                } else {
                    TaskAdminPresenter.this.view.getReminderButton().setEnabled(true);
                    TaskAdminPresenter.this.view.getActualOwnerPanel().setText(ts.getActualOwner());
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)TaskAdminPresenter.this.constants.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).getTaskAssignmentDetails(this.currentTaskId);
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.currentTaskId = event.getTaskId();
        this.refreshTaskPotentialOwners();
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.currentTaskId == event.getTaskId()) {
            this.refreshTaskPotentialOwners();
        }
    }

    public static interface TaskAdminView
    extends IsWidget {
        public void displayNotification(String var1);

        public FormControlStatic getUsersGroupsControlsPanel();

        public Button getForwardButton();

        public TextBox getUserOrGroupText();

        public Button getReminderButton();

        public FormControlStatic getActualOwnerPanel();

        public void init(TaskAdminPresenter var1);
    }
}

