/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.tasklogs;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.gc.client.util.DateUtils;
import org.jbpm.console.ng.ht.model.TaskEventSummary;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.service.TaskService;

@Dependent
public class TaskLogsPresenter {
    private TaskLogsView view;
    private Caller<TaskService> taskService;
    private long currentTaskId = 0L;
    private String serverTemplateId;
    private String containerId;

    @Inject
    public TaskLogsPresenter(TaskLogsView view, Caller<TaskService> taskService) {
        this.view = view;
        this.taskService = taskService;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getView() {
        return this.view;
    }

    public void refreshLogs() {
        this.view.setLogTextAreaText("");
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<List<TaskEventSummary>>(){

            public void callback(List<TaskEventSummary> events) {
                SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
                for (TaskEventSummary tes : events) {
                    String summaryStr = this.summaryToString(tes);
                    safeHtmlBuilder.appendEscapedLines(summaryStr);
                }
                TaskLogsPresenter.this.view.setLogTextAreaText(safeHtmlBuilder.toSafeHtml().asString());
            }

            public String summaryToString(TaskEventSummary tes) {
                String timeStamp = DateUtils.getDateTimeStr((Date)tes.getLogTime());
                String additionalDetail = "UPDATED".equals(tes.getType()) ? tes.getMessage() : tes.getUserId();
                return timeStamp + ": Task " + tes.getType() + " (" + additionalDetail + ")\n";
            }
        })).getTaskEvents(this.serverTemplateId, this.containerId, Long.valueOf(this.currentTaskId));
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.currentTaskId = event.getTaskId();
        this.containerId = event.getContainerId();
        this.serverTemplateId = event.getServerTemplateId();
        this.refreshLogs();
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.currentTaskId == event.getTaskId()) {
            this.refreshLogs();
        }
    }

    public static interface TaskLogsView
    extends IsWidget {
        public void init(TaskLogsPresenter var1);

        public void displayNotification(String var1);

        public void setLogTextAreaText(String var1);
    }
}

