/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash;

import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.gwtbootstrap3.client.ui.Button;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.list.base.DataSetEditorManager;
import org.jbpm.console.ng.df.client.list.base.DataSetQueryHelper;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.ht.client.editors.taskslist.grid.AbstractTasksListGridPresenter;
import org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash.DataSetTasksListGridPresenter;
import org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash.DataSetTasksListGridViewImpl;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.widgets.common.client.tables.FilterPagedTable;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetTasksListGridViewTest {
    private CallerMock<UserPreferencesService> callerMockUserPreferencesService;
    @Mock
    private UserPreferencesService userPreferencesServiceMock;
    @Mock
    protected ExtendedPagedTable<TaskSummary> currentListGrid;
    @Mock
    protected GridPreferencesStore gridPreferencesStoreMock;
    @Mock
    MultiGridPreferencesStore multiGridPreferencesStoreMock;
    @Mock
    DataSetQueryHelper dataSetQueryHelperMock;
    @Mock
    FilterPagedTable filterPagedTableMock;
    @Mock
    protected Button mockButton;
    @InjectMocks
    private DataSetTasksListGridViewImpl view;
    @Mock
    private DataSetTasksListGridPresenter presenter;
    @Mock
    public User identity;
    @Mock
    private DataSetEditorManager dataSetEditorManagerMock;

    @Before
    public void setupMocks() {
        Mockito.when((Object)this.presenter.getDataProvider()).thenReturn(Mockito.mock(AsyncDataProvider.class));
        Mockito.when((Object)this.filterPagedTableMock.getMultiGridPreferencesStore()).thenReturn((Object)this.multiGridPreferencesStoreMock);
        Mockito.when((Object)this.currentListGrid.getGridPreferencesStore()).thenReturn((Object)new GridPreferencesStore());
        this.callerMockUserPreferencesService = new CallerMock((Object)this.userPreferencesServiceMock);
        this.view.setPreferencesService(this.callerMockUserPreferencesService);
    }

    @Test
    public void testDataStoreNameIsSet() {
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                for (ColumnMeta columnMeta : columns) {
                    Assert.assertNotNull((Object)columnMeta.getColumn().getDataStoreName());
                }
                return null;
            }
        }).when(this.currentListGrid)).addColumns(Mockito.anyList());
        this.view.initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify(this.currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void testIsNullTableSettingsPrototype() {
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"user");
        this.view.setIdentity(this.identity);
        FilterSettings filterSettings = this.view.createTableSettingsPrototype();
        List ops = filterSettings.getDataSetLookup().getOperationList();
        for (DataSetOp op : ops) {
            if (!op.getType().equals((Object)DataSetOpType.FILTER)) continue;
            List columnFilters = ((DataSetFilter)op).getColumnFilterList();
            for (ColumnFilter columnFilter : columnFilters) {
                Assert.assertTrue((boolean)columnFilter.toString().contains("actualOwner is_null"));
            }
        }
    }

    @Test
    public void getVariablesTableSettingsTest() {
        FilterSettings filterSettings = this.view.getVariablesTableSettings("Test");
        List ops = filterSettings.getDataSetLookup().getOperationList();
        for (DataSetOp op : ops) {
            if (!op.getType().equals((Object)DataSetOpType.FILTER)) continue;
            List columnFilters = ((DataSetFilter)op).getColumnFilterList();
            for (ColumnFilter columnFilter : columnFilters) {
                Assert.assertTrue((boolean)columnFilter.toString().contains("TASKNAME = Test"));
            }
        }
    }

    @Test
    public void initColumnsTest() {
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                Assert.assertTrue((columns.size() == 10 ? 1 : 0) != 0);
                return null;
            }
        }).when(this.currentListGrid)).addColumns(Mockito.anyList());
        ArrayList columnPreferences = new ArrayList();
        Mockito.when((Object)this.currentListGrid.getGridPreferencesStore()).thenReturn((Object)this.gridPreferencesStoreMock);
        Mockito.when((Object)this.gridPreferencesStoreMock.getColumnPreferences()).thenReturn(columnPreferences);
        this.view.initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify(this.currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void initColumnsWithTaskVarColumnsTest() {
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                Assert.assertTrue((columns.size() == 13 ? 1 : 0) != 0);
                return null;
            }
        }).when(this.currentListGrid)).addColumns(Mockito.anyList());
        ArrayList<GridColumnPreference> columnPreferences = new ArrayList<GridColumnPreference>();
        columnPreferences.add(new GridColumnPreference("var1", Integer.valueOf(0), "40"));
        columnPreferences.add(new GridColumnPreference("var2", Integer.valueOf(1), "40"));
        columnPreferences.add(new GridColumnPreference("var3", Integer.valueOf(1), "40"));
        Mockito.when((Object)this.currentListGrid.getGridPreferencesStore()).thenReturn((Object)this.gridPreferencesStoreMock);
        Mockito.when((Object)this.gridPreferencesStoreMock.getColumnPreferences()).thenReturn(columnPreferences);
        this.view.initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify(this.currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void initDefaultFiltersOwnTaskFilter() {
        this.view.initDefaultFilters(new GridGlobalPreferences(), this.mockButton);
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock, (VerificationMode)Mockito.times((int)5))).addTab((PagedTable)Mockito.any(ExtendedPagedTable.class), Mockito.anyString(), (Command)Mockito.any(Command.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).addAddTableButton(this.mockButton);
        ((DataSetTasksListGridPresenter)Mockito.verify((Object)this.presenter)).setAddingDefaultFilters(true);
        ((DataSetTasksListGridPresenter)Mockito.verify((Object)this.presenter)).setAddingDefaultFilters(false);
    }

    @Test
    public void addDomainSpecifColumnsTest() {
        HashSet<String> domainColumns = new HashSet<String>();
        domainColumns.add("var1");
        domainColumns.add("var2");
        domainColumns.add("var3");
        this.view.addDomainSpecifColumns(this.currentListGrid, domainColumns);
        ArgumentCaptor argument = ArgumentCaptor.forClass(List.class);
        ((ExtendedPagedTable)Mockito.verify(this.currentListGrid)).addColumns((List)argument.capture());
        List columns = (List)argument.getValue();
        Assert.assertTrue((columns.size() == 3 ? 1 : 0) != 0);
        int i = 0;
        for (String domainColumn : domainColumns) {
            Assert.assertEquals((Object)((ColumnMeta)columns.get(i)).getCaption(), (Object)domainColumn);
            ++i;
        }
    }

    @Test
    public void setDefaultFilterTitleAndDescriptionTest() {
        this.view.resetDefaultFilterTitleAndDescription();
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock, (VerificationMode)Mockito.times((int)5))).getMultiGridPreferencesStore();
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock, (VerificationMode)Mockito.times((int)5))).saveTabSettings(Mockito.anyString(), (HashMap)Mockito.any(HashMap.class));
    }

    @Test
    public void initialColumsTest() {
        this.view.init((AbstractTasksListGridPresenter)this.presenter);
        List columnPreferences = this.view.getListGrid().getGridPreferencesStore().getColumnPreferences();
        Assert.assertEquals((Object)"name", (Object)((GridColumnPreference)columnPreferences.get(0)).getName());
        Assert.assertEquals((Object)"processId", (Object)((GridColumnPreference)columnPreferences.get(1)).getName());
        Assert.assertEquals((Object)"status", (Object)((GridColumnPreference)columnPreferences.get(2)).getName());
        Assert.assertEquals((Object)"createdOn", (Object)((GridColumnPreference)columnPreferences.get(3)).getName());
        Assert.assertEquals((Object)"actions", (Object)((GridColumnPreference)columnPreferences.get(4)).getName());
    }
}

