/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.forms.client.display.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jbpm.console.ng.ga.forms.display.FormDisplayerConfig;
import org.jbpm.console.ng.ga.forms.display.GenericFormDisplayer;
import org.jbpm.console.ng.ga.forms.display.view.FormDisplayerView;
import org.jbpm.console.ng.ga.forms.service.FormServiceEntryPoint;
import org.jbpm.console.ng.ht.forms.display.ht.api.HumanTaskDisplayerConfig;
import org.jbpm.console.ng.ht.forms.display.ht.api.HumanTaskFormDisplayProvider;
import org.jbpm.console.ng.ht.forms.display.ht.api.HumanTaskFormDisplayer;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class HumanTaskFormDisplayProviderImpl
implements HumanTaskFormDisplayProvider {
    @Inject
    private Caller<FormServiceEntryPoint> formServices;
    @Inject
    protected SyncBeanManager iocManager;
    private List<HumanTaskFormDisplayer> taskDisplayers = new ArrayList<HumanTaskFormDisplayer>();

    @PostConstruct
    public void init() {
        this.taskDisplayers.clear();
        Collection taskDisplayersBeans = this.iocManager.lookupBeans(HumanTaskFormDisplayer.class);
        if (taskDisplayersBeans != null) {
            for (IOCBeanDef displayerDef : taskDisplayersBeans) {
                this.taskDisplayers.add((HumanTaskFormDisplayer)displayerDef.getInstance());
            }
        }
        Collections.sort(this.taskDisplayers, new Comparator<HumanTaskFormDisplayer>(){

            @Override
            public int compare(HumanTaskFormDisplayer o1, HumanTaskFormDisplayer o2) {
                if (o1.getPriority() < o2.getPriority()) {
                    return -1;
                }
                if (o1.getPriority() > o2.getPriority()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public void setup(HumanTaskDisplayerConfig config, FormDisplayerView view) {
        this.display(config, view);
    }

    protected void display(final HumanTaskDisplayerConfig config, final FormDisplayerView view) {
        if (this.taskDisplayers != null) {
            ((FormServiceEntryPoint)this.formServices.call((RemoteCallback)new RemoteCallback<String>(){

                public void callback(String form) {
                    for (HumanTaskFormDisplayer d : HumanTaskFormDisplayProviderImpl.this.taskDisplayers) {
                        if (!d.supportsContent(form)) continue;
                        config.setFormContent(form);
                        d.init((FormDisplayerConfig)config, view.getOnCloseCommand(), new Command(){

                            public void execute() {
                                HumanTaskFormDisplayProviderImpl.this.display(config, view);
                            }
                        }, view.getResizeListener());
                        view.display((GenericFormDisplayer)d);
                        return;
                    }
                }
            })).getFormDisplayTask(config.getKey().getTaskId().longValue());
        }
    }
}

