/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.forms.client.display.standalone;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jbpm.console.ng.ga.forms.display.view.FormDisplayerView;
import org.jbpm.console.ng.gc.forms.client.display.views.display.EmbeddedFormDisplayer;
import org.jbpm.console.ng.ht.forms.client.i18n.Constants;
import org.jbpm.console.ng.ht.forms.display.ht.api.HumanTaskDisplayerConfig;
import org.jbpm.console.ng.ht.forms.display.ht.api.HumanTaskFormDisplayProvider;
import org.jbpm.console.ng.ht.model.TaskKey;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchScreen(identifier="Standalone Task Form Display")
public class StandaloneTaskFormDisplayPresenter {
    @Inject
    private PlaceManager placeManager;
    @Inject
    private EmbeddedFormDisplayer view;
    @Inject
    private HumanTaskFormDisplayProvider humanTaskFormDisplayProvider;
    protected String placeOnClose;
    protected PlaceRequest place;

    @WorkbenchPartTitle
    public String getTitle() {
        return Constants.INSTANCE.Form();
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this.view;
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @OnOpen
    public void onOpen() {
        this.placeOnClose = this.place.getParameter("onClose", "none");
        Long currentTaskId = Long.parseLong(this.place.getParameter("taskId", "-1"));
        String opener = this.place.getParameter("opener", null);
        this.view.setOnCloseCommand(new Command(){

            public void execute() {
                if (!StandaloneTaskFormDisplayPresenter.this.placeOnClose.equals("none")) {
                    StandaloneTaskFormDisplayPresenter.this.placeManager.closePlace(StandaloneTaskFormDisplayPresenter.this.place);
                    StandaloneTaskFormDisplayPresenter.this.placeManager.forceClosePlace(StandaloneTaskFormDisplayPresenter.this.placeOnClose);
                } else {
                    StandaloneTaskFormDisplayPresenter.this.placeManager.closePlace(StandaloneTaskFormDisplayPresenter.this.place);
                }
            }
        });
        if (currentTaskId != -1L) {
            TaskKey key = new TaskKey(currentTaskId);
            HumanTaskDisplayerConfig config = new HumanTaskDisplayerConfig(key);
            config.setFormOpener(opener);
            this.humanTaskFormDisplayProvider.setup(config, (FormDisplayerView)this.view);
        }
    }
}

