/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.forms.client.display.displayers.task;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.ga.forms.display.FormDisplayerConfig;
import org.jbpm.console.ng.ga.forms.display.view.FormContentResizeListener;
import org.jbpm.console.ng.gc.forms.client.display.displayers.util.ActionRequest;
import org.jbpm.console.ng.gc.forms.client.display.displayers.util.JSNIHelper;
import org.jbpm.console.ng.ht.forms.client.display.ht.api.HumanTaskFormDisplayer;
import org.jbpm.console.ng.ht.forms.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.TaskKey;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.service.TaskService;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mvp.Command;

public abstract class AbstractHumanTaskFormDisplayer
implements HumanTaskFormDisplayer {
    public static final String ACTION_CLAIM_TASK = "claimTask";
    public static final String ACTION_START_TASK = "startTask";
    public static final String ACTION_RELEASE_TASK = "releaseTask";
    public static final String ACTION_SAVE_TASK = "saveTask";
    public static final String ACTION_COMPLETE_TASK = "completeTask";
    protected long taskId = -1L;
    protected String formContent;
    protected String opener;
    protected String taskName;
    protected String serverTemplateId;
    protected String deploymentId;
    protected final FormPanel container = new FormPanel();
    protected final ButtonGroup buttonsContainer = new ButtonGroup();
    protected final FlowPanel formContainer = new FlowPanel();
    private Command onClose;
    private Command onRefresh;
    protected FormContentResizeListener resizeListener;
    protected Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    protected ErrorPopupPresenter errorPopup;
    @Inject
    protected Caller<TaskService> taskService;
    @Inject
    protected Event<TaskRefreshedEvent> taskRefreshed;
    @Inject
    protected User identity;
    @Inject
    protected JSNIHelper jsniHelper;

    protected abstract void initDisplayer();

    protected abstract void completeFromDisplayer();

    protected abstract void saveStateFromDisplayer();

    protected abstract void startFromDisplayer();

    protected abstract void claimFromDisplayer();

    protected abstract void releaseFromDisplayer();

    @PostConstruct
    protected void init() {
        this.container.getElement().setId("form-data");
    }

    public void init(FormDisplayerConfig<TaskKey> config, Command onCloseCommand, Command onRefreshCommand, FormContentResizeListener resizeListener) {
        this.serverTemplateId = ((TaskKey)config.getKey()).getServerTemplateId();
        this.taskId = ((TaskKey)config.getKey()).getTaskId();
        this.deploymentId = ((TaskKey)config.getKey()).getDeploymentId();
        this.formContent = config.getFormContent();
        this.opener = config.getFormOpener();
        this.resizeListener = resizeListener;
        this.onClose = onCloseCommand;
        this.onRefresh = onRefreshCommand;
        if (this.formContainer.getParent() != this.container) {
            this.container.add((Widget)this.formContainer);
        }
        if (this.formContent == null || this.formContent.length() == 0) {
            return;
        }
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<TaskSummary>(){

            public void callback(TaskSummary task) {
                if (task == null) {
                    return;
                }
                AbstractHumanTaskFormDisplayer.this.buttonsContainer.clear();
                AbstractHumanTaskFormDisplayer.this.taskName = task.getTaskName();
                AbstractHumanTaskFormDisplayer.this.deploymentId = task.getDeploymentId();
                if (AbstractHumanTaskFormDisplayer.this.opener != null) {
                    AbstractHumanTaskFormDisplayer.this.injectEventListener(AbstractHumanTaskFormDisplayer.this);
                } else {
                    if (task.getStatus().equals("Ready")) {
                        Button claimButton = new Button();
                        claimButton.setType(ButtonType.PRIMARY);
                        claimButton.setText(AbstractHumanTaskFormDisplayer.this.constants.Claim());
                        claimButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                AbstractHumanTaskFormDisplayer.this.claimFromDisplayer();
                            }
                        });
                        AbstractHumanTaskFormDisplayer.this.buttonsContainer.add((Widget)claimButton);
                    }
                    if (task.getStatus().equals("Reserved") && task.getActualOwner().equals(AbstractHumanTaskFormDisplayer.this.identity.getIdentifier())) {
                        Button releaseButton = new Button();
                        releaseButton.setText(AbstractHumanTaskFormDisplayer.this.constants.Release());
                        releaseButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                AbstractHumanTaskFormDisplayer.this.releaseFromDisplayer();
                            }
                        });
                        AbstractHumanTaskFormDisplayer.this.buttonsContainer.add((Widget)releaseButton);
                        Button startButton = new Button();
                        startButton.setType(ButtonType.PRIMARY);
                        startButton.setText(AbstractHumanTaskFormDisplayer.this.constants.Start());
                        startButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                AbstractHumanTaskFormDisplayer.this.startFromDisplayer();
                            }
                        });
                        AbstractHumanTaskFormDisplayer.this.buttonsContainer.add((Widget)startButton);
                    } else if (task.getStatus().equals("InProgress") && task.getActualOwner().equals(AbstractHumanTaskFormDisplayer.this.identity.getIdentifier())) {
                        Button saveButton = new Button();
                        saveButton.setText(AbstractHumanTaskFormDisplayer.this.constants.Save());
                        saveButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                AbstractHumanTaskFormDisplayer.this.saveStateFromDisplayer();
                            }
                        });
                        AbstractHumanTaskFormDisplayer.this.buttonsContainer.add((Widget)saveButton);
                        Button releaseButton = new Button();
                        releaseButton.setText(AbstractHumanTaskFormDisplayer.this.constants.Release());
                        releaseButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                AbstractHumanTaskFormDisplayer.this.releaseFromDisplayer();
                            }
                        });
                        AbstractHumanTaskFormDisplayer.this.buttonsContainer.add((Widget)releaseButton);
                        Button completeButton = new Button();
                        completeButton.setType(ButtonType.PRIMARY);
                        completeButton.setText(AbstractHumanTaskFormDisplayer.this.constants.Complete());
                        completeButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                AbstractHumanTaskFormDisplayer.this.completeFromDisplayer();
                            }
                        });
                        AbstractHumanTaskFormDisplayer.this.buttonsContainer.add((Widget)completeButton);
                    }
                }
                AbstractHumanTaskFormDisplayer.this.initDisplayer();
            }
        }, this.getUnexpectedErrorCallback())).getTask(this.serverTemplateId, this.deploymentId, Long.valueOf(this.taskId));
    }

    @Override
    public void complete(Map<String, Object> params) {
        ((TaskService)this.taskService.call(this.getCompleteTaskRemoteCallback(), this.getUnexpectedErrorCallback())).completeTask(this.serverTemplateId, this.deploymentId, Long.valueOf(this.taskId), params);
    }

    @Override
    public void claim() {
        ((TaskService)this.taskService.call(this.getClaimTaskCallback(), this.getUnexpectedErrorCallback())).claimTask(this.serverTemplateId, this.deploymentId, Long.valueOf(this.taskId));
    }

    @Override
    public void release() {
        ((TaskService)this.taskService.call(this.getReleaseTaskRemoteCallback(), this.getUnexpectedErrorCallback())).releaseTask(this.serverTemplateId, this.deploymentId, Long.valueOf(this.taskId));
    }

    @Override
    public void saveState(Map<String, Object> state) {
        ((TaskService)this.taskService.call(this.getSaveTaskStateCallback(), this.getUnexpectedErrorCallback())).saveTaskContent(this.serverTemplateId, this.deploymentId, Long.valueOf(this.taskId), state);
    }

    @Override
    public void start() {
        ((TaskService)this.taskService.call(this.getStartTaskRemoteCallback(), this.getUnexpectedErrorCallback())).startTask(this.serverTemplateId, this.deploymentId, Long.valueOf(this.taskId));
    }

    public Panel getContainer() {
        return this.container;
    }

    public IsWidget getFooter() {
        return this.buttonsContainer;
    }

    protected RemoteCallback getStartTaskRemoteCallback() {
        return new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                AbstractHumanTaskFormDisplayer.this.taskRefreshed.fire((Object)new TaskRefreshedEvent(AbstractHumanTaskFormDisplayer.this.serverTemplateId, AbstractHumanTaskFormDisplayer.this.deploymentId, AbstractHumanTaskFormDisplayer.this.taskId));
                AbstractHumanTaskFormDisplayer.this.jsniHelper.notifySuccessMessage(AbstractHumanTaskFormDisplayer.this.opener, AbstractHumanTaskFormDisplayer.this.constants.TaskStarted(AbstractHumanTaskFormDisplayer.this.taskId));
                AbstractHumanTaskFormDisplayer.this.refresh();
            }
        };
    }

    protected RemoteCallback getClaimTaskCallback() {
        return new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                AbstractHumanTaskFormDisplayer.this.taskRefreshed.fire((Object)new TaskRefreshedEvent(AbstractHumanTaskFormDisplayer.this.serverTemplateId, AbstractHumanTaskFormDisplayer.this.deploymentId, AbstractHumanTaskFormDisplayer.this.taskId));
                AbstractHumanTaskFormDisplayer.this.jsniHelper.notifySuccessMessage(AbstractHumanTaskFormDisplayer.this.opener, AbstractHumanTaskFormDisplayer.this.constants.TaskClaimed(AbstractHumanTaskFormDisplayer.this.taskId));
                AbstractHumanTaskFormDisplayer.this.refresh();
            }
        };
    }

    protected RemoteCallback getSaveTaskStateCallback() {
        return new RemoteCallback<Long>(){

            public void callback(Long contentId) {
                AbstractHumanTaskFormDisplayer.this.taskRefreshed.fire((Object)new TaskRefreshedEvent(AbstractHumanTaskFormDisplayer.this.serverTemplateId, AbstractHumanTaskFormDisplayer.this.deploymentId, AbstractHumanTaskFormDisplayer.this.taskId));
                AbstractHumanTaskFormDisplayer.this.jsniHelper.notifySuccessMessage(AbstractHumanTaskFormDisplayer.this.opener, AbstractHumanTaskFormDisplayer.this.constants.TaskSaved(AbstractHumanTaskFormDisplayer.this.taskId));
                AbstractHumanTaskFormDisplayer.this.refresh();
            }
        };
    }

    protected RemoteCallback getReleaseTaskRemoteCallback() {
        return new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                AbstractHumanTaskFormDisplayer.this.taskRefreshed.fire((Object)new TaskRefreshedEvent(AbstractHumanTaskFormDisplayer.this.serverTemplateId, AbstractHumanTaskFormDisplayer.this.deploymentId, AbstractHumanTaskFormDisplayer.this.taskId));
                AbstractHumanTaskFormDisplayer.this.jsniHelper.notifySuccessMessage(AbstractHumanTaskFormDisplayer.this.opener, AbstractHumanTaskFormDisplayer.this.constants.TaskReleased(AbstractHumanTaskFormDisplayer.this.taskId));
                AbstractHumanTaskFormDisplayer.this.refresh();
            }
        };
    }

    protected RemoteCallback<Void> getCompleteTaskRemoteCallback() {
        return new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                ((TaskService)AbstractHumanTaskFormDisplayer.this.taskService.call((RemoteCallback)new RemoteCallback<TaskSummary>(){

                    public void callback(TaskSummary task) {
                        if (task == null) {
                            AbstractHumanTaskFormDisplayer.this.close();
                        }
                    }
                }, AbstractHumanTaskFormDisplayer.this.getUnexpectedErrorCallback())).getTask(AbstractHumanTaskFormDisplayer.this.serverTemplateId, AbstractHumanTaskFormDisplayer.this.deploymentId, Long.valueOf(AbstractHumanTaskFormDisplayer.this.taskId));
                AbstractHumanTaskFormDisplayer.this.taskRefreshed.fire((Object)new TaskRefreshedEvent(AbstractHumanTaskFormDisplayer.this.serverTemplateId, AbstractHumanTaskFormDisplayer.this.deploymentId, AbstractHumanTaskFormDisplayer.this.taskId));
                AbstractHumanTaskFormDisplayer.this.jsniHelper.notifySuccessMessage(AbstractHumanTaskFormDisplayer.this.opener, AbstractHumanTaskFormDisplayer.this.constants.TaskCompleted(AbstractHumanTaskFormDisplayer.this.taskId));
            }
        };
    }

    protected ErrorCallback<Message> getUnexpectedErrorCallback() {
        return new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                String notification = AbstractHumanTaskFormDisplayer.this.constants.UnexpectedError(throwable.getMessage());
                AbstractHumanTaskFormDisplayer.this.errorPopup.showMessage(notification);
                AbstractHumanTaskFormDisplayer.this.jsniHelper.notifyErrorMessage(AbstractHumanTaskFormDisplayer.this.opener, notification);
                return true;
            }
        };
    }

    public void addOnCloseCallback(Command callback) {
        this.onClose = callback;
    }

    public void addOnRefreshCallback(Command callback) {
        this.onRefresh = callback;
    }

    protected void refresh() {
        if (this.onRefresh != null) {
            this.onRefresh.execute();
        }
    }

    public void close() {
        if (this.onClose != null) {
            this.onClose.execute();
        }
        this.clearStatus();
    }

    protected void clearStatus() {
        this.taskId = -1L;
        this.formContent = null;
        this.opener = null;
        this.taskName = null;
        this.deploymentId = null;
        this.serverTemplateId = null;
        this.buttonsContainer.clear();
        this.formContainer.clear();
        this.onClose = null;
        this.onRefresh = null;
        this.resizeListener = null;
    }

    protected void eventListener(String origin, String request) {
        if (origin == null || !origin.endsWith("//" + this.opener)) {
            return;
        }
        ActionRequest actionRequest = (ActionRequest)JsonUtils.safeEval((String)request);
        if (ACTION_CLAIM_TASK.equals(actionRequest.getAction())) {
            this.claimFromDisplayer();
        } else if (ACTION_START_TASK.equals(actionRequest.getAction())) {
            this.startFromDisplayer();
        } else if (ACTION_RELEASE_TASK.equals(actionRequest.getAction())) {
            this.releaseFromDisplayer();
        } else if (ACTION_SAVE_TASK.equals(actionRequest.getAction())) {
            this.saveStateFromDisplayer();
        } else if (ACTION_COMPLETE_TASK.equals(actionRequest.getAction())) {
            this.completeFromDisplayer();
        }
    }

    private native void injectEventListener(AbstractHumanTaskFormDisplayer var1);

    public String getOpener() {
        return this.opener;
    }
}

