/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.forms.client.display.displayers.task;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.ui.HasWidgets;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jbpm.console.ng.gc.forms.client.display.displayers.util.PlaceManagerFormActivitySearcher;
import org.jbpm.console.ng.ht.forms.client.display.displayers.task.AbstractHumanTaskFormDisplayer;
import org.uberfire.ext.widgets.common.client.forms.GetFormParamsEvent;
import org.uberfire.ext.widgets.common.client.forms.RequestFormParamsEvent;
import org.uberfire.ext.widgets.common.client.forms.SetFormParamsEvent;

@Dependent
public class PlaceManagerTaskDisplayerImpl
extends AbstractHumanTaskFormDisplayer {
    @Inject
    private PlaceManagerFormActivitySearcher placeManagerFormActivitySearcher;
    @Inject
    private Event<SetFormParamsEvent> setFormParamsEvent;
    @Inject
    private Event<RequestFormParamsEvent> requestFormParamsEvent;

    @Override
    protected void initDisplayer() {
        JSONValue jsonValue = JSONParser.parseStrict((String)this.formContent);
        JSONObject jsonObject = jsonValue.isObject();
        if (jsonObject != null) {
            this.formContainer.setWidth("100%");
            this.formContainer.setHeight("400px");
            JSONValue jsonDestination = jsonObject.get("destination");
            if (jsonDestination == null) {
                return;
            }
            String destination = jsonDestination.isString().stringValue();
            JSONObject jsonParams = jsonObject.get("params").isObject();
            if (jsonParams == null) {
                return;
            }
            Map params = this.jsniHelper.parseParams(jsonParams);
            String taskStatus = (String)params.get("taskStatus");
            this.placeManagerFormActivitySearcher.findFormActivityWidget(destination, (HasWidgets)this.formContainer);
            if ("InProgress".equals(taskStatus)) {
                this.setFormParamsEvent.fire((Object)new SetFormParamsEvent(params, false));
            } else {
                this.setFormParamsEvent.fire((Object)new SetFormParamsEvent(params, true));
            }
        }
    }

    public boolean supportsContent(String content) {
        try {
            JSONValue jsonValue = JSONParser.parseStrict((String)content);
            JSONObject jsonObject = jsonValue.isObject();
            if (jsonObject == null) {
                return false;
            }
            jsonValue = jsonObject.get("handler");
            if (jsonValue.isString() == null) {
                return false;
            }
            return jsonValue.isString().stringValue().equals("handledByPlaceManagerFormProvider");
        }
        catch (Exception e) {
            return false;
        }
    }

    public void complete() {
        this.requestFormParamsEvent.fire((Object)new RequestFormParamsEvent("completeTask"));
        this.close();
    }

    public void saveState() {
        this.requestFormParamsEvent.fire((Object)new RequestFormParamsEvent("saveTask"));
    }

    @Override
    protected void startFromDisplayer() {
        this.start();
    }

    @Override
    protected void claimFromDisplayer() {
        this.claim();
    }

    @Override
    protected void releaseFromDisplayer() {
        this.release();
    }

    public int getPriority() {
        return 2;
    }

    @Override
    protected void completeFromDisplayer() {
        this.requestFormParamsEvent.fire((Object)new RequestFormParamsEvent("completeTask"));
    }

    protected void completeOrSaveFromEvent(@Observes GetFormParamsEvent event) {
        if (this.taskId == -1L) {
            return;
        }
        if (event.getAction().equals("completeTask")) {
            this.complete(event.getParams());
        } else if (event.getAction().equals("saveTask")) {
            this.saveState(event.getParams());
        }
    }

    @Override
    protected void saveStateFromDisplayer() {
        this.requestFormParamsEvent.fire((Object)new RequestFormParamsEvent("saveTask"));
    }
}

