/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.backend.server;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.droolsjbpm.services.api.DomainManagerService;
import org.droolsjbpm.services.domain.entities.Organization;
import org.jbpm.shared.services.cdi.Startup;

@ApplicationScoped
@Startup
public class InitApplication {
    @Inject
    private DomainManagerService domainManagerService;

    @PostConstruct
    public void newInitDomain() throws Exception {
        UserTransaction ut = null;
        try {
            ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        }
        catch (Exception ex) {
            try {
                ut = (UserTransaction)InitialContext.doLookup(System.getProperty("jbpm.ut.jndi.lookup", "java:jboss/UserTransaction"));
            }
            catch (Exception e1) {
                throw new RuntimeException("Cannot find UserTransaction", e1);
            }
        }
        ut.begin();
        try {
            ArrayList<Organization> organizations = this.domainManagerService.getAllOrganizations();
            if (organizations == null || organizations.isEmpty()) {
                this.cleanup();
                organizations = new ArrayList<Organization>();
                Organization organizationSummary = new Organization();
                organizationSummary.setName("jBPM Console NG");
                this.domainManagerService.storeOrganization(organizationSummary);
                organizations.add(organizationSummary);
            }
            for (Organization org : organizations) {
                this.domainManagerService.initOrganization(org.getId());
            }
            ut.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            ut.rollback();
        }
    }

    protected void cleanup() {
        File dataDir;
        String location = System.getProperty("jbpm.data.dir", System.getProperty("jboss.server.data.dir"));
        if (location == null) {
            location = System.getProperty("java.io.tmpdir");
        }
        if ((dataDir = new File(location)).exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = dataDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("-jbpmSessionId.ser");
                }
            })) {
                new File(dataDir, file).delete();
            }
        }
    }
}

