/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import org.droolsjbpm.services.impl.model.ProcessInstanceDesc;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.kie.api.runtime.process.NodeInstance;

public class ProcessInstanceHelper {
    public static Collection<ProcessInstanceSummary> adaptCollection(Collection<ProcessInstanceDesc> processInstances) {
        ArrayList<ProcessInstanceSummary> processInstancesSummary = new ArrayList<ProcessInstanceSummary>();
        for (ProcessInstanceDesc pi : processInstances) {
            processInstancesSummary.add(new ProcessInstanceSummary(pi.getId(), pi.getProcessId(), pi.getDomainId(), pi.getProcessName(), pi.getProcessVersion(), pi.getState(), pi.getDataTimeStamp().getTime()));
        }
        return processInstancesSummary;
    }

    public static ProcessInstanceSummary adapt(ProcessInstanceDesc processInstance) {
        return new ProcessInstanceSummary(processInstance.getId(), processInstance.getProcessId(), processInstance.getDomainId(), processInstance.getProcessName(), processInstance.getProcessVersion(), processInstance.getState(), processInstance.getDataTimeStamp().getTime());
    }

    public static Collection<String> collectActiveSignals(Collection<NodeInstance> activeNodes) {
        ArrayList<String> activeNodesComposite = new ArrayList<String>();
        for (NodeInstance nodeInstance : activeNodes) {
            String type;
            if (nodeInstance instanceof EventNodeInstance && (type = ((EventNodeInstance)nodeInstance).getEventNode().getType()) != null && !type.startsWith("Message-")) {
                activeNodesComposite.add(type);
            }
            if (!(nodeInstance instanceof CompositeNodeInstance)) continue;
            Collection currentNodeInstances = ((CompositeNodeInstance)nodeInstance).getNodeInstances();
            activeNodesComposite.addAll(ProcessInstanceHelper.collectActiveSignals(currentNodeInstances));
        }
        return activeNodesComposite;
    }
}

