/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.backend.server;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.droolsjbpm.services.api.DeploymentService;
import org.droolsjbpm.services.api.DeploymentUnit;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.pr.service.DeploymentManagerEntryPoint;
import org.jbpm.console.ng.pr.service.Initializable;

@Service
@ApplicationScoped
public class DeploymentManagerEntryPointImpl
implements DeploymentManagerEntryPoint,
Initializable {
    @Inject
    private DeploymentService deploymentService;
    @Inject
    @RequestScoped
    private Set<DeploymentUnit> deploymentUnits;

    public void initDeployments(Set<DeploymentUnit> deploymentUnits) {
        for (DeploymentUnit unit : deploymentUnits) {
            if (this.deploymentService.getDeployedUnit(unit.getIdentifier()) != null) continue;
            this.cleanup(unit.getIdentifier());
            this.deploymentService.deploy(unit);
        }
    }

    public void redeploy() {
        for (DeploymentUnit unit : this.deploymentUnits) {
            if (this.deploymentService.getDeployedUnit(unit.getIdentifier()) != null) {
                this.deploymentService.undeploy(unit);
            }
            this.deploymentService.deploy(unit);
        }
    }

    protected void cleanup(final String identifier) {
        File dataDir;
        String location = System.getProperty("jbpm.data.dir", System.getProperty("jboss.server.data.dir"));
        if (location == null) {
            location = System.getProperty("java.io.tmpdir");
        }
        if ((dataDir = new File(location)).exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = dataDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equals(identifier + "-jbpmSessionId.ser");
                }
            })) {
                new File(dataDir, file).delete();
            }
        }
    }
}

