/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.backend.server;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.droolsjbpm.services.impl.model.ProcessInstanceDesc;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.kie.api.runtime.process.NodeInstance;

public class ProcessInstanceHelper {
    public static Collection<ProcessInstanceSummary> adaptCollection(Collection<ProcessInstanceDesc> processInstances) {
        ArrayList<ProcessInstanceSummary> processInstancesSummary = new ArrayList<ProcessInstanceSummary>();
        for (ProcessInstanceDesc pi : processInstances) {
            processInstancesSummary.add(ProcessInstanceHelper.adapt(pi));
        }
        return processInstancesSummary;
    }

    public static ProcessInstanceSummary adapt(ProcessInstanceDesc processInstance) {
        Date date = processInstance.getDataTimeStamp();
        String formattedDate = new SimpleDateFormat("d/MMM/yy HH:mm:ss").format(date);
        return new ProcessInstanceSummary(processInstance.getId(), processInstance.getProcessId(), processInstance.getDeploymentId(), processInstance.getProcessName(), processInstance.getProcessVersion(), processInstance.getState(), formattedDate, processInstance.getInitiator());
    }

    public static Collection<String> collectActiveSignals(Collection<NodeInstance> activeNodes) {
        ArrayList<String> activeNodesComposite = new ArrayList<String>();
        for (NodeInstance nodeInstance : activeNodes) {
            String type;
            if (nodeInstance instanceof EventNodeInstance && (type = ((EventNodeInstance)nodeInstance).getEventNode().getType()) != null && !type.startsWith("Message-")) {
                activeNodesComposite.add(type);
            }
            if (!(nodeInstance instanceof CompositeNodeInstance)) continue;
            Collection currentNodeInstances = ((CompositeNodeInstance)nodeInstance).getNodeInstances();
            activeNodesComposite.addAll(ProcessInstanceHelper.collectActiveSignals(currentNodeInstances));
        }
        return activeNodesComposite;
    }
}

