/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.backend.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jbpm.console.ng.pr.model.VariableSummary;
import org.jbpm.kie.services.impl.model.VariableStateDesc;

public class VariableHelper {
    private static final List<String> excludedVariables = Arrays.asList("processId");

    public static Collection<VariableSummary> adaptCollection(Collection<VariableStateDesc> variables) {
        ArrayList<VariableSummary> variablesSummary = new ArrayList<VariableSummary>();
        for (VariableStateDesc v : variables) {
            variablesSummary.add(new VariableSummary(v.getVariableId(), v.getVariableInstanceId(), v.getProcessInstanceId(), v.getOldValue(), v.getNewValue(), v.getDataTimeStamp().toString(), ""));
        }
        return variablesSummary;
    }

    public static Collection<VariableSummary> adaptCollection(Collection<VariableStateDesc> variables, Map<String, String> properties, long processInstanceId) {
        ArrayList<VariableSummary> variablesSummary = new ArrayList<VariableSummary>();
        for (VariableStateDesc variableStateDesc : variables) {
            if (excludedVariables.contains(variableStateDesc.getVariableId())) continue;
            String type = properties.remove(variableStateDesc.getVariableId());
            variablesSummary.add(new VariableSummary(variableStateDesc.getVariableId(), variableStateDesc.getVariableInstanceId(), variableStateDesc.getProcessInstanceId(), variableStateDesc.getOldValue(), variableStateDesc.getNewValue(), variableStateDesc.getDataTimeStamp().toString(), type));
        }
        if (!properties.isEmpty()) {
            for (Map.Entry entry : properties.entrySet()) {
                variablesSummary.add(new VariableSummary((String)entry.getKey(), "", processInstanceId, "", "", "", (String)entry.getValue()));
            }
        }
        return variablesSummary;
    }

    public static VariableSummary adapt(VariableStateDesc v) {
        return new VariableSummary(v.getVariableId(), v.getVariableInstanceId(), v.getProcessInstanceId(), v.getOldValue(), v.getNewValue(), v.getDataTimeStamp().toString(), "");
    }
}

