/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.backend.server.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jbpm.console.ng.pr.model.ProcessVariableSummary;
import org.kie.server.api.model.instance.VariableInstance;

public class VariableHelper {
    private static final List<String> excludedVariables = Arrays.asList("processId");

    public static List<ProcessVariableSummary> adaptCollection(List<VariableInstance> variables, Map<String, String> properties, long processInstanceId, String deploymentId, String serverTemplateId) {
        ArrayList<ProcessVariableSummary> variablesSummary = new ArrayList<ProcessVariableSummary>();
        for (VariableInstance variableInstance : variables) {
            if (excludedVariables.contains(variableInstance.getVariableName())) continue;
            String type = properties.remove(variableInstance.getVariableName());
            variablesSummary.add(new ProcessVariableSummary(variableInstance.getVariableName(), variableInstance.getVariableName(), variableInstance.getProcessInstanceId().longValue(), variableInstance.getOldValue(), variableInstance.getValue(), variableInstance.getDate().getTime(), type, deploymentId, serverTemplateId));
        }
        if (!properties.isEmpty()) {
            for (Map.Entry entry : properties.entrySet()) {
                variablesSummary.add(new ProcessVariableSummary((String)entry.getKey(), "", processInstanceId, "", "", new Date().getTime(), (String)entry.getValue(), deploymentId, serverTemplateId));
            }
        }
        return variablesSummary;
    }
}

