/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.forms.client.editors.quicknewinstance;

import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpBlock;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.event.HiddenEvent;
import com.github.gwtbootstrap.client.ui.event.HiddenHandler;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.ga.forms.display.GenericFormDisplayer;
import org.jbpm.console.ng.ga.forms.display.view.FormContentResizeListener;
import org.jbpm.console.ng.ga.forms.display.view.FormDisplayerView;
import org.jbpm.console.ng.ga.model.PortableQueryFilter;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.pr.forms.client.display.displayers.process.AbstractStartProcessFormDisplayer;
import org.jbpm.console.ng.pr.forms.client.display.providers.StartProcessFormDisplayProviderImpl;
import org.jbpm.console.ng.pr.forms.client.i18n.Constants;
import org.jbpm.console.ng.pr.forms.display.process.api.ProcessDisplayerConfig;
import org.jbpm.console.ng.pr.forms.display.process.api.StartProcessFormDisplayProvider;
import org.jbpm.console.ng.pr.model.ProcessDefinitionKey;
import org.jbpm.console.ng.pr.model.ProcessSummary;
import org.jbpm.console.ng.pr.service.ProcessDefinitionService;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class QuickNewProcessInstancePopup
extends BaseModal
implements FormDisplayerView {
    @UiField
    public FlowPanel processForm;
    @UiField
    public FlowPanel basicForm;
    @UiField
    public HelpBlock errorMessages;
    @UiField
    public ControlGroup errorMessagesGroup;
    @UiField
    public ControlGroup processDeploymentIdControlGroup = new ControlGroup();
    @UiField
    public ListBox processDeploymentIdListBox = new ListBox();
    @UiField
    public HelpBlock processDeploymentIdHelpLabel = new HelpBlock();
    @UiField
    public ControlGroup processDefinitionsControlGroup = new ControlGroup();
    @UiField
    public ListBox processDefinitionsListBox = new ListBox();
    @UiField
    public HelpBlock processDefinitionsHelpLabel = new HelpBlock();
    @UiField
    public FlowPanel body;
    @Inject
    User identity;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private Caller<ProcessDefinitionService> processDefinitionService;
    protected QueryFilter currentFilter;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private Long parentProcessInstanceId = -1L;
    @Inject
    private StartProcessFormDisplayProvider widgetPresenter;
    private Command onCloseCommand;
    private Command childCloseCommand;
    private FormContentResizeListener formContentResizeListener;
    private boolean initialized = false;
    private GenericFormDisplayer currentDisplayer;
    private int initialWidth = -1;
    private String deploymentId;
    private String processId;
    GenericModalFooter footer = new GenericModalFooter();
    @Inject
    protected StartProcessFormDisplayProviderImpl startProcessDisplayProvider;

    public QuickNewProcessInstancePopup() {
        this.setTitle(Constants.INSTANCE.Start_process_instance());
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public void show(Long parentProcessInstanceId) {
        this.show();
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    public void show() {
        this.init();
        this.loadFormValues();
        this.processForm.setVisible(false);
        this.basicForm.setVisible(true);
        super.show();
    }

    private void okButton() {
        if (this.validateForm()) {
            this.createNewProcessInstance();
        }
    }

    protected void loadFormValues() {
        final HashMap dropDowns = new HashMap();
        this.processDefinitionsListBox.clear();
        this.processDeploymentIdListBox.clear();
        this.currentFilter = new PortableQueryFilter(0, 10, false, "", "", true);
        ((ProcessDefinitionService)this.processDefinitionService.call((RemoteCallback)new RemoteCallback<List<ProcessSummary>>(){

            public void callback(List<ProcessSummary> processSummaries) {
                for (ProcessSummary sum : processSummaries) {
                    if (dropDowns.get(sum.getDeploymentId()) == null) {
                        dropDowns.put(sum.getDeploymentId(), new ArrayList());
                    }
                    ((List)dropDowns.get(sum.getDeploymentId())).add(sum.getProcessDefId());
                }
                QuickNewProcessInstancePopup.this.processDeploymentIdListBox.clear();
                QuickNewProcessInstancePopup.this.processDeploymentIdListBox.addItem("--------");
                QuickNewProcessInstancePopup.this.processDeploymentIdListBox.setSelectedIndex(0);
                for (String deploymentId : dropDowns.keySet()) {
                    QuickNewProcessInstancePopup.this.processDeploymentIdListBox.addItem(deploymentId);
                }
            }
        })).getAll(this.currentFilter);
        this.processDeploymentIdListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                QuickNewProcessInstancePopup.this.processDefinitionsListBox.clear();
                QuickNewProcessInstancePopup.this.processDefinitionsListBox.addItem("-------");
                QuickNewProcessInstancePopup.this.processDefinitionsListBox.setSelectedIndex(0);
                int selected = QuickNewProcessInstancePopup.this.processDeploymentIdListBox.getSelectedIndex();
                if (dropDowns.get(QuickNewProcessInstancePopup.this.processDeploymentIdListBox.getValue(selected)) != null) {
                    for (String processDef : (List)dropDowns.get(QuickNewProcessInstancePopup.this.processDeploymentIdListBox.getValue(selected))) {
                        QuickNewProcessInstancePopup.this.processDefinitionsListBox.addItem(processDef);
                    }
                }
            }
        });
    }

    private boolean validateForm() {
        boolean valid = true;
        this.clearErrorMessages();
        return valid;
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    private void createNewProcessInstance() {
        if (this.processDefinitionsListBox.getSelectedIndex() == 0) {
            this.errorMessages.setText(Constants.INSTANCE.Select_Process());
            this.errorMessagesGroup.setType(ControlGroupType.ERROR);
        } else {
            this.deploymentId = this.processDeploymentIdListBox.getValue();
            this.processId = this.processDefinitionsListBox.getValue();
            this.processForm.setVisible(true);
            this.basicForm.setVisible(false);
            ProcessDisplayerConfig config = new ProcessDisplayerConfig(new ProcessDefinitionKey(this.deploymentId, this.processId), this.processId);
            this.startProcessDisplayProvider.setup(config, this);
        }
    }

    private void clearErrorMessages() {
        this.errorMessages.setText("");
    }

    protected void init() {
        this.remove((Widget)this.footer);
        this.footer = new GenericModalFooter();
        this.footer.addButton(Constants.INSTANCE.Start(), new Command(){

            public void execute() {
                QuickNewProcessInstancePopup.this.okButton();
            }
        }, IconType.PLUS_SIGN, ButtonType.PRIMARY);
        this.add((Widget)this.footer);
        this.onCloseCommand = new Command(){

            public void execute() {
                QuickNewProcessInstancePopup.this.closePopup();
            }
        };
        this.formContentResizeListener = new FormContentResizeListener(){

            public void resize(int width, int height) {
                if (QuickNewProcessInstancePopup.this.initialWidth == -1 && QuickNewProcessInstancePopup.this.getOffsetWidth() > 0) {
                    QuickNewProcessInstancePopup.this.initialWidth = QuickNewProcessInstancePopup.this.getOffsetWidth();
                }
                if (width > QuickNewProcessInstancePopup.this.getOffsetWidth()) {
                    QuickNewProcessInstancePopup.this.setWidth(width + 20);
                } else if (QuickNewProcessInstancePopup.this.initialWidth != -1) {
                    QuickNewProcessInstancePopup.this.setWidth(QuickNewProcessInstancePopup.this.initialWidth);
                }
                QuickNewProcessInstancePopup.this.centerVertically((Element)QuickNewProcessInstancePopup.this.getElement());
            }
        };
        this.addHiddenHandler(new HiddenHandler(){

            public void onHidden(HiddenEvent hiddenEvent) {
                if (QuickNewProcessInstancePopup.this.initialized) {
                    QuickNewProcessInstancePopup.this.closePopup();
                }
            }
        });
    }

    public void display(GenericFormDisplayer displayer) {
        this.currentDisplayer = displayer;
        this.body.clear();
        this.body.add((Widget)displayer.getContainer());
        ((AbstractStartProcessFormDisplayer)displayer).setParentProcessInstanceId(this.parentProcessInstanceId);
        this.remove((Widget)this.footer);
        this.footer = new GenericModalFooter();
        if (displayer.getOpener() == null) {
            this.footer.add(displayer.getFooter());
        }
        this.add((Widget)this.footer);
        this.centerVertically((Element)this.getElement());
        this.initialized = true;
    }

    public void closePopup() {
        this.initialized = false;
        this.hide();
        super.hide();
    }

    private native void centerVertically(Element var1);

    public Command getOnCloseCommand() {
        return this.onCloseCommand;
    }

    public void setOnCloseCommand(Command onCloseCommand) {
        this.childCloseCommand = onCloseCommand;
    }

    public FormContentResizeListener getResizeListener() {
        return this.formContentResizeListener;
    }

    public void setResizeListener(FormContentResizeListener resizeListener) {
        this.formContentResizeListener = resizeListener;
    }

    public GenericFormDisplayer getCurrentDisplayer() {
        return this.currentDisplayer;
    }

    static interface Binder
    extends UiBinder<Widget, QuickNewProcessInstancePopup> {
    }
}

