/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.forms.client.display.views;

import com.github.gwtbootstrap.client.ui.ModalFooter;
import com.github.gwtbootstrap.client.ui.constants.BackdropType;
import com.github.gwtbootstrap.client.ui.event.HiddenEvent;
import com.github.gwtbootstrap.client.ui.event.HiddenHandler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jbpm.console.ng.ga.forms.display.GenericFormDisplayer;
import org.jbpm.console.ng.ga.forms.display.view.FormContentResizeListener;
import org.jbpm.console.ng.ga.forms.display.view.FormDisplayerView;
import org.jbpm.console.ng.pr.forms.display.process.api.StartProcessFormDisplayProvider;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.mvp.Command;

@Dependent
public class PopupFormDisplayerView
extends BaseModal
implements FormDisplayerView {
    @Inject
    private StartProcessFormDisplayProvider widgetPresenter;
    private Command onCloseCommand;
    private Command childCloseCommand;
    private FormContentResizeListener formContentResizeListener;
    private boolean initialized = false;
    private FlowPanel body = new FlowPanel();
    private ModalFooter footer = new ModalFooter();
    private GenericFormDisplayer currentDisplayer;
    private int initialWidth = -1;

    @PostConstruct
    protected void init() {
        this.onCloseCommand = new Command(){

            public void execute() {
                PopupFormDisplayerView.this.closePopup();
            }
        };
        this.formContentResizeListener = new FormContentResizeListener(){

            public void resize(int width, int height) {
                if (PopupFormDisplayerView.this.initialWidth == -1 && PopupFormDisplayerView.this.getOffsetWidth() > 0) {
                    PopupFormDisplayerView.this.initialWidth = PopupFormDisplayerView.this.getOffsetWidth();
                }
                if (width > PopupFormDisplayerView.this.getOffsetWidth()) {
                    PopupFormDisplayerView.this.setWidth(width + 20);
                } else if (PopupFormDisplayerView.this.initialWidth != -1) {
                    PopupFormDisplayerView.this.setWidth(PopupFormDisplayerView.this.initialWidth);
                }
                PopupFormDisplayerView.this.centerVertically((Element)PopupFormDisplayerView.this.getElement());
            }
        };
        this.add((Widget)this.body);
        this.add((Widget)this.footer);
        this.addHiddenHandler(new HiddenHandler(){

            public void onHidden(HiddenEvent hiddenEvent) {
                if (PopupFormDisplayerView.this.initialized) {
                    PopupFormDisplayerView.this.closePopup();
                }
            }
        });
    }

    public void display(GenericFormDisplayer displayer) {
        this.setBackdrop(BackdropType.NORMAL);
        this.setKeyboard(true);
        this.setAnimation(true);
        this.setDynamicSafe(true);
        this.currentDisplayer = displayer;
        this.body.clear();
        this.footer.clear();
        this.body.add((Widget)displayer.getContainer());
        if (displayer.getOpener() == null) {
            this.footer.add(displayer.getFooter());
        }
        this.centerVertically((Element)this.getElement());
        this.initialized = true;
        this.show();
    }

    public void closePopup() {
        this.hide();
        if (this.childCloseCommand != null) {
            this.childCloseCommand.execute();
        }
        this.setWidth("");
        this.initialized = false;
    }

    private native void centerVertically(Element var1);

    public Command getOnCloseCommand() {
        return this.onCloseCommand;
    }

    public void setOnCloseCommand(Command onCloseCommand) {
        this.childCloseCommand = onCloseCommand;
    }

    public FormContentResizeListener getResizeListener() {
        return this.formContentResizeListener;
    }

    public void setResizeListener(FormContentResizeListener resizeListener) {
        this.formContentResizeListener = resizeListener;
    }

    public GenericFormDisplayer getCurrentDisplayer() {
        return this.currentDisplayer;
    }
}

