/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.forms.client.editors.quicknewinstance;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.shared.event.ModalHiddenEvent;
import org.gwtbootstrap3.client.shared.event.ModalHiddenHandler;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.bd.model.ProcessDefinitionKey;
import org.jbpm.console.ng.bd.model.ProcessSummary;
import org.jbpm.console.ng.ga.forms.display.view.FormContentResizeListener;
import org.jbpm.console.ng.ga.model.PortableQueryFilter;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.gc.forms.client.display.GenericFormDisplayer;
import org.jbpm.console.ng.gc.forms.client.display.views.FormDisplayerView;
import org.jbpm.console.ng.pr.forms.client.display.displayers.process.AbstractStartProcessFormDisplayer;
import org.jbpm.console.ng.pr.forms.client.display.providers.StartProcessFormDisplayProviderImpl;
import org.jbpm.console.ng.pr.forms.client.i18n.Constants;
import org.jbpm.console.ng.pr.forms.display.process.api.ProcessDisplayerConfig;
import org.jbpm.console.ng.pr.service.ProcessRuntimeDataService;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class QuickNewProcessInstancePopup
extends BaseModal
implements FormDisplayerView {
    @UiField
    public FlowPanel processForm;
    @UiField
    public FlowPanel basicForm;
    @UiField
    public HelpBlock errorMessages;
    @UiField
    public FormGroup errorMessagesGroup;
    @UiField
    public FormGroup processDeploymentIdControlGroup = new FormGroup();
    @UiField
    public ListBox processDeploymentIdListBox = new ListBox();
    @UiField
    public HelpBlock processDeploymentIdHelpLabel = new HelpBlock();
    @UiField
    public FormGroup processDefinitionsControlGroup = new FormGroup();
    @UiField
    public ListBox processDefinitionsListBox = new ListBox();
    @UiField
    public HelpBlock processDefinitionsHelpLabel = new HelpBlock();
    @UiField
    public FlowPanel body;
    @Inject
    User identity;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private Caller<ProcessRuntimeDataService> processRuntimeDataService;
    protected QueryFilter currentFilter;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private Long parentProcessInstanceId = -1L;
    private Command onCloseCommand;
    private FormContentResizeListener formContentResizeListener;
    private boolean initialized = false;
    private GenericFormDisplayer currentDisplayer;
    private int initialWidth = -1;
    private String serverTemplateId;
    private String deploymentId;
    private String processId;
    GenericModalFooter footer = new GenericModalFooter();
    @Inject
    protected StartProcessFormDisplayProviderImpl startProcessDisplayProvider;

    public QuickNewProcessInstancePopup() {
        this.setTitle(Constants.INSTANCE.Start_process_instance());
        this.setBody((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public void show(Long parentProcessInstanceId) {
        this.show();
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    public void show(String serverTemplateId) {
        this.init();
        this.loadFormValues(serverTemplateId);
        this.processForm.setVisible(false);
        this.basicForm.setVisible(true);
        super.show();
    }

    private void okButton() {
        if (this.validateForm()) {
            this.createNewProcessInstance();
        }
    }

    protected void loadFormValues(String serverTemplateId) {
        this.serverTemplateId = serverTemplateId;
        final HashMap dropDowns = new HashMap();
        this.processDefinitionsListBox.clear();
        this.processDeploymentIdListBox.clear();
        this.currentFilter = new PortableQueryFilter(0, 10, false, "", "", true);
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call((RemoteCallback)new RemoteCallback<List<ProcessSummary>>(){

            public void callback(List<ProcessSummary> processSummaries) {
                for (ProcessSummary sum : processSummaries) {
                    if (dropDowns.get(sum.getDeploymentId()) == null) {
                        dropDowns.put(sum.getDeploymentId(), new ArrayList());
                    }
                    ((List)dropDowns.get(sum.getDeploymentId())).add(sum.getProcessDefId());
                }
                QuickNewProcessInstancePopup.this.processDeploymentIdListBox.clear();
                QuickNewProcessInstancePopup.this.processDeploymentIdListBox.addItem("--------");
                QuickNewProcessInstancePopup.this.processDeploymentIdListBox.setSelectedIndex(0);
                for (String deploymentId : dropDowns.keySet()) {
                    QuickNewProcessInstancePopup.this.processDeploymentIdListBox.addItem(deploymentId);
                }
            }
        })).getProcesses(serverTemplateId, Integer.valueOf(0), Integer.valueOf(1000), "", Boolean.valueOf(true));
        this.processDeploymentIdListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                QuickNewProcessInstancePopup.this.processDefinitionsListBox.clear();
                QuickNewProcessInstancePopup.this.processDefinitionsListBox.addItem("-------");
                QuickNewProcessInstancePopup.this.processDefinitionsListBox.setSelectedIndex(0);
                int selected = QuickNewProcessInstancePopup.this.processDeploymentIdListBox.getSelectedIndex();
                if (dropDowns.get(QuickNewProcessInstancePopup.this.processDeploymentIdListBox.getValue(selected)) != null) {
                    for (String processDef : (List)dropDowns.get(QuickNewProcessInstancePopup.this.processDeploymentIdListBox.getValue(selected))) {
                        QuickNewProcessInstancePopup.this.processDefinitionsListBox.addItem(processDef);
                    }
                }
            }
        });
    }

    private boolean validateForm() {
        boolean valid = true;
        this.clearErrorMessages();
        return valid;
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    private void createNewProcessInstance() {
        if (this.processDefinitionsListBox.getSelectedIndex() == 0) {
            this.errorMessages.setText(Constants.INSTANCE.Select_Process());
            this.errorMessagesGroup.setValidationState(ValidationState.ERROR);
        } else {
            this.deploymentId = this.processDeploymentIdListBox.getSelectedValue();
            this.processId = this.processDefinitionsListBox.getSelectedValue();
            this.processForm.setVisible(true);
            this.basicForm.setVisible(false);
            ProcessDisplayerConfig config = new ProcessDisplayerConfig(new ProcessDefinitionKey(this.serverTemplateId, this.deploymentId, this.processId), this.processId);
            this.startProcessDisplayProvider.setup(config, this);
        }
    }

    private void clearErrorMessages() {
        this.errorMessages.setText("");
    }

    protected void init() {
        this.removeFooter((ComplexPanel)this);
        this.footer = new GenericModalFooter();
        this.footer.addButton(Constants.INSTANCE.Start(), new Command(){

            public void execute() {
                QuickNewProcessInstancePopup.this.okButton();
            }
        }, IconType.PLUS, ButtonType.PRIMARY);
        this.add((Widget)this.footer);
        this.onCloseCommand = new Command(){

            public void execute() {
                QuickNewProcessInstancePopup.this.closePopup();
            }
        };
        this.formContentResizeListener = new FormContentResizeListener(){

            public void resize(int width, int height) {
                if (QuickNewProcessInstancePopup.this.initialWidth == -1 && QuickNewProcessInstancePopup.this.getWidget(0).getOffsetWidth() > 0) {
                    QuickNewProcessInstancePopup.this.initialWidth = QuickNewProcessInstancePopup.this.getWidget(0).getOffsetWidth();
                }
                if (width > QuickNewProcessInstancePopup.this.getWidget(0).getOffsetWidth()) {
                    QuickNewProcessInstancePopup.this.setWidth(width + 40 + "px");
                } else if (QuickNewProcessInstancePopup.this.initialWidth != -1) {
                    QuickNewProcessInstancePopup.this.setWidth(QuickNewProcessInstancePopup.this.initialWidth + "px");
                }
            }
        };
        this.addHiddenHandler(new ModalHiddenHandler(){

            public void onHidden(ModalHiddenEvent hiddenEvent) {
                if (QuickNewProcessInstancePopup.this.initialized) {
                    QuickNewProcessInstancePopup.this.closePopup();
                }
            }
        });
    }

    public void display(GenericFormDisplayer displayer) {
        this.currentDisplayer = displayer;
        this.body.clear();
        this.body.add((Widget)displayer.getContainer());
        ((AbstractStartProcessFormDisplayer)displayer).setParentProcessInstanceId(this.parentProcessInstanceId);
        this.removeFooter((ComplexPanel)this);
        this.footer = new GenericModalFooter();
        if (displayer.getOpener() == null) {
            this.footer.add(displayer.getFooter());
        }
        this.add((Widget)this.footer);
        this.initialized = true;
    }

    public void closePopup() {
        this.initialized = false;
        this.hide();
        super.hide();
    }

    private void removeFooter(ComplexPanel panel) {
        for (Widget widget : panel) {
            if (widget instanceof ModalFooter) {
                widget.removeFromParent();
                break;
            }
            if (!(widget instanceof ComplexPanel)) continue;
            this.removeFooter((ComplexPanel)widget);
        }
    }

    public Command getOnCloseCommand() {
        return this.onCloseCommand;
    }

    public void setOnCloseCommand(Command onCloseCommand) {
        this.onCloseCommand = onCloseCommand;
    }

    public FormContentResizeListener getResizeListener() {
        return this.formContentResizeListener;
    }

    public void setResizeListener(FormContentResizeListener resizeListener) {
        this.formContentResizeListener = resizeListener;
    }

    public GenericFormDisplayer getCurrentDisplayer() {
        return this.currentDisplayer;
    }

    static interface Binder
    extends UiBinder<Widget, QuickNewProcessInstancePopup> {
    }
}

