/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.forms.client.display.providers;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jbpm.console.ng.ga.forms.display.FormDisplayerConfig;
import org.jbpm.console.ng.ga.forms.display.FormRenderingSettings;
import org.jbpm.console.ng.ga.forms.service.shared.FormServiceEntryPoint;
import org.jbpm.console.ng.gc.forms.client.display.GenericFormDisplayer;
import org.jbpm.console.ng.gc.forms.client.display.views.FormDisplayerView;
import org.jbpm.console.ng.gc.forms.client.display.views.GenericFormDisplayView;
import org.jbpm.console.ng.pr.forms.client.display.process.api.StartProcessFormDisplayProvider;
import org.jbpm.console.ng.pr.forms.client.display.process.api.StartProcessFormDisplayer;
import org.jbpm.console.ng.pr.forms.client.i18n.Constants;
import org.jbpm.console.ng.pr.forms.display.process.api.ProcessDisplayerConfig;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class StartProcessFormDisplayProviderImpl
implements StartProcessFormDisplayProvider {
    protected Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    protected SyncBeanManager iocManager;
    @Inject
    private GenericFormDisplayView view;
    @Inject
    private Caller<FormServiceEntryPoint> formServices;
    private Map<Class<? extends FormRenderingSettings>, StartProcessFormDisplayer> processDisplayers = new HashMap<Class<? extends FormRenderingSettings>, StartProcessFormDisplayer>();

    @PostConstruct
    public void init() {
        this.processDisplayers.clear();
        Collection processDisplayersBeans = this.iocManager.lookupBeans(StartProcessFormDisplayer.class);
        if (processDisplayersBeans != null) {
            for (SyncBeanDef displayerDef : processDisplayersBeans) {
                StartProcessFormDisplayer displayer = (StartProcessFormDisplayer)displayerDef.getInstance();
                this.processDisplayers.put(displayer.getSupportedRenderingSettings(), displayer);
            }
        }
    }

    @Override
    public void setup(ProcessDisplayerConfig config, FormDisplayerView view) {
        this.display(config, view);
    }

    protected void display(final ProcessDisplayerConfig config, final FormDisplayerView view) {
        if (this.processDisplayers != null) {
            ((FormServiceEntryPoint)this.formServices.call((RemoteCallback)new RemoteCallback<FormRenderingSettings>(){

                public void callback(FormRenderingSettings settings) {
                    if (settings == null) {
                        ErrorPopup.showMessage((String)StartProcessFormDisplayProviderImpl.this.constants.UnableToFindFormForProcess(config.getProcessName()));
                    } else {
                        StartProcessFormDisplayer displayer = (StartProcessFormDisplayer)StartProcessFormDisplayProviderImpl.this.processDisplayers.get(settings.getClass());
                        if (displayer != null) {
                            config.setRenderingSettings(settings);
                            displayer.init((FormDisplayerConfig)config, view.getOnCloseCommand(), new Command(){

                                public void execute() {
                                    StartProcessFormDisplayProviderImpl.this.display(config, view);
                                }
                            }, view.getResizeListener());
                            view.display((GenericFormDisplayer)displayer);
                        }
                    }
                }
            })).getFormDisplayProcess(config.getKey().getServerTemplateId(), config.getKey().getDeploymentId(), config.getKey().getProcessId());
        }
    }

    public IsWidget getView() {
        return this.view;
    }
}

