/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.rest;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.process.svg.SVGImageProcessor;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/runtime/{deploymentId: [\\w\\.-]+(:[\\w\\.-]+){2,2}(:[\\w\\.-]*){0,2}}/process/{processDefId: [_a-zA-Z0-9-:\\.]+}/image")
@ApplicationScoped
public class ProcessImageResourceImpl {
    private static Logger logger = LoggerFactory.getLogger(ProcessImageResourceImpl.class);
    @Context
    private HttpHeaders headers;
    @Inject
    private GuvnorM2Repository repository;
    @Inject
    private RuntimeDataService dataService;

    public void setRepository(GuvnorM2Repository repository) {
        this.repository = repository;
    }

    public void setRuntimeDataService(RuntimeDataService dataService) {
        this.dataService = dataService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProcesImageSVGFromDeployment(String deploymentId, ProcessDefinition procDef) {
        String procDefSvg = null;
        String svgFileName = ((ProcessAssetDesc)procDef).getId();
        svgFileName = svgFileName + "-svg.svg";
        String[] depIdParts = deploymentId.split(":");
        File depFile = this.repository.getArtifactFileFromRepository(new GAV(depIdParts[0], depIdParts[1], depIdParts[2]));
        if (depFile != null) {
            JarFile depJarFile = null;
            try {
                depJarFile = new JarFile(depFile);
                Enumeration<JarEntry> entries = depJarFile.entries();
                while (entries.hasMoreElements()) {
                    int index;
                    JarEntry jarEntry = entries.nextElement();
                    String entryName = jarEntry.getName();
                    if (!entryName.endsWith("svg") || !(entryName = entryName.substring(index = (index = entryName.lastIndexOf(47)) >= 0 ? index + 1 : 0)).equals(svgFileName)) continue;
                    InputStream svgInputStream = depJarFile.getInputStream(jarEntry);
                    procDefSvg = IOUtils.toString((InputStream)svgInputStream);
                    break;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (depJarFile != null) {
                    try {
                        depJarFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return procDefSvg;
    }

    @GET
    @Path(value="/")
    public Response getProcessImage(@PathParam(value="deploymentId") String deploymentId, @PathParam(value="processDefId") String processId) {
        ProcessDefinition procDef = this.dataService.getProcessesByDeploymentIdProcessId(deploymentId, processId);
        if (procDef == null) {
            logger.warn("Could not find process definition for process '" + processId + "', returning status 404 (NOT FOUND)");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String imageSVGString = this.getProcesImageSVGFromDeployment(deploymentId, procDef);
        if (imageSVGString == null) {
            logger.warn("Could not find SVG image file for process '" + processId + "', returning status 412 (PRECONDITION FAILED). Has the 'storesvgonsave' option in the jbpm.xml file in the war been set to true?");
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        return Response.ok((Object)imageSVGString, (MediaType)MediaType.APPLICATION_SVG_XML_TYPE).build();
    }

    @GET
    @Path(value="/{procInstId: [0-9]+}")
    public Response getActiveProcessImage(@PathParam(value="deploymentId") String deploymentId, @PathParam(value="processDefId") String processId, @PathParam(value="procInstId") long procInstId) {
        ProcessDefinition procDef = this.dataService.getProcessesByDeploymentIdProcessId(deploymentId, processId);
        if (procDef == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String imageSVGString = this.getProcesImageSVGFromDeployment(deploymentId, procDef);
        if (imageSVGString == null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        Collection logs = this.dataService.getProcessInstanceFullHistory(procInstId, null);
        ArrayList<String> active = new ArrayList<String>(2);
        ArrayList<String> completed = new ArrayList<String>(logs.size() / 2);
        for (NodeInstanceDesc nodeLog : logs) {
            String nodeId = nodeLog.getNodeId();
            if (0 == ((org.jbpm.kie.services.impl.model.NodeInstanceDesc)nodeLog).getType()) {
                active.add(nodeId);
                continue;
            }
            completed.add(nodeId);
        }
        imageSVGString = SVGImageProcessor.transform((InputStream)new ByteArrayInputStream(imageSVGString.getBytes()), completed, active);
        return Response.ok((Object)imageSVGString, (MediaType)MediaType.APPLICATION_SVG_XML_TYPE).build();
    }
}

