/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.rest;

import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.jbpm.console.ng.rest.JbpmConsoleNgRestBaseIntegrationTest;
import org.jbpm.console.ng.rest.ProcessImageResourceImpl;
import org.jbpm.kie.services.impl.model.NodeInstanceDesc;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessImageResourceTest
extends JbpmConsoleNgRestBaseIntegrationTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessImageResourceTest.class);

    @Test
    public void depOrProcNotFound() throws Exception {
        int code;
        Response resp;
        String badDeploymentId = "org.test:not-there:0-SNAPSHOT";
        String badProcessId = "is.a.process.not.a.process";
        String uriStr = "http://localhost:" + PORT + "/runtime/" + badDeploymentId + "/process/" + "org.test.process" + "/image";
        Request request = Request.Get((String)uriStr);
        try {
            resp = request.execute();
            code = resp.returnResponse().getStatusLine().getStatusCode();
            Assert.assertEquals((String)"Incorrect HTTP error code:", (long)404L, (long)code);
        }
        catch (Exception e) {
            logger.error("[GET] " + uriStr + " FAILED", (Throwable)e);
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
        uriStr = "http://localhost:" + PORT + "/runtime/" + DEPLOYMENT_ID + "/process/" + badProcessId + "/image";
        request = Request.Get((String)uriStr);
        try {
            resp = request.execute();
            code = resp.returnResponse().getStatusLine().getStatusCode();
            Assert.assertEquals((String)"Incorrect HTTP error code:", (long)404L, (long)code);
        }
        catch (Exception e) {
            logger.error("[GET] " + uriStr + " FAILED", (Throwable)e);
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void procDefSVGNotAvailable() throws Exception {
        String procId = "org.test.error";
        String uriStr = "http://localhost:" + PORT + "/runtime/" + DEPLOYMENT_ID + "/process/" + procId + "/image";
        Request request = Request.Get((String)uriStr);
        try {
            Response resp = request.execute();
            int code = resp.returnResponse().getStatusLine().getStatusCode();
            Assert.assertEquals((String)"Incorrect HTTP error code:", (long)412L, (long)code);
        }
        catch (Exception e) {
            logger.error("[GET] " + uriStr + " FAILED", (Throwable)e);
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void getProcessDefinitionSVG() throws Exception {
        String uriStr = "http://localhost:" + PORT + "/runtime/" + DEPLOYMENT_ID + "/process/" + "org.test.process" + "/image";
        Request request = Request.Get((String)uriStr);
        String contentStr = null;
        try {
            Response resp = request.execute();
            contentStr = resp.returnContent().toString();
        }
        catch (Exception e) {
            logger.error("[GET] " + uriStr + " FAILED", (Throwable)e);
            Assert.fail((String)("Unable to complete request: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"Null response content string", (Object)contentStr);
        Assert.assertFalse((String)"Empty response content string", (boolean)contentStr.trim().isEmpty());
        InputStream origSvgInputStream = this.getClass().getResourceAsStream("/kjar/org.test.process-svg.svg");
        Assert.assertNotNull((String)"Null response content string", (Object)contentStr);
        String origContent = IOUtils.toString((InputStream)origSvgInputStream);
        Assert.assertEquals((Object)origContent, (Object)contentStr);
    }

    @Test
    public void testProcessNodeInstances() {
        ProcessImageResourceImpl imageResource = new ProcessImageResourceImpl();
        ArrayList<NodeInstanceDesc> logs = new ArrayList<NodeInstanceDesc>();
        NodeInstanceDesc startA = new NodeInstanceDesc("1", "node1", "start", "", "", 1L, null, null, 0, null);
        NodeInstanceDesc startC = new NodeInstanceDesc("1", "node1", "start", "", "", 1L, null, null, 1, null);
        NodeInstanceDesc taskA = new NodeInstanceDesc("2", "node2", "task", "", "", 1L, null, null, 0, null);
        NodeInstanceDesc taskC = new NodeInstanceDesc("2", "node2", "task", "", "", 1L, null, null, 1, null);
        NodeInstanceDesc task2A = new NodeInstanceDesc("3", "node3", "task2", "", "", 1L, null, null, 0, null);
        logs.add(startA);
        logs.add(startC);
        logs.add(taskA);
        logs.add(taskC);
        logs.add(task2A);
        ArrayList active = new ArrayList(2);
        ArrayList completed = new ArrayList(logs.size() / 2);
        imageResource.processNodeInstances(logs, active, completed);
        Assert.assertEquals((long)2L, (long)completed.size());
        Assert.assertEquals((long)1L, (long)active.size());
        for (String id : completed) {
            Assert.assertFalse((boolean)active.contains(id));
        }
    }
}

