/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.workbench.forms.display.backend.provider;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Instance;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.jbpm.console.ng.ga.forms.service.providing.RenderingSettings;
import org.jbpm.console.ng.workbench.forms.display.api.KieWorkbenchFormRenderingSettings;
import org.jbpm.console.ng.workbench.forms.display.backend.provider.KieWorkbenchFormsProvider;
import org.jbpm.console.ng.workbench.forms.display.backend.provider.KieWorkbenchFormsValuesProcessor;
import org.junit.Before;
import org.junit.Test;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.BackendFormRenderingContextManagerImpl;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.FormValuesProcessorImpl;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.fieldProcessors.MultipleSubFormFieldValueProcessor;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.fieldProcessors.SubFormFieldValueProcessor;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContextManager;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.FieldValueProcessor;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.FormValuesProcessor;
import org.kie.workbench.common.forms.serialization.FormDefinitionSerializer;
import org.kie.workbench.common.forms.serialization.impl.FieldSerializer;
import org.kie.workbench.common.forms.serialization.impl.FormDefinitionSerializerImpl;
import org.kie.workbench.common.forms.serialization.impl.FormModelSerializer;
import org.mockito.Mock;
import org.mockito.Mockito;

public abstract class AbstractFormProvidingEngineTest<R extends RenderingSettings, T extends KieWorkbenchFormsValuesProcessor<R>> {
    @Mock
    protected ContentMarshallerContext marshallerContext;
    protected FormDefinitionSerializer formSerializer;
    protected BackendFormRenderingContextManager contextManager;
    protected FormValuesProcessor formValuesProcessor;
    protected T processor;
    protected R settings;
    protected KieWorkbenchFormsProvider workbenchFormsProvider;

    @Before
    public void initTest() {
        Mockito.when((Object)this.marshallerContext.getClassloader()).thenReturn((Object)AbstractFormProvidingEngineTest.class.getClassLoader());
        this.formSerializer = new FormDefinitionSerializerImpl(new FieldSerializer(), new FormModelSerializer());
        this.contextManager = new BackendFormRenderingContextManagerImpl();
        List<FieldValueProcessor> processors = Arrays.asList(new SubFormFieldValueProcessor(), new MultipleSubFormFieldValueProcessor());
        Instance fieldValueProcessors = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)fieldValueProcessors.iterator()).then(proc -> processors.iterator());
        this.formValuesProcessor = new FormValuesProcessorImpl(fieldValueProcessors);
        this.settings = this.generateSettigns();
        this.processor = this.getProcessorInstance(this.formSerializer, this.contextManager, this.formValuesProcessor);
        this.initFormsProvider();
    }

    protected abstract void initFormsProvider();

    protected abstract R generateSettigns();

    protected abstract T getProcessorInstance(FormDefinitionSerializer var1, BackendFormRenderingContextManager var2, FormValuesProcessor var3);

    protected abstract Map<String, Object> getFormValues();

    protected abstract void checkRuntimeValues(Map<String, Object> var1);

    @Test
    public void testGenerateRenderingContext() {
        this.generateRenderingSettings();
    }

    protected KieWorkbenchFormRenderingSettings generateRenderingSettings() {
        KieWorkbenchFormRenderingSettings settings = this.processor.generateRenderingContext(this.settings);
        this.checkRenderingSettings(settings);
        return settings;
    }

    protected void checkRenderingSettings(KieWorkbenchFormRenderingSettings settings) {
        TestCase.assertNotNull((String)"Settings cannot be null", (Object)settings);
        TestCase.assertNotNull((String)"There should be a backend context", (Object)this.contextManager.getContext(settings.getTimestamp()));
        TestCase.assertFalse((String)"There should exist some forms...", (boolean)settings.getRenderingContext().getAvailableForms().isEmpty());
        TestCase.assertNotNull((String)"A root form should exist", (Object)settings.getRenderingContext().getRootForm());
    }

    @Test
    public void testGenerateRuntimeValuesMap() {
        KieWorkbenchFormRenderingSettings settings = this.generateRenderingSettings();
        Map result = this.processor.generateRuntimeValuesMap(settings.getTimestamp().longValue(), this.getFormValues());
        TestCase.assertNotNull((String)"Result values cannot be null", (Object)result);
        TestCase.assertFalse((String)"Result cannot be empty", (boolean)result.isEmpty());
        TestCase.assertNull((String)"Backend context should be removed", (Object)this.contextManager.getContext(settings.getTimestamp()));
        this.checkRuntimeValues(result);
    }

    protected String getFormContent() {
        try {
            JsonArray formsArray = new JsonArray();
            JsonParser parser = new JsonParser();
            String content = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/forms/Client.frm"));
            formsArray.add(parser.parse(content));
            content = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/forms/InvoiceLine.frm"));
            formsArray.add(parser.parse(content));
            content = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/forms/Invoice.frm"));
            formsArray.add(parser.parse(content));
            content = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/forms/invoices-taskform.frm"));
            formsArray.add(parser.parse(content));
            content = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/forms/modify-taskform.frm"));
            formsArray.add(parser.parse(content));
            Gson gson = new Gson();
            return gson.toJson((JsonElement)formsArray);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

