/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.workbench.forms.display.backend.impl;

import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.ht.service.TaskService;
import org.jbpm.console.ng.pr.service.ProcessService;
import org.jbpm.console.ng.workbench.forms.display.backend.provider.ProcessFormsValuesProcessor;
import org.jbpm.console.ng.workbench.forms.display.backend.provider.TaskFormValuesProcessor;
import org.jbpm.console.ng.workbench.forms.display.service.KieWorkbenchFormsEntryPoint;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContextManager;

@Service
@Dependent
public class KieWorkbenchFormEntryPointImpl
implements KieWorkbenchFormsEntryPoint {
    private ProcessService processService;
    private TaskService taskService;
    private ProcessFormsValuesProcessor processRenderingSettingsInterpreter;
    private TaskFormValuesProcessor taskRenderingSettingsInterpreter;
    private BackendFormRenderingContextManager contextManager;

    @Inject
    public KieWorkbenchFormEntryPointImpl(ProcessService processService, TaskService taskService, ProcessFormsValuesProcessor processRenderingSettingsInterpreter, TaskFormValuesProcessor taskRenderingSettingsInterpreter, BackendFormRenderingContextManager contextManager) {
        this.processService = processService;
        this.taskService = taskService;
        this.processRenderingSettingsInterpreter = processRenderingSettingsInterpreter;
        this.taskRenderingSettingsInterpreter = taskRenderingSettingsInterpreter;
        this.contextManager = contextManager;
    }

    public Long startProcessFromRenderContext(Long timestamp, Map<String, Object> formData, String serverTemplateId, String containerId, String processId, String correlationKey) {
        Map<String, Object> data = this.processRenderingSettingsInterpreter.generateRuntimeValuesMap(timestamp, formData);
        return this.processService.startProcess(serverTemplateId, containerId, processId, correlationKey, data);
    }

    public void saveTaskStateFromRenderContext(Long timestamp, Map<String, Object> formData, String serverTemplateId, String containerId, Long taskId) {
        Map<String, Object> data = this.taskRenderingSettingsInterpreter.generateRuntimeValuesMap(timestamp, formData);
        this.taskService.saveTaskContent(serverTemplateId, containerId, taskId, data);
    }

    public void completeTaskFromContext(Long timestamp, Map<String, Object> formData, String serverTemplateId, String containerId, Long taskId) {
        Map<String, Object> data = this.taskRenderingSettingsInterpreter.generateRuntimeValuesMap(timestamp, formData);
        this.taskService.completeTask(serverTemplateId, containerId, taskId, data);
    }

    public void clearContext(long timestamp) {
        this.contextManager.removeContext(Long.valueOf(timestamp));
    }
}

