/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.workbench.forms.display.backend.provider;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.console.ng.ga.forms.service.providing.RenderingSettings;
import org.jbpm.console.ng.workbench.forms.display.api.KieWorkbenchFormRenderingSettings;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContext;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContextManager;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.FormValuesProcessor;
import org.kie.workbench.common.forms.dynamic.service.shared.impl.MapModelRenderingContext;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.serialization.FormDefinitionSerializer;
import org.slf4j.Logger;

public abstract class KieWorkbenchFormsValuesProcessor<T extends RenderingSettings> {
    protected FormDefinitionSerializer formSerializer;
    protected BackendFormRenderingContextManager contextManager;
    protected FormValuesProcessor formValuesProcessor;

    public KieWorkbenchFormsValuesProcessor(FormDefinitionSerializer formSerializer, BackendFormRenderingContextManager contextManager, FormValuesProcessor formValuesProcessor) {
        this.formSerializer = formSerializer;
        this.contextManager = contextManager;
        this.formValuesProcessor = formValuesProcessor;
    }

    public KieWorkbenchFormRenderingSettings generateRenderingContext(T settings) {
        if (!StringUtils.isEmpty((CharSequence)settings.getFormContent())) {
            try {
                MapModelRenderingContext renderingContext = new MapModelRenderingContext();
                this.initializeContextForms(settings, renderingContext);
                if (!this.isValid(renderingContext.getRootForm())) {
                    return null;
                }
                Map<String, Object> rawData = this.generateRawFormData(settings, renderingContext);
                BackendFormRenderingContext context = this.contextManager.registerContext(renderingContext, rawData, settings.getMarshallerContext().getClassloader());
                Map<String, Object> formData = this.generateFormData(rawData, context);
                renderingContext.setModel(formData);
                this.prepareContext(settings, renderingContext);
                return new KieWorkbenchFormRenderingSettings(context.getTimestamp(), renderingContext);
            }
            catch (Exception ex) {
                this.getLogger().debug("Unable to generate render form: ", (Throwable)ex);
            }
        }
        return null;
    }

    public Map<String, Object> generateRuntimeValuesMap(long timestamp, Map<String, Object> formValues) {
        FormDefinition form;
        BackendFormRenderingContext context = this.contextManager.getContext(Long.valueOf(timestamp));
        if (context != null && this.isValid(form = context.getRenderingContext().getRootForm())) {
            this.contextManager.removeContext(Long.valueOf(timestamp));
            return this.getOutputValues(this.formValuesProcessor.writeFormValues(form, formValues, context.getFormData(), context), form);
        }
        throw new IllegalArgumentException("Unable read form values for context '" + timestamp + "'. Form Values: " + formValues);
    }

    protected abstract Map<String, Object> getOutputValues(Map<String, Object> var1, FormDefinition var2);

    protected abstract void prepareContext(T var1, MapModelRenderingContext var2);

    protected void initializeContextForms(T settings, MapModelRenderingContext renderingContext) {
        JsonParser parser = new JsonParser();
        Gson gson = new Gson();
        JsonElement element = parser.parse(settings.getFormContent());
        JsonArray forms = element.getAsJsonArray();
        forms.forEach(jsonForm -> {
            FormDefinition formDefinition;
            String content = gson.toJson(jsonForm);
            if (!StringUtils.isEmpty((CharSequence)content) && (formDefinition = this.formSerializer.deserialize(content)) != null) {
                if (formDefinition.getName().startsWith(this.getFormName(settings) + "-taskform")) {
                    renderingContext.setRootForm(formDefinition);
                } else {
                    renderingContext.getAvailableForms().put(formDefinition.getId(), formDefinition);
                }
            }
        });
    }

    protected abstract boolean isValid(FormDefinition var1);

    protected abstract String getFormName(T var1);

    protected Map<String, Object> generateRawFormData(T settings, MapModelRenderingContext renderingContext) {
        return new HashMap<String, Object>();
    }

    protected Map<String, Object> generateFormData(Map<String, Object> rawData, BackendFormRenderingContext context) {
        return new HashMap<String, Object>();
    }

    protected abstract Logger getLogger();
}

