/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.workbench.forms.display.backend.provider;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.console.ng.ga.forms.service.providing.TaskRenderingSettings;
import org.jbpm.console.ng.workbench.forms.display.backend.provider.KieWorkbenchFormsValuesProcessor;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContext;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContextManager;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.FormValuesProcessor;
import org.kie.workbench.common.forms.dynamic.service.shared.RenderMode;
import org.kie.workbench.common.forms.dynamic.service.shared.impl.MapModelRenderingContext;
import org.kie.workbench.common.forms.jbpm.model.authoring.task.TaskFormModel;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.serialization.FormDefinitionSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class TaskFormValuesProcessor
extends KieWorkbenchFormsValuesProcessor<TaskRenderingSettings> {
    private static final Logger logger = LoggerFactory.getLogger(TaskFormValuesProcessor.class);

    @Inject
    public TaskFormValuesProcessor(FormDefinitionSerializer formSerializer, BackendFormRenderingContextManager contextManager, FormValuesProcessor formValuesProcessor) {
        super(formSerializer, contextManager, formValuesProcessor);
    }

    @Override
    protected String getFormName(TaskRenderingSettings settings) {
        return settings.getTask().getFormName();
    }

    @Override
    protected Map<String, Object> getOutputValues(Map<String, Object> values, FormDefinition form) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isValid(form)) {
            TaskFormModel model = (TaskFormModel)form.getModel();
            model.getVariables().forEach(var -> {
                if (!StringUtils.isEmpty((CharSequence)var.getOuputMapping())) {
                    result.put(var.getOuputMapping(), values.get(var.getName()));
                }
            });
        }
        return result;
    }

    @Override
    protected void prepareContext(TaskRenderingSettings settings, MapModelRenderingContext context) {
        context.setRenderMode(!"InProgress".equals(settings.getTask().getStatus()) ? RenderMode.READ_ONLY_MODE : RenderMode.EDIT_MODE);
    }

    @Override
    protected Map<String, Object> generateRawFormData(TaskRenderingSettings settings, MapModelRenderingContext renderingContext) {
        HashMap<String, Object> formData = new HashMap<String, Object>();
        FormDefinition form = renderingContext.getRootForm();
        if (this.isValid(form)) {
            boolean includeOutputs = settings.getTask().isOutputIncluded();
            Map inputs = settings.getInputs();
            Map outputs = settings.getOutputs();
            TaskFormModel formModel = (TaskFormModel)form.getModel();
            formModel.getVariables().forEach(taskVariable -> {
                Object value = null;
                value = includeOutputs && !StringUtils.isEmpty((CharSequence)taskVariable.getOuputMapping()) ? (Object)outputs.get(taskVariable.getOuputMapping()) : (Object)inputs.get(taskVariable.getInputMapping());
                formData.put(taskVariable.getName(), value);
            });
        }
        return formData;
    }

    @Override
    protected Map<String, Object> generateFormData(Map<String, Object> rawData, BackendFormRenderingContext context) {
        return this.formValuesProcessor.readFormValues(context.getRenderingContext().getRootForm(), rawData, context);
    }

    @Override
    protected boolean isValid(FormDefinition rootForm) {
        return rootForm != null && rootForm.getModel() instanceof TaskFormModel;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

