/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.wi.dd;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jbpm.console.ng.wi.dd.model.DeploymentDescriptorModel;
import org.junit.Assert;
import org.junit.Test;
import org.kie.internal.runtime.conf.DeploymentDescriptor;

public class DeploymentDescriptorModelTest {
    @Test
    public void compareDeploymentDescriptorInterfaceToModel() throws Exception {
        List<String> skipMethods = Arrays.asList("getAuditPersistenceUnit", "getBuilder", "toXml", "getClasses", "getPersistenceUnit");
        Method[] methods = DeploymentDescriptor.class.getMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Method method : methods) {
            String methodName = method.getName();
            if (skipMethods.contains(methodName)) continue;
            boolean found = false;
            for (Method modelMethod : DeploymentDescriptorModel.class.getMethods()) {
                if (!modelMethod.getName().equals(methodName)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("Could not find method '" + methodName + "' in model, is it missing?"), (boolean)found);
        }
    }
}

