/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.wi.backend.server.dd;

import java.util.ArrayList;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.jbpm.console.ng.wi.backend.server.dd.DDConfigUpdaterHelper;
import org.jbpm.console.ng.wi.backend.server.dd.DDEditorServiceImpl;
import org.jbpm.console.ng.wi.dd.model.DeploymentDescriptorModel;
import org.jbpm.console.ng.wi.dd.model.ItemObjectModel;
import org.jbpm.console.ng.wi.dd.service.DDEditorService;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@ApplicationScoped
public class DDConfigUpdater {
    private KieProjectService projectService;
    private IOService ioService;
    private DDEditorService ddEditorService;
    private DDConfigUpdaterHelper configUpdaterHelper;

    public DDConfigUpdater() {
    }

    @Inject
    public DDConfigUpdater(DDEditorService ddEditorService, KieProjectService projectService, @Named(value="ioStrategy") IOService ioService, DDConfigUpdaterHelper configUpdaterHelper) {
        this.ddEditorService = ddEditorService;
        this.projectService = projectService;
        this.ioService = ioService;
        this.configUpdaterHelper = configUpdaterHelper;
    }

    public void processResourceAdd(@Observes ResourceAddedEvent resourceAddedEvent) {
        if (this.configUpdaterHelper.isPersistenceFile(resourceAddedEvent.getPath())) {
            this.updateConfig((KieProject)this.projectService.resolveProject(resourceAddedEvent.getPath()));
        }
    }

    public void processResourceUpdate(@Observes ResourceUpdatedEvent resourceUpdatedEvent) {
        if (this.configUpdaterHelper.isPersistenceFile(resourceUpdatedEvent.getPath())) {
            this.updateConfig((KieProject)this.projectService.resolveProject(resourceUpdatedEvent.getPath()));
        }
    }

    private void updateConfig(KieProject kieProject) {
        Path deploymentDescriptorPath = PathFactory.newPath((String)"kie-deployment-descriptor.xml", (String)(kieProject.getRootPath().toURI() + "/src/main/resources/META-INF/kie-deployment-descriptor.xml"));
        if (this.ioService.exists(Paths.convert((Path)deploymentDescriptorPath))) {
            DeploymentDescriptorModel descriptorModel = (DeploymentDescriptorModel)this.ddEditorService.load(deploymentDescriptorPath);
            this.updateMarshallingConfig(descriptorModel, deploymentDescriptorPath, kieProject);
        }
    }

    private void updateMarshallingConfig(DeploymentDescriptorModel descriptorModel, Path path, KieProject kieProject) {
        String marshallingValue = this.configUpdaterHelper.buildJPAMarshallingStrategyValue(kieProject);
        if (marshallingValue != null && descriptorModel != null) {
            ItemObjectModel oldMarshallingStrategy = null;
            if (descriptorModel.getMarshallingStrategies() != null) {
                for (ItemObjectModel itemModel : descriptorModel.getMarshallingStrategies()) {
                    if (itemModel.getValue() == null || !itemModel.getValue().contains("org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy")) continue;
                    oldMarshallingStrategy = itemModel;
                    break;
                }
                if (oldMarshallingStrategy != null) {
                    descriptorModel.getMarshallingStrategies().remove(oldMarshallingStrategy);
                }
            } else {
                descriptorModel.setMarshallingStrategies(new ArrayList());
            }
            ItemObjectModel marshallingStrategy = new ItemObjectModel();
            marshallingStrategy.setResolver("mvel");
            marshallingStrategy.setValue(marshallingValue);
            descriptorModel.getMarshallingStrategies().add(marshallingStrategy);
            CommentedOption commentedOption = new CommentedOption("system", null, "JPA marshalling strategy added by system", new Date());
            ((DDEditorServiceImpl)this.ddEditorService).save(path, descriptorModel, descriptorModel.getOverview().getMetadata(), commentedOption);
        }
    }
}

