/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.wi.backend.server.dd;

import java.util.ArrayList;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.Project;
import org.jbpm.console.ng.bd.backend.server.dd.DeploymentDescriptorImpl;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorModel;
import org.kie.workbench.common.screens.datamodeller.service.PersistenceDescriptorService;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;

@ApplicationScoped
public class DDConfigUpdaterHelper {
    private KieProjectService projectService;
    private IOService ioService;
    private PersistenceDescriptorService pdService;

    public DDConfigUpdaterHelper() {
    }

    @Inject
    public DDConfigUpdaterHelper(KieProjectService projectService, @Named(value="ioStrategy") IOService ioService, PersistenceDescriptorService pdService) {
        this.projectService = projectService;
        this.pdService = pdService;
        this.ioService = ioService;
    }

    public boolean isPersistenceFile(Path path) {
        KieProject kieProject;
        if (path.getFileName().equals("persistence.xml") && (kieProject = (KieProject)this.projectService.resolveProject(path)) != null && kieProject.getRootPath() != null) {
            String persistenceURI = kieProject.getRootPath().toURI() + "/src/main/resources/META-INF/persistence.xml";
            return persistenceURI.equals(path.toURI());
        }
        return false;
    }

    public boolean hasPersistenceFile(Path path) {
        KieProject kieProject = (KieProject)this.projectService.resolveProject(path);
        if (kieProject != null && kieProject.getRootPath() != null) {
            String persistenceURI = kieProject.getRootPath().toURI() + "/src/main/resources/META-INF/persistence.xml";
            Path persistencePath = PathFactory.newPath((String)"persistence.xml", (String)persistenceURI);
            return this.ioService.exists(Paths.convert((Path)persistencePath));
        }
        return false;
    }

    public String buildJPAMarshallingStrategyValue(KieProject kieProject) {
        PersistenceDescriptorModel pdModel = this.pdService.load((Project)kieProject);
        if (pdModel != null) {
            return "new org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy(\"" + pdModel.getPersistenceUnit().getName() + "\", classLoader)";
        }
        return null;
    }

    public void addJPAMarshallingStrategy(DeploymentDescriptor dd, Path path) {
        KieProject kieProject = (KieProject)this.projectService.resolveProject(path);
        String marshalingValue = null;
        if (kieProject != null && (marshalingValue = this.buildJPAMarshallingStrategyValue(kieProject)) != null) {
            ArrayList<ObjectModel> marshallingStrategies = new ArrayList<ObjectModel>();
            ObjectModel objectModel = new ObjectModel();
            objectModel.setResolver("mvel");
            objectModel.setIdentifier(marshalingValue);
            marshallingStrategies.add(objectModel);
            ((DeploymentDescriptorImpl)dd).setMarshallingStrategies(marshallingStrategies);
        }
    }
}

